/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.opplugin.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.business.opservice.ITmcBizOppService;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.TmcOperationServicePlugIn;
import kd.tmc.fpm.business.validate.dimension.MemberSaveValidator;
import kd.tmc.fpm.business.validate.dimension.SubjectMemberSaveValidator;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;

public class MemberSaveOp
extends TmcOperationServicePlugIn {
    public AbstractTmcBizOppValidator[] getBizOppValidators() {
        return new AbstractTmcBizOppValidator[]{new MemberSaveValidator(), new SubjectMemberSaveValidator()};
    }

    public ITmcBizOppService getBizOppService() {
        return new AbstractTmcBizOppService(){

            public List<String> getSelector() {
                List selector = super.getSelector();
                selector.add("dimension");
                selector.add("sumtype");
                return selector;
            }

            public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
                super.beforeCommit(dataEntities);
            }

            public void process(DynamicObject[] dataEntities) throws KDException {
                if (dataEntities.length == 0) {
                    return;
                }
                List memberParentIdList = Arrays.stream(dataEntities).filter(v -> Objects.nonNull(v.getDynamicObject("parent"))).map(v -> v.getDynamicObject("parent").getPkValue()).collect(Collectors.toList());
                DynamicObject[] membersFromDB = TmcDataServiceHelper.load((Object[])Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
                HashMap memberFromDBMap = Arrays.stream(membersFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
                memberParentIdList.addAll(Arrays.stream(membersFromDB).filter(v -> Objects.nonNull(v.getDynamicObject("parent"))).map(v -> v.getDynamicObject("parent").getPkValue()).collect(Collectors.toList()));
                memberParentIdList = memberParentIdList.stream().sorted().collect(Collectors.toList());
                HashSet memberParentIds = new HashSet(memberParentIdList);
                DynamicObject[] memberParentIdsFromDB = BusinessDataServiceHelper.load((Object[])memberParentIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
                Map memberParentFromDBMap = Arrays.stream(memberParentIdsFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
                DynamicObject[] allNode = BusinessDataServiceHelper.load((String)"fpm_member", (String)"id,number,name,parent.id,level,isleaf,issum", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", dataEntities[0].getDynamicObject("bodysystem").getPkValue()).and("dimtype", "=", (Object)dataEntities[0].getString("dimtype"))});
                ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(dataEntities.length);
                ArrayList<DynamicObject> saveChildList = new ArrayList<DynamicObject>();
                ArrayList submitIdList = new ArrayList();
                HashMap<Object, String> memberIdSortCodeMap = new HashMap<Object, String>(dataEntities.length);
                for (DynamicObject member : dataEntities) {
                    List<DynamicObject> tChildren;
                    Object parentId;
                    DynamicObject parent;
                    block18: {
                        String sumType = member.getString("sumtype");
                        if (StringUtils.isEmpty((Object)sumType)) {
                            member.set("sumtype", (Object)MemberSumEnum.PLUS.getCode());
                        }
                        parent = member.getDynamicObject("parent");
                        String number = member.getString("number");
                        parentId = null;
                        String sortCodeOfCurrMember = "Z" + number;
                        if (parent != null && parent.getPkValue() != null) {
                            parentId = parent.getPkValue();
                            try {
                                Object partentlLevel;
                                String memberSortCode;
                                String parentSortCode;
                                DynamicObject parentFromDB = (DynamicObject)memberParentFromDBMap.get(parent.getPkValue());
                                if (EmptyUtil.isNoEmpty((DynamicObject)parentFromDB)) {
                                    parentSortCode = parentFromDB.getString("sortcode");
                                    memberSortCode = String.join((CharSequence)"!", parentSortCode, sortCodeOfCurrMember);
                                    this.setSortCode(member, memberSortCode, memberFromDBMap);
                                    memberIdSortCodeMap.put(member.getPkValue(), memberSortCode);
                                } else if (memberIdSortCodeMap.containsKey(parentId)) {
                                    parentSortCode = (String)memberIdSortCodeMap.get(parentId);
                                    memberSortCode = String.join((CharSequence)"!", parentSortCode, sortCodeOfCurrMember);
                                    this.setSortCode(member, memberSortCode, memberFromDBMap);
                                    memberIdSortCodeMap.put(member.getPkValue(), memberSortCode);
                                }
                                if (parentFromDB.getBoolean("isleaf")) {
                                    parentFromDB.set("isleaf", (Object)false);
                                    parentFromDB.set("issum", (Object)true);
                                }
                                if ((partentlLevel = parentFromDB.get("level")) == null) {
                                    parentFromDB.set("level", (Object)1);
                                }
                                member.set("level", (Object)(parentFromDB.getInt("level") + 1));
                                saveList.add(parentFromDB);
                            }
                            catch (Exception e) {
                                if (memberParentIds.contains(member.getPkValue())) {
                                    member.set("isleaf", (Object)false);
                                    member.set("issum", (Object)true);
                                    break block18;
                                }
                                member.set("isleaf", (Object)true);
                                member.set("issum", (Object)false);
                            }
                        } else {
                            member.set("level", (Object)1);
                            this.setSortCode(member, sortCodeOfCurrMember, memberFromDBMap);
                            memberIdSortCodeMap.put(member.getPkValue(), sortCodeOfCurrMember);
                        }
                    }
                    DynamicObject memberFromDB = memberFromDBMap.getOrDefault(member.getPkValue(), null);
                    if (EmptyUtil.isNoEmpty((DynamicObject)memberFromDB)) {
                        parent = memberFromDB.getDynamicObject("parent");
                        if (parent != null && parent.getPkValue() != null && !parent.getPkValue().equals(parentId) && !QueryServiceHelper.exists((String)"fpm_member", (QFilter[])new QFilter[]{new QFilter("parent", "=", parent.getPkValue()).and("id", "!=", member.getPkValue())})) {
                            parent = (DynamicObject)memberParentFromDBMap.get(parent.getPkValue());
                            parent.set("isleaf", (Object)true);
                            parent.set("issum", (Object)false);
                            saveList.add(parent);
                        }
                    } else if (memberParentIds.contains(member.getPkValue())) {
                        member.set("isleaf", (Object)false);
                        member.set("issum", (Object)true);
                    } else {
                        member.set("isleaf", (Object)true);
                        member.set("issum", (Object)false);
                    }
                    if (CollectionUtils.isEmpty(tChildren = this.getAllChildNodeId(allNode, member, member.getInt("level")))) continue;
                    member.set("isleaf", (Object)false);
                    saveChildList.addAll(tChildren);
                    List childPkIds = tChildren.stream().map(c -> c.getLong("id")).collect(Collectors.toList());
                    submitIdList.addAll(childPkIds);
                }
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])saveChildList.toArray(new DynamicObject[0]));
                OperationServiceHelper.executeOperate((String)"submitop", (String)"fpm_member", (Object[])submitIdList.toArray(), (OperateOption)OperateOption.create());
            }

            private void setSortCode(DynamicObject member, String memberSortCode, HashMap<Object, DynamicObject> memberFromDBMap) {
                boolean alreadyExist = memberFromDBMap.containsKey(member.getPkValue());
                if (alreadyExist) {
                    return;
                }
                member.set("sortcode", (Object)memberSortCode);
            }

            public void afterProcess(DynamicObject[] dataEntities) throws KDException {
                super.afterProcess(dataEntities);
                if (FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
                    OperationServiceHelper.executeOperate((String)"syncmember_mdd", (String)"fpm_member", (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
                }
            }

            private List<DynamicObject> getAllChildNodeId(DynamicObject[] col, DynamicObject member, int tParentLevel) {
                ArrayList<DynamicObject> childItems = new ArrayList<DynamicObject>(0);
                childItems.addAll(this.getChildNodeId(col, member.getLong("id"), tParentLevel));
                return childItems;
            }

            private List<DynamicObject> getChildNodeId(DynamicObject[] col, Long parentId, int tParentLevel) {
                ArrayList<DynamicObject> childItems = new ArrayList<DynamicObject>(0);
                ++tParentLevel;
                for (DynamicObject dynamicObject : col) {
                    if (parentId.compareTo(dynamicObject.getLong("parent.id")) != 0) continue;
                    dynamicObject.set("level", (Object)tParentLevel);
                    List<DynamicObject> tChildItems = this.getChildNodeId(col, dynamicObject.getLong("id"), tParentLevel);
                    if (tChildItems.size() < 1) {
                        dynamicObject.set("isleaf", (Object)Boolean.TRUE);
                        dynamicObject.set("issum", (Object)Boolean.FALSE);
                    } else {
                        dynamicObject.set("isleaf", (Object)Boolean.FALSE);
                    }
                    childItems.add(dynamicObject);
                    childItems.addAll(tChildItems);
                }
                return childItems;
            }
        };
    }
}

