/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fs.formplugin.deduction;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fs.common.enums.AgentDeductionTypeEnum;

public class AgentDeductionEdit
extends AbstractFormPlugin {
    private static final String FBASEDATAID = "fbasedataid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setReceiveCompany();
        this.setReceiveAccount();
        this.setPayAccount();
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("receivecompany", (Object)RequestContext.get().getOrgId());
    }

    private void setReceiveCompany() {
        BasedataEdit receiveCompany = (BasedataEdit)this.getControl("receivecompany");
        receiveCompany.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)"fs", (String)"fs_agentdeduction", (String)"47150e89000000ac");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)authOrgIds));
        });
    }

    private void setPayAccount() {
        BasedataEdit payAccount = (BasedataEdit)this.getControl("payaccount");
        payAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            StringBuilder sb = new StringBuilder();
            if (Objects.isNull(this.getModel().getValue("center"))) {
                sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ed3\u7b97\u4e2d\u5fc3\u201c\u3002", (String)"AgentDeductionEdit_0", (String)"tmc-fs-formplugin", (Object[])new Object[0]));
            }
            if (Objects.equals(AgentDeductionTypeEnum.AGENT_DEDUCTION.getValue(), this.getModel().getValue("deductiontype")) && Objects.isNull(this.getModel().getValue("receiveaccount"))) {
                sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6536\u6b3e\u8d26\u53f7\u201c\u3002", (String)"AgentDeductionEdit_1", (String)"tmc-fs-formplugin", (Object[])new Object[0]));
            }
            if (Objects.isNull(this.getModel().getValue("paycompany"))) {
                sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\u201c\u3002", (String)"AgentDeductionEdit_2", (String)"tmc-fs-formplugin", (Object[])new Object[0]));
            }
            if (sb.length() > 0) {
                this.getView().showTipNotification(sb.toString());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setMultiSelect(false);
            QFilter qFilterChina = this.getFilterChina();
            this.appendCurrencyFilter(qFilterChina);
            QFilter acctTypeFilter = new QFilter("accttype", "!=", (Object)AcctTypeEnum.IN.getValue());
            QFilter companyFilter = new QFilter("company", "=", ((DynamicObject)this.getModel().getValue("paycompany")).getPkValue());
            QFilter bankAccountFilter = new QFilter("id", "not in", this.getAllBankAccountIds());
            QFilter openBankFilter = new QFilter("bank", "=", ((DynamicObject)this.getModel().getValue("center")).getPkValue());
            showParameter.getListFilterParameter().setFilter(qFilterChina.and(acctTypeFilter).and(companyFilter).and(bankAccountFilter).and(openBankFilter));
        });
    }

    private void appendCurrencyFilter(QFilter qFilterChina) {
        DynamicObjectCollection entryEntity;
        if (Objects.equals(AgentDeductionTypeEnum.AGENT_DEDUCTION.getValue(), this.getModel().getValue("deductiontype"))) {
            DynamicObject receiveCurrency = (DynamicObject)this.getModel().getValue("receivecurrency");
            QFilter currencyFilter = new QFilter("currency.fbasedataid", "=", receiveCurrency == null ? Integer.valueOf(0) : receiveCurrency.getPkValue());
            qFilterChina.and(currencyFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)(entryEntity = this.getModel().getEntryEntity("entryentity")))) {
            for (DynamicObject row : entryEntity) {
                DynamicObject payCurrency = row.getDynamicObject("paycurrency");
                if (!Objects.nonNull(payCurrency)) continue;
                QFilter currencyFilter = new QFilter("currency.fbasedataid", "=", payCurrency.getPkValue());
                qFilterChina.and(currencyFilter);
                break;
            }
        }
    }

    private QFilter getFilterChina() {
        String[] temp = new String[]{"normal", "closing"};
        QFilter statusFilter = new QFilter("acctstatus", "in", (Object)temp);
        QFilter acctClassifyFilter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
        return statusFilter.and(acctClassifyFilter);
    }

    private void setReceiveAccount() {
        BasedataEdit receiveAccount = (BasedataEdit)this.getControl("receiveaccount");
        receiveAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (Objects.isNull(this.getModel().getValue("receivecompany"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6536\u6b3e\u8d44\u91d1\u7ec4\u7ec7\u201c\u3002", (String)"AgentDeductionEdit_3", (String)"tmc-fs-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter acctTypeFilter = new QFilter("accttype", "!=", (Object)AcctTypeEnum.OUT.getValue());
            QFilter companyFilter = new QFilter("company", "=", ((DynamicObject)this.getModel().getValue("receivecompany")).getPkValue());
            QFilter bankAccountFilter = new QFilter("id", "not in", this.getAllBankAccountIds());
            showParameter.getListFilterParameter().setFilter(this.getFilterChina().and(acctTypeFilter).and(companyFilter).and(bankAccountFilter));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (Objects.equals(name, "receiveaccount")) {
            this.clearFields(e);
            this.setReceiveCurrency(e);
        } else if (Objects.equals(name, "payaccount")) {
            this.setPayCurrency(e);
        } else if (Objects.equals(name, "payamount")) {
            this.reCalculation();
        } else if (Objects.equals(name, "comment")) {
            this.fillTransferComment(e);
        } else if (Objects.equals(name, "isbackfill")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntity) && this.getModel().getDataEntity().getBoolean("isbackfill")) {
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getValue("comment");
                this.fillEntryEntity(ormLocaleValue, entryEntity);
            }
        } else if (Objects.equals(name, "receivecompany")) {
            this.getModel().setValue("receiveaccount", null);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getModel().setValue("payaccount", null, i);
            }
        } else if (Objects.equals(name, "paycompany")) {
            this.getModel().setValue("payaccount", null);
        }
    }

    private Set<Object> getAllBankAccountIds() {
        HashSet<Object> bankAccountIds = new HashSet<Object>();
        DynamicObject receiveAccount = (DynamicObject)this.getModel().getValue("receiveaccount");
        if (Objects.nonNull(receiveAccount)) {
            bankAccountIds.add(receiveAccount.getPkValue());
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : entryEntity) {
            if (!Objects.nonNull(row.get("payaccount"))) continue;
            bankAccountIds.add(row.getDynamicObject("payaccount").getPkValue());
        }
        return bankAccountIds;
    }

    private void clearFields(PropertyChangedArgs e) {
        DynamicObject receiveAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (receiveAccount == null) {
            this.getModel().setValue("receivecurrency", null);
        } else {
            DynamicObjectCollection currencyCollection = receiveAccount.getDynamicObjectCollection("currency");
            DynamicObject currency = CollectionUtils.isEmpty((Collection)currencyCollection) ? null : (DynamicObject)((DynamicObject)currencyCollection.get(0)).get(FBASEDATAID);
            this.getModel().setValue("receivecurrency", (Object)currency);
            this.clearAccountByCurrency(currency);
            this.clearAccountByScorg(e);
        }
    }

    private void clearAccountByScorg(PropertyChangedArgs e) {
        DynamicObject oldReceiveAccount = (DynamicObject)e.getChangeSet()[0].getOldValue();
        DynamicObject newReceiveAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (oldReceiveAccount != null && newReceiveAccount != null) {
            DynamicObject oldBank = oldReceiveAccount.getDynamicObject("bank");
            DynamicObject newBank = newReceiveAccount.getDynamicObject("bank");
            if (oldBank == null && newBank != null || oldBank != null && newBank == null || oldBank != null && !Objects.equals(oldBank.getPkValue(), newBank.getPkValue())) {
                this.clearPayAccount();
            }
        }
    }

    private void clearPayAccount() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getModel().setValue("payaccount", null, i);
        }
    }

    private void clearAccountByCurrency(DynamicObject currency) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity) && currency != null) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                DynamicObject payCurrency = row.getDynamicObject("paycurrency");
                if (payCurrency == null || Objects.equals(payCurrency.getPkValue(), currency.getPkValue())) continue;
                this.getModel().setValue("payaccount", null, i);
            }
        }
    }

    private void fillTransferComment(PropertyChangedArgs e) {
        DynamicObjectCollection entryEntity;
        if (this.getModel().getDataEntity().getBoolean("isbackfill") && !CollectionUtils.isEmpty((Collection)(entryEntity = this.getModel().getEntryEntity("entryentity")))) {
            LocaleDynamicObjectCollection newValues = (LocaleDynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            OrmLocaleValue ormLocaleValue = null;
            for (DynamicObject newValue : newValues) {
                String localeString = (String)newValue.get("comment");
                DynamicObject orCreateItemByLocaleId = newValues.getOrCreateItemByLocaleId((String)newValue.get(newValues.getLocaleIdProperty()));
                String localId = (String)orCreateItemByLocaleId.getDataStorage().getLocalValue(newValues.getLocaleIdProperty());
                ormLocaleValue = (OrmLocaleValue)((DynamicObject)entryEntity.get(0)).get("transfercomment");
                ormLocaleValue.put(localId, localeString);
            }
            this.fillEntryEntity(ormLocaleValue, entryEntity);
        }
    }

    private void fillEntryEntity(OrmLocaleValue ormLocaleValue, DynamicObjectCollection entryEntity) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getModel().setValue("transfercomment", (Object)ormLocaleValue, i);
        }
    }

    private void reCalculation() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        BigDecimal totalPayAmount = entryEntity.stream().map(d -> d.getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("receiveamount", (Object)totalPayAmount);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (this.getModel().getDataEntity().getBoolean("isbackfill")) {
            int rowIndex = this.getModel().getEntryRowCount("entryentity") - 1;
            this.getModel().setValue("transfercomment", this.getModel().getValue("comment"), rowIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.reCalculation();
    }

    private void setPayCurrency(PropertyChangedArgs e) {
        DynamicObject payAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (payAccount != null) {
            DynamicObjectCollection currencyCollection;
            DynamicObject bankAccount = BusinessDataServiceHelper.loadSingle((Object)payAccount.getPkValue(), (String)"bd_accountbanks", (String)"currency, bank");
            if (Objects.nonNull(bankAccount) && !CollectionUtils.isEmpty((Collection)(currencyCollection = bankAccount.getDynamicObjectCollection("currency")))) {
                this.getModel().setValue("paycurrency", ((DynamicObject)currencyCollection.get(0)).get(FBASEDATAID), e.getChangeSet()[0].getRowIndex());
                this.getModel().setValue("receivecurrency", ((DynamicObject)currencyCollection.get(0)).get(FBASEDATAID), e.getChangeSet()[0].getRowIndex());
            }
        } else {
            this.getModel().setValue("paycurrency", null, e.getChangeSet()[0].getRowIndex());
        }
    }

    private void setReceiveCurrency(PropertyChangedArgs e) {
        DynamicObject receiveAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (receiveAccount != null) {
            DynamicObject bankAccount = BusinessDataServiceHelper.loadSingle((Object)receiveAccount.getPkValue(), (String)"bd_accountbanks", (String)"currency, bank");
            if (Objects.nonNull(bankAccount)) {
                DynamicObjectCollection currencyCollection = bankAccount.getDynamicObjectCollection("currency");
                if (!CollectionUtils.isEmpty((Collection)currencyCollection)) {
                    this.getModel().setValue("receivecurrency", ((DynamicObject)currencyCollection.get(0)).get(FBASEDATAID));
                }
                DynamicObject openBank = bankAccount.getDynamicObject("bank");
                this.getModel().setValue("center", (Object)openBank);
                this.getModel().setValue("scorg", openBank == null ? null : openBank.get("org"));
            }
        } else {
            this.getModel().setValue("center", null);
            this.getModel().setValue("scorg", null);
        }
    }
}

