/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fs.common.helper;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OperateServiceHelper
extends OperationServiceHelper {
    private static Log log = LogFactory.getLog(OperateServiceHelper.class);

    public static OperationResult execOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option, boolean RequireNew) {
        if (RequireNew) {
            try (TXHandle tx = TX.requiresNew();){
                OperationResult operationResult = OperateServiceHelper.execOperate(operationKey, entityNumber, dataEntities, option);
                return operationResult;
            }
        }
        return OperateServiceHelper.execOperate(operationKey, entityNumber, dataEntities, option);
    }

    public static OperationResult execOperate(String operationKey, String entityNumber, Object[] ids, OperateOption option, boolean RequireNew) {
        if (RequireNew) {
            try (TXHandle tx = TX.requiresNew();){
                OperationResult operationResult = OperateServiceHelper.execOperate(operationKey, entityNumber, ids, option);
                return operationResult;
            }
        }
        return OperateServiceHelper.execOperate(operationKey, entityNumber, ids, option);
    }

    public static OperationResult executeOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities) {
        return OperateServiceHelper.execOperate(operationKey, entityNumber, dataEntities, OperateOption.create());
    }

    public static OperationResult executeOperate(String operationKey, String entityNumber, Object[] ids) {
        return OperateServiceHelper.execOperate(operationKey, entityNumber, ids, OperateOption.create());
    }

    public static OperationResult execOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        OperationResult operationResult;
        String bizAppId = OperateServiceHelper.initCurrentBizApp(entityNumber, operationKey);
        if (!StringUtils.isEmpty((CharSequence)bizAppId)) {
            option.setVariableValue("currbizappid", bizAppId);
        }
        if (!(operationResult = OperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option)).isSuccess()) {
            throw new KDBizException(OperateServiceHelper.decodeErrorMsg(operationResult));
        }
        return operationResult;
    }

    public static OperationResult execOperate(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        OperationResult operationResult;
        String bizAppId = OperateServiceHelper.initCurrentBizApp(entityNumber, operationKey);
        if (!StringUtils.isEmpty((CharSequence)bizAppId)) {
            option.setVariableValue("currbizappid", bizAppId);
        }
        if (!(operationResult = OperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option)).isSuccess()) {
            throw new KDBizException(OperateServiceHelper.decodeErrorMsg(operationResult));
        }
        return operationResult;
    }

    public static OperationResult execOperateWithoutThrow(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        String bizAppId = OperateServiceHelper.initCurrentBizApp(entityNumber, operationKey);
        if (!StringUtils.isEmpty((CharSequence)bizAppId)) {
            option.setVariableValue("currbizappid", bizAppId);
        }
        OperationResult operationResult = OperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        return operationResult;
    }

    public static OperationResult execOperateWithoutThrow(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        String bizAppId = OperateServiceHelper.initCurrentBizApp(entityNumber, operationKey);
        if (!StringUtils.isEmpty((CharSequence)bizAppId)) {
            option.setVariableValue("currbizappid", bizAppId);
        }
        OperationResult operationResult = OperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        return operationResult;
    }

    private static String initCurrentBizApp(String entityNumber, String operationKey) {
        Map operateMetaMap;
        String permissionId;
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String checkAppId = dt.getAppId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List pubApps = dt.getPermissionControlType().getPublishApps();
        if (pubApps != null && pubApps.size() == 1) {
            checkAppId = (String)pubApps.get(0);
        }
        if (!StringUtils.isEmpty((CharSequence)(permissionId = (String)(operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operationKey)).get("permission"))) && pubApps != null && pubApps.size() > 1) {
            block0: for (String bizAppId : pubApps) {
                HasPermOrgResult perms = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
                List permOrgIds = perms.getHasPermOrgs();
                for (Long orgId : permOrgIds) {
                    int hasPermssion = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)bizAppId, (String)entityNumber, (String)permissionId);
                    if (hasPermssion == 0) continue;
                    checkAppId = bizAppId;
                    break block0;
                }
            }
        }
        log.info("checkAppId" + checkAppId);
        String checkApp = AppMetadataCache.getAppNumberById((String)checkAppId);
        return checkApp;
    }

    public static String decodeErrorMsg(OperationResult operationResult) {
        String errMsg;
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            errMsg = OperateServiceHelper.decodeMultiErrorMsg(operationResult);
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            errMsg = errorInfo.getMessage();
        } else {
            errMsg = operationResult.getMessage();
        }
        return errMsg;
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder buf = new StringBuilder();
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append('\n');
        }
        return buf.toString();
    }
}

