/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fs.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fs.common.helper.SystemStatusCtrolHelper;

public class PeriodHelper {
    private static final String SELETOR = "id,number,name,periodyear,periodnumber,isadjustperiod,periodtype,begindate,enddate";

    public static long getPeriodTypeId(long orgId) {
        DynamicObject periodType = SystemStatusCtrolHelper.getPeriodType(orgId);
        return periodType == null ? 0L : periodType.getLong("id");
    }

    public static DynamicObjectCollection getPeriodList(long periodTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
        Map periodMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)entityType, (QFilter[])filters);
        DynamicObjectCollection periodColl = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        for (DynamicObject period : periodMap.values()) {
            periodColl.add((Object)period);
        }
        return periodColl;
    }

    public static DynamicObject[] getPeriodListOrder(long periodTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
        DynamicObject[] periodMap = BusinessDataServiceHelper.load((String)entityType.getName(), (String)SELETOR, (QFilter[])filters, (String)"enddate desc");
        return periodMap;
    }

    public static DynamicObject getPeriodByDate(long orgId, Date date) {
        long periodTypeId = PeriodHelper.getPeriodTypeId(orgId);
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DynamicObject getPeriodById(long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bd_period", (String)SELETOR);
    }

    public static DynamicObject getPeriodByYearAndNumber(long periodtypeId, int periodyear, int periodnumber) {
        QFilter[] filters = new QFilter[]{new QFilter("periodyear", "=", (Object)periodyear), new QFilter("periodnumber", "=", (Object)periodnumber), new QFilter("periodtype", "=", (Object)periodtypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DynamicObject getNextPeriod(long id) {
        DynamicObject period = PeriodHelper.getPeriodById(id);
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber < 12) {
            ++periodNumber;
        } else {
            ++periodYear;
            periodNumber = 1;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumber(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber);
        return nextPeriod;
    }

    public static DynamicObject getPrevPeriod(long id) {
        DynamicObject period = PeriodHelper.getPeriodById(id);
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber > 1) {
            --periodNumber;
        } else {
            --periodYear;
            periodNumber = 12;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumber(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber);
        return nextPeriod;
    }

    public static boolean before(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") < period2.getInt("periodyear") || period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") < period2.getInt("periodnumber");
    }

    public static boolean after(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") > period2.getInt("periodyear") || period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") > period2.getInt("periodnumber");
    }

    public static boolean equal(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") == period2.getInt("periodnumber");
    }

    public static DynamicObject getLastPeriod(long orgid) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)PeriodHelper.getPeriodTypeId(orgid))};
        DynamicObject[] periodArr = BusinessDataServiceHelper.load((String)"bd_period", (String)SELETOR, (QFilter[])filters, (String)"begindate desc", (int)1);
        return periodArr != null && periodArr.length > 0 ? periodArr[0] : null;
    }

    public static List<DynamicObject> getOriginPeriods(long orgId) {
        DynamicObject[] periods;
        ArrayList<DynamicObject> nearstPeriods = new ArrayList<DynamicObject>(10);
        DynamicObject startPeriod = SystemStatusCtrolHelper.getStartPeriod(orgId);
        DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod(orgId);
        if (null == startPeriod || null == currentPeriod) {
            return nearstPeriods;
        }
        nearstPeriods.add(currentPeriod);
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)PeriodHelper.getPeriodTypeId(orgId)), new QFilter("begindate", "<", (Object)currentPeriod.getDate("begindate")), new QFilter("begindate", ">=", (Object)startPeriod.getDate("begindate"))};
        for (DynamicObject period : periods = BusinessDataServiceHelper.load((String)"bd_period", (String)SELETOR, (QFilter[])filters, (String)"begindate desc")) {
            nearstPeriods.add(period);
        }
        return nearstPeriods;
    }

    public static DynamicObject getCasInitInfo(long orgId) {
        return SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
    }
}

