/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.contract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GmSourceBillTypeEnum;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeQuotaHelper;

public class GuaranteeContractCloseService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sl = new ArrayList<String>(10);
        sl.add("guaranteeway");
        sl.add("ensureentity");
        sl.add("ensureamtentity");
        sl.add("morentity");
        sl.add("enddate");
        sl.add("begindate");
        sl.add("sourcebillid");
        sl.add("pletgageentity");
        sl.add("ensureentity.e_ensurerate");
        sl.add("ensureentity.e_amount");
        sl.add("ensureentity.e_ensurerate");
        sl.add("ensureentity.e_amount");
        sl.add("ensureamtentity.a_amount");
        sl.add("ensureamtentity.a_ensurerate");
        sl.add("morentity.m_amount");
        sl.add("morentity.m_pleg");
        sl.add("pletgageentity.p_amount");
        sl.add("pletgageentity.p_pleg");
        sl.add("censureentity.ce_amount");
        sl.add("cmorentity.cm_amount");
        sl.add("cmorentity.cm_pleg");
        sl.add("cpletgageentity.cp_pleg");
        sl.add("cpletgageentity.cp_amount");
        sl.add("entry_guaranteeorg");
        sl.add("entry_guaranteeorg.a_guaranteetype");
        sl.add("entry_guaranteeorg.a_guaranteeorg");
        sl.add("entry_guaranteeorg.a_guaranteeorgtext");
        sl.add("entry_guaranteeorg.a_gamount");
        sl.add("entry_guaranteeorg.a_gdutyamount");
        sl.add("entry_guaranteeorg.a_guaranteequota");
        sl.add("entry_guaranteedorg");
        sl.add("entry_guaranteedorg.b_reguaranteetype");
        sl.add("entry_guaranteedorg.b_guaranteedorg");
        sl.add("entry_guaranteedorg.b_guaranteedorgtext");
        sl.add("entry_guaranteedorg.b_gamount");
        sl.add("entry_guaranteedorg.b_guaranteequota");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("oldbizstatus", (Object)dataEntity.getString("bizstatus"));
            dataEntity.set("bizstatus", (Object)GuaConBizStatusEnum.CLOSED.getValue());
            dataEntity.set("closeuser", (Object)RequestContext.get().getUserId());
            dataEntity.set("closetime", (Object)new Date());
            GuaranteeContractHelper.pledgebillWriteBack((DynamicObject)dataEntity, (boolean)true);
            GuaranteeQuotaHelper.writeBackAllQuota((DynamicObject)dataEntity, (String)GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        List sourceIds = Arrays.stream(dataEntities).map(d -> d.getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(sourceIds)) {
            QFilter filter = new QFilter("sourcebillid", "in", sourceIds);
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            DynamicObjectCollection pledgeBills = QueryServiceHelper.query((String)"gm_pledgebill", (String)"id", (QFilter[])new QFilter[]{filter});
            Object[] ids = pledgeBills.stream().map(d -> d.getLong("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])ids)) {
                TmcOperateServiceHelper.execOperate((String)"cancel", (String)"gm_pledgebill", (Object[])ids, (OperateOption)OperateOption.create(), (boolean)false);
            }
        }
    }
}

