/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.debt;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.DebtChangeTypeEnum;
import kd.tmc.gm.common.helper.DebtRegisterUseHelper;

public class DebtRegisterAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("gmbillno");
        sl.add("changetype");
        sl.add("rootid");
        sl.add("releaseamount");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> gUseList = new ArrayList<Long>(dataEntities.length);
        ArrayList<GuaranteeUseReturnBean> returnGuList = new ArrayList<GuaranteeUseReturnBean>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject contract = dataEntity.getDynamicObject("gmbillno");
            if (EmptyUtil.isEmpty((DynamicObject)contract)) continue;
            if (DebtChangeTypeEnum.DEBT_OCCUPY.getValue().equals(dataEntity.getString("changetype"))) {
                gUseList.add((Long)dataEntity.getPkValue());
                continue;
            }
            GuaranteeUseReturnBean returnBean = new GuaranteeUseReturnBean();
            returnBean.setBizBillId(Long.valueOf(dataEntity.getLong("rootid")));
            returnBean.setReturnBillId((Long)dataEntity.getPkValue());
            returnBean.setReturnBillType(dataEntity.getDataEntityType().getName());
            returnBean.setReturnAmount(dataEntity.getBigDecimal("releaseamount"));
            returnGuList.add(returnBean);
        }
        if (gUseList.size() > 0) {
            DebtRegisterUseHelper.confirmGuaranteeUse(gUseList);
        }
        if (returnGuList.size() > 0) {
            DebtRegisterUseHelper.returnGuaranteeUse(returnGuList);
        }
    }
}

