/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.debt;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.DebtChangeTypeEnum;
import kd.tmc.gm.common.helper.DebtRegisterUseHelper;

public class DebtRegisterSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("gmbillno");
        sl.add("changetype");
        sl.add("billno");
        sl.add("creditortext");
        sl.add("org");
        sl.add("currency");
        sl.add("amount");
        sl.add("guaranteerate");
        sl.add("convertrate");
        sl.add("begindate");
        sl.add("enddate");
        sl.add("releaseamount");
        sl.add("remark");
        sl.add("rootid");
        sl.add("guaranteedorg");
        sl.add("guaranteedorgtext");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<GuaranteeUseBean> gUseList = new ArrayList<GuaranteeUseBean>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject contract = dataEntity.getDynamicObject("gmbillno");
            if (EmptyUtil.isEmpty((DynamicObject)contract) || !DebtChangeTypeEnum.DEBT_OCCUPY.getValue().equals(dataEntity.getString("changetype"))) continue;
            GuaranteeUseBean gUse = new GuaranteeUseBean();
            gUse.setSrcBillId((Long)dataEntity.getPkValue());
            gUse.setSrcBillType(dataEntity.getDataEntityType().getName());
            gUse.setSrcBillNo(dataEntity.getString("billno"));
            gUse.setgContractId(Long.valueOf(contract.getLong("id")));
            gUse.setComment(dataEntity.getString("remark"));
            gUse.setBizAmount(dataEntity.getBigDecimal("amount"));
            gUse.setgAmount(dataEntity.getBigDecimal("amount"));
            gUse.setgRatio(dataEntity.getBigDecimal("guaranteerate"));
            gUse.setExchrate(dataEntity.getBigDecimal("convertrate"));
            gUse.setDebtOrgId(Long.valueOf(dataEntity.getLong("guaranteedorg")));
            gUse.setDebtOrgText(dataEntity.getString("guaranteedorgtext"));
            gUse.setDebtCurrencyId(Long.valueOf(dataEntity.getDynamicObject("currency").getLong("id")));
            gUse.setCparty(dataEntity.getString("creditortext"));
            gUse.setDebtStartDate(dataEntity.getDate("begindate"));
            gUse.setDebtEndDate(dataEntity.getDate("enddate"));
            gUseList.add(gUse);
        }
        if (gUseList.size() > 0) {
            DebtRegisterUseHelper.saveGuaranteeUse(gUseList);
        }
    }
}

