/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.guaranteeapply;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;
import kd.tmc.gm.common.enums.GuaContractApplTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeHelper;

public class GuaranteeApplyAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("guacontract");
        selector.add("amount");
        selector.add("begindate");
        selector.add("enddate");
        selector.add("isneedreg");
        selector.add("countorguaway");
        selector.add("ensureentity");
        selector.add("ensureentity.e_type");
        selector.add("ensureentity.e_ensuretext");
        selector.add("ensureentity.e_ensure");
        selector.add("ensureentity.e_amount");
        selector.add("ensureentity.e_ensurerate");
        selector.add("ensureentity.e_remarks");
        selector.add("ensureamtentity");
        selector.add("ensureamtentity.a_type");
        selector.add("ensureamtentity.a_ensuretext");
        selector.add("ensureamtentity.a_ensure");
        selector.add("ensureamtentity.a_ensurerate");
        selector.add("ensureamtentity.a_amount");
        selector.add("ensureamtentity.a_remarks");
        selector.add("morentity");
        selector.add("morentity.m_pleg");
        selector.add("morentity.m_pledgevalue");
        selector.add("morentity.m_totalpledgevalue");
        selector.add("morentity.m_amount");
        selector.add("morentity.m_remarks");
        selector.add("pletgageentity");
        selector.add("pletgageentity.p_pleg");
        selector.add("pletgageentity.p_pledgevalue");
        selector.add("pletgageentity.p_totalpledgevalue");
        selector.add("pletgageentity.p_amount");
        selector.add("pletgageentity.p_remarks");
        selector.add("censureentity");
        selector.add("censureentity.ce_type");
        selector.add("censureentity.ce_ensuretext");
        selector.add("censureentity.ce_ensure");
        selector.add("censureentity.ce_amount");
        selector.add("censureentity.ce_ensurerate");
        selector.add("censureentity.ce_remarks");
        selector.add("cmorentity");
        selector.add("cmorentity.cm_pleg");
        selector.add("cmorentity.cm_pledgevalue");
        selector.add("cmorentity.cm_totalpledgevalue");
        selector.add("cmorentity.cm_amount");
        selector.add("cmorentity.cm_remarks");
        selector.add("cpletgageentity");
        selector.add("cpletgageentity.cp_pleg");
        selector.add("cpletgageentity.cp_pledgevalue");
        selector.add("cpletgageentity.cp_totalpledgevalue");
        selector.add("cpletgageentity.cp_amount");
        selector.add("cpletgageentity.cp_remarks");
        selector.add("entry_guaranteeorg");
        selector.add("entry_guaranteeorg.a_guaranteetype");
        selector.add("entry_guaranteeorg.a_guaranteeorg");
        selector.add("entry_guaranteeorg.a_guaranteeorgtext");
        selector.add("entry_guaranteeorg.a_gamount");
        selector.add("entry_guaranteeorg.a_gratio");
        selector.add("entry_guaranteeorg.a_gdutyamount");
        selector.add("entry_guaranteeorg.a_guaranteequota");
        selector.add("entry_guaranteedorg");
        selector.add("entry_guaranteedorg.b_reguaranteetype");
        selector.add("entry_guaranteedorg.b_guaranteedorg");
        selector.add("entry_guaranteedorg.b_guaranteedorgtext");
        selector.add("entry_guaranteedorg.b_gamount");
        selector.add("entry_guaranteedorg.b_gratio");
        selector.add("entry_guaranteedorg.b_guaranteequota");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> guaranteeContractList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject apply : dataEntities) {
            if (!GuaContractApplTypeEnum.isChangeApply((String)apply.getString("applytype"))) continue;
            boolean isNeedReg = apply.getBoolean("isneedreg");
            if (!isNeedReg) {
                apply.set("countorguaway", null);
                apply.getDynamicObjectCollection("censureentity").clear();
                apply.getDynamicObjectCollection("cmorentity").clear();
                apply.getDynamicObjectCollection("cpletgageentity").clear();
            }
            DynamicObject guaContract = apply.getDynamicObject("guacontract");
            Long guaranteeContractId = (Long)guaContract.getPkValue();
            DynamicObject guaContractDo = TmcDataServiceHelper.loadSingle((Object)guaranteeContractId, (String)"gm_guaranteecontract");
            this.saveHistory(guaContractDo, apply);
            GuaranteeHelper.copyValue((DynamicObject)apply, (DynamicObject)guaContractDo, (List)GuaranteeContractHelper.CHANGEFIELDS, (List)GuaranteeContractHelper.CONTRACT_ENTRY_NAMES);
            guaranteeContractList.add(guaContractDo);
        }
        if (guaranteeContractList.size() > 0) {
            List contractIds = guaranteeContractList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            Set contractUseIds = GuaranteeHelper.getContractUseIds(contractIds);
            for (DynamicObject guarantee : guaranteeContractList) {
                String guaType = GuaConBizStatusEnum.DOING.getValue();
                if (!contractUseIds.contains(guarantee.getLong("id"))) {
                    guaType = GuaConBizStatusEnum.REGISTED.getValue();
                }
                guarantee.set("bizstatus", (Object)guaType);
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"gm_guaranteecontract", (DynamicObject[])guaranteeContractList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    private void saveHistory(DynamicObject guaContract, DynamicObject apply) {
        BillChangeHistoryHelper.addChangeHistory((Long)((Long)apply.getPkValue()), (String)apply.getDataEntityType().getName(), (String)apply.getString("billno"), (String)"", (String)"GC", (DynamicObject)guaContract);
    }
}

