/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.guaranteeapply;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;
import kd.tmc.gm.common.enums.GuaContractApplTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeHelper;

public class GuaranteeApplyDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("guacontract");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> letterOfGuaranteeIds = new ArrayList<Long>(10);
        for (DynamicObject apply : dataEntities) {
            String applyType = apply.getString("applytype");
            if (!GuaContractApplTypeEnum.isChangeApply((String)applyType)) continue;
            DynamicObject guacontract = apply.getDynamicObject("guacontract");
            Long id = (Long)guacontract.get("id");
            letterOfGuaranteeIds.add(id);
        }
        if (letterOfGuaranteeIds.size() > 0) {
            DynamicObject[] guaranteeContracts = TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)"bizstatus", (QFilter[])new QFilter("id", "in", letterOfGuaranteeIds).toArray());
            Set contractUseIds = GuaranteeHelper.getContractUseIds(letterOfGuaranteeIds);
            for (DynamicObject letterOfGuarantee : guaranteeContracts) {
                String bizStatus = GuaConBizStatusEnum.DOING.getValue();
                if (!contractUseIds.contains(letterOfGuarantee.getLong("id"))) {
                    bizStatus = GuaConBizStatusEnum.REGISTED.getValue();
                }
                letterOfGuarantee.set("bizstatus", (Object)bizStatus);
            }
            TmcDataServiceHelper.save((DynamicObject[])guaranteeContracts);
        }
    }
}

