/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.letterofguaapply;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BeneficiaryUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BeneficiaryUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            try {
                result.setLog("start upgrade beneficiary type and value");
                this.dataUpgrade("t_gm_letterofguaapply");
                this.dataUpgrade("t_gm_letterofguarantee");
                result.setLog("end upgrade beneficiary type and value");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private void dataUpgrade(String tableName) {
        String applyQuerySql = "select fid, fbeneficiarytype, fbeneficiaryid, ftextbeneficiary from " + tableName;
        DataSet beneficiaryData = DB.queryDataSet((String)"BeneficiaryUpgradeService", (DBRoute)DBRouteConst.TMC, (String)applyQuerySql);
        if (beneficiaryData.isEmpty()) {
            return;
        }
        ArrayList<Long> existIds = new ArrayList<Long>();
        for (Row beneficiaryDatum : beneficiaryData.copy()) {
            existIds.add(beneficiaryDatum.getLong("fid"));
        }
        logger.info("existIds:{}", (Object)existIds.stream().map(String::valueOf).collect(Collectors.joining()));
        Set<Long> fidEntrySet = this.getEntryMap(existIds);
        String insertSql = "insert into t_gm_beneficiary_entry(fid, fentryid, fseq, fbeneficiarytype, fbeneficiary, ftextbeneficiary) values (?, ?, ?, ?, ?, ?)";
        long[] entryIds = DB.genLongIds((String)"t_gm_beneficiary_entry", (int)(existIds.size() - fidEntrySet.size()));
        int i = 0;
        ArrayList<String> upgradeIds = new ArrayList<String>();
        for (Row beneficiaryDatum : beneficiaryData.copy()) {
            if (fidEntrySet.contains(beneficiaryDatum.getLong("fid"))) continue;
            Object[] params = new Object[]{beneficiaryDatum.getLong("fid"), entryIds[i], 1, beneficiaryDatum.getString("fbeneficiarytype"), beneficiaryDatum.getLong("fbeneficiaryid"), beneficiaryDatum.getString("ftextbeneficiary")};
            upgradeIds.add(beneficiaryDatum.getString("fid"));
            DB.execute((DBRoute)DBRouteConst.TMC, (String)insertSql, (Object[])params);
            ++i;
        }
        logger.info("upgrade upgradeIds:{}", (Object)String.join((CharSequence)",", upgradeIds));
    }

    private Set<Long> getEntryMap(List<Long> ids) {
        String querySql = "select fid from t_gm_beneficiary_entry where fid in (%s)";
        StringJoiner sj = new StringJoiner(",");
        ids.forEach(v -> sj.add(v.toString()));
        DataSet beneficiaryDataSet = DB.queryDataSet((String)"getEntryMap", (DBRoute)DBRouteConst.TMC, (String)String.format(querySql, sj.toString()));
        HashSet<Long> fidSet = new HashSet<Long>();
        if (EmptyUtil.isEmpty((Object)beneficiaryDataSet)) {
            return fidSet;
        }
        for (Row row : beneficiaryDataSet.copy()) {
            Long fid = row.getLong("fid");
            fidSet.add(fid);
        }
        return fidSet;
    }
}

