/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.letterofguaapply;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.enums.LetterOfGuaApplyBizTypeEnum;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class LetterOfGuaApplySaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("letterofguarantee");
        sl.add("biztype");
        sl.add("entryentity");
        sl.add("entryentity.e_beneficiarytype");
        sl.add("entryentity.e_beneficiary");
        sl.add("entryentity.e_textbeneficiary");
        sl.add("beneficiarytype");
        sl.add("beneficiary");
        sl.add("textbeneficiary");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> letterOfGuaranteeIds = new ArrayList<Long>(10);
        for (DynamicObject applyDO : dataEntities) {
            if (LetterOfGuaApplyBizTypeEnum.isChangeLetter((String)applyDO.getString("biztype"))) {
                DynamicObject letterOfGuarantee = applyDO.getDynamicObject("letterofguarantee");
                Long id = (Long)letterOfGuarantee.get("id");
                letterOfGuaranteeIds.add(id);
                continue;
            }
            if (!LetterOfGuaApplyBizTypeEnum.isOpenLetter((String)applyDO.getString("biztype"))) continue;
            boolean isReissue = applyDO.getBoolean("isreissue");
            boolean isPreUse = BillStatusEnum.SUBMIT.getValue().equals(applyDO.getString("billstatus"));
            if (!isReissue || !isPreUse) continue;
            DynamicObjectCollection lgFromDbDO = QueryServiceHelper.query((String)"gm_letterofguaapply", (String)"creditlimit", (QFilter[])new QFilter[]{new QFilter("id", "=", applyDO.getPkValue())});
            long origClDO = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)lgFromDbDO)) {
                origClDO = ((DynamicObject)lgFromDbDO.get(0)).getLong("creditlimit");
            }
            DynamicObject clDO = applyDO.getDynamicObject("creditlimit");
            if (EmptyUtil.isEmpty((Long)origClDO) && EmptyUtil.isNoEmpty((DynamicObject)clDO)) {
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)applyDO, null, (boolean)isPreUse);
                continue;
            }
            if (EmptyUtil.isNoEmpty((Long)origClDO) && EmptyUtil.isEmpty((DynamicObject)clDO)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)applyDO, null, (boolean)isPreUse);
                continue;
            }
            if (!EmptyUtil.isNoEmpty((Long)origClDO) || !EmptyUtil.isNoEmpty((DynamicObject)clDO)) continue;
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)applyDO, null, (boolean)isPreUse);
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)applyDO, null, (boolean)isPreUse);
        }
        LetterOfGuaranteeHelper.updateBeneficiaryType((DynamicObject[])dataEntities);
        if (letterOfGuaranteeIds.size() > 0) {
            DynamicObject[] letterOfGuarantees;
            for (DynamicObject letterOfGuarantee : letterOfGuarantees = TmcDataServiceHelper.load((String)"gm_letterofguarantee", (String)"bizstatus", (QFilter[])new QFilter("id", "in", letterOfGuaranteeIds).toArray())) {
                letterOfGuarantee.set("bizstatus", (Object)BizStatusEnum.CHANGING.getValue());
            }
            TmcDataServiceHelper.save((DynamicObject[])letterOfGuarantees);
        }
    }

    private void updateBeneficiaryType(DynamicObject applyDO) {
        DynamicObjectCollection beneficiaryCollection = applyDO.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)beneficiaryCollection)) {
            applyDO.set("beneficiarytype", (Object)((DynamicObject)beneficiaryCollection.get(0)).getString("e_beneficiarytype"));
            applyDO.set("beneficiary", (Object)((DynamicObject)beneficiaryCollection.get(0)).getString("e_beneficiary"));
            applyDO.set("textbeneficiary", (Object)((DynamicObject)beneficiaryCollection.get(0)).getString("e_textbeneficiary"));
            if (beneficiaryCollection.size() > 1) {
                applyDO.set("textbeneficiary", (Object)(((DynamicObject)beneficiaryCollection.get(0)).getString("e_textbeneficiary") + LetterOfGuaranteeHelper.getEndFlag()));
            }
        } else {
            applyDO.set("beneficiarytype", null);
            applyDO.set("beneficiary", (Object)0L);
            applyDO.set("textbeneficiary", null);
        }
    }
}

