/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.letterofguaapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BizRangeTypeEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.EntityMapFactory;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.enums.LetterOfGuaApplyBizTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeHelper;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class LetterOfGuaApplyUnauditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("creditlimit");
        sl.add("currency");
        sl.add("amount");
        sl.add("biztype");
        sl.add("letterofguarantee");
        sl.add("applyorg");
        sl.add("finorginfo");
        sl.add("currency");
        sl.add("guaranteevariety");
        sl.add("startdate");
        sl.add("expiredate");
        sl.add("amount");
        sl.add("creditgratio");
        sl.add("bizstatus");
        List extFields = EntityMapFactory.getDealService((String)BizRangeTypeEnum.CHANGE.getValue()).getExtSelectorProp("gm_letterofguaapply", "gm_letterofguarantee", BizRangeTypeEnum.CHANGE.getValue(), true);
        if (EmptyUtil.isNoEmpty((Object)extFields)) {
            sl.addAll(extFields);
        }
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List idList = Arrays.stream(dataEntities).filter(e -> LetterOfGuaApplyBizTypeEnum.isOpenLetter((String)e.getString("biztype"))).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter glQFilter = new QFilter("sourcebillid", "in", idList);
        glQFilter.and(new QFilter("sourcebilltype", "=", (Object)"gm_letterofguaapply"));
        DynamicObjectCollection glDOs = QueryServiceHelper.query((String)"gm_letterofguarantee", (String)"id", (QFilter[])glQFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)glDOs)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"gm_letterofguarantee", (Object[])glDOs.stream().map(d -> d.get("id")).toArray(), (OperateOption)OperateOption.create());
        }
        ArrayList<DynamicObject> letterOfGuaranteeList = new ArrayList<DynamicObject>();
        for (DynamicObject apply : dataEntities) {
            DynamicObject clDO;
            String bizType = apply.getString("biztype");
            if (LetterOfGuaApplyBizTypeEnum.isChangeLetter((String)bizType)) {
                DynamicObject letterOfGuaranteeF7 = apply.getDynamicObject("letterofguarantee");
                Long letterOfGuaranteeId = (Long)letterOfGuaranteeF7.getPkValue();
                DynamicObject letterOfGuarantee = GuaranteeContractHelper.getLetterOfGua((Long)letterOfGuaranteeId);
                DynamicObject oldLetterOfGuarantee = BillChangeHistoryHelper.genDelChangeHistory((Long)letterOfGuaranteeId, (String)"gm_letterofguarantee");
                List extFields = EntityMapFactory.getDealService((String)BizRangeTypeEnum.CHANGE.getValue()).getExtSelectorProp("gm_letterofguaapply", "gm_letterofguarantee", BizRangeTypeEnum.CHANGE.getValue(), false);
                extFields.addAll(LetterOfGuaranteeHelper.CHANGEFIELDS);
                GuaranteeHelper.copyValue((DynamicObject)oldLetterOfGuarantee, (DynamicObject)letterOfGuarantee, (List)extFields, Arrays.asList("entry_gcontract", "entryentity"));
                letterOfGuarantee.set("bizstatus", (Object)BizStatusEnum.CHANGING.getValue());
                letterOfGuaranteeList.add(letterOfGuarantee);
                LetterOfGuaranteeHelper.changeCreditLimit((DynamicObject)letterOfGuarantee, (DynamicObject)apply, (boolean)false);
                LetterOfGuaranteeHelper.changeSuretyBill((DynamicObject)letterOfGuarantee, (DynamicObject)oldLetterOfGuarantee);
                continue;
            }
            if (!LetterOfGuaApplyBizTypeEnum.isOpenLetter((String)bizType) || (clDO = apply.getDynamicObject("creditlimit")) == null) continue;
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)apply, null, (boolean)true);
        }
        if (letterOfGuaranteeList.size() > 0) {
            DynamicObject[] letterOfGuarantees = letterOfGuaranteeList.toArray(new DynamicObject[0]);
            LetterOfGuaranteeHelper.saveGuaranteeUse((DynamicObject[])letterOfGuarantees);
            List bizIdSet = letterOfGuaranteeList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            GuaranteeUseHelper.confirmGuaranteeUse(bizIdSet);
            SaveServiceHelper.update((DynamicObject[])letterOfGuarantees);
        }
    }
}

