/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.letterofguarantee;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class LetterOfGuaranteeUnClaimOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(LetterOfGuaranteeUnClaimOpService.class);

    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("claimdate");
        sl.add("bizstatus");
        sl.add("creditlimit");
        sl.add("amount");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("\u53d6\u6d88\u7d22\u8d54\uff0cstart... ");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            LetterOfGuaranteeHelper.cancelReturnCreditlimit((DynamicObject)dataEntity);
            dataEntity.set("bizstatus", (Object)BizStatusEnum.REGISTERED.getValue());
            dataEntity.set("claimdate", null);
            list.add(dataEntity);
            LetterOfGuaranteeHelper.updateSuretyStatus((DynamicObject)dataEntity, (String)BizStatusEnum.REGISTERED.getValue());
        }
        TmcDataServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        this.reGuaranteeUse(dataEntities);
    }

    private void reGuaranteeUse(DynamicObject[] letters) {
        ArrayList<GuaranteeUseReturnBean> returnGuList = new ArrayList<GuaranteeUseReturnBean>(letters.length);
        for (DynamicObject letter : letters) {
            Long lgId = letter.getLong("id");
            String billtype = letter.getDataEntityType().getName();
            GuaranteeUseReturnBean returnBean = new GuaranteeUseReturnBean();
            returnBean.setBizBillId(lgId);
            returnBean.setReturnBillId(lgId);
            returnBean.setReturnBillType(billtype);
            returnGuList.add(returnBean);
        }
        GuaranteeUseHelper.cancelReturnGuaranteeUse(returnGuList);
    }
}

