/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.letterofguarantee;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class LetterOfGuaranteeUnauditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("bizstatus");
        sl.add("creditlimit");
        sl.add("currency");
        sl.add("genreceiveletter");
        sl.add("beneficiarytype");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List idList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter rlQFilter = new QFilter("sourcebillid", "in", idList);
        rlQFilter.and(new QFilter("sourcebilltype", "=", (Object)"gm_letterofguarantee"));
        rlQFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
        DynamicObjectCollection rlDOs = QueryServiceHelper.query((String)"gm_receiveletter", (String)"id", (QFilter[])rlQFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rlDOs)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"gm_receiveletter", (Object[])rlDOs.stream().map(d -> d.get("id")).toArray(), (OperateOption)OperateOption.create());
        }
        for (DynamicObject letter : dataEntities) {
            letter.set("bizstatus", (Object)BizStatusEnum.REGISTERING.getValue());
            String beneficiaryType = letter.getString("beneficiarytype");
            if (!OppUnitTypeEnum.BOSORG.getValue().equals(beneficiaryType)) continue;
            letter.set("genreceiveletter", (Object)false);
        }
        this.cancelGuaranteeUse(dataEntities);
        LetterOfGuaranteeHelper.change2PreUseCreditLimt((DynamicObject[])dataEntities);
    }

    private void cancelGuaranteeUse(DynamicObject[] dataEntities) {
        ArrayList<Long> bizIdSet = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject letter : dataEntities) {
            bizIdSet.add(letter.getLong("id"));
        }
        GuaranteeUseHelper.cancelGuaranteeUse(bizIdSet);
    }
}

