/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.quota;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GuaranteeQuotaUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(GuaranteeQuotaUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            try {
                result.setLog("start upgrade guaranteequota type and value");
                this.dataUpgrade("t_gm_guaranteequota");
                result.setLog("end upgrade guaranteequota type and value");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private void dataUpgrade(String tableName) {
        String applyQuerySql = "select fid, freguaranteetype, fguaranteedorgid, fguaranteedorgtext, ftotalamount from " + tableName;
        DataSet guaranteeQuotaData = DB.queryDataSet((String)"GuaranteeQuotaUpgradeService", (DBRoute)DBRouteConst.TMC, (String)applyQuerySql);
        if (guaranteeQuotaData.isEmpty()) {
            return;
        }
        ArrayList<Long> existIds = new ArrayList<Long>();
        for (Row guaranteeQuotaDatum : guaranteeQuotaData.copy()) {
            existIds.add(guaranteeQuotaDatum.getLong("fid"));
        }
        logger.info("existIds:{}", (Object)existIds.stream().map(String::valueOf).collect(Collectors.joining()));
        Set<Long> fidEntrySet = this.getEntryMap(existIds);
        String insertSql = "insert into t_gm_reguaquota_entry(fid, fentryid, fseq, freguaranteetype, fguaranteedorgid, fguaranteedorgtext, flimitamount) values (?, ?, ?, ?, ?, ?, ?)";
        long[] entryIds = DB.genLongIds((String)"t_gm_reguaquota_entry", (int)(existIds.size() - fidEntrySet.size()));
        int i = 0;
        ArrayList<String> upgradeIds = new ArrayList<String>();
        for (Row guaranteeQuotaDatum : guaranteeQuotaData.copy()) {
            if (fidEntrySet.contains(guaranteeQuotaDatum.getLong("fid"))) continue;
            Object[] params = new Object[]{guaranteeQuotaDatum.getLong("fid"), entryIds[i], 1, guaranteeQuotaDatum.getString("freguaranteetype"), guaranteeQuotaDatum.getLong("fguaranteedorgid"), guaranteeQuotaDatum.getString("fguaranteedorgtext"), guaranteeQuotaDatum.getBigDecimal("ftotalamount")};
            upgradeIds.add(guaranteeQuotaDatum.getString("fid"));
            DB.execute((DBRoute)DBRouteConst.TMC, (String)insertSql, (Object[])params);
            ++i;
        }
        logger.info("upgrade upgradeIds:{}", (Object)String.join((CharSequence)",", upgradeIds));
    }

    private Set<Long> getEntryMap(List<Long> ids) {
        String querySql = "select fid from t_gm_reguaquota_entry where fid in (%s)";
        StringJoiner sj = new StringJoiner(",");
        ids.forEach(v -> sj.add(v.toString()));
        DataSet beneficiaryDataSet = DB.queryDataSet((String)"getEntryMap", (DBRoute)DBRouteConst.TMC, (String)String.format(querySql, sj.toString()));
        HashSet<Long> fidSet = new HashSet<Long>();
        if (EmptyUtil.isEmpty((Object)beneficiaryDataSet)) {
            return fidSet;
        }
        for (Row row : beneficiaryDataSet) {
            Long fid = row.getLong("fid");
            fidSet.add(fid);
        }
        return fidSet;
    }
}

