/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.contract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;

public class GuaranteeContractUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sl = new ArrayList<String>(10);
        sl.add("bizstatus");
        sl.add("isneedreg");
        sl.add("sourcebillid");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Object pkValue;
            QFilter qFilter;
            DynamicObjectCollection glebill;
            DynamicObject info = extendedDataEntity.getDataEntity();
            if (GuaConBizStatusEnum.DOING.getValue().equals(info.getString("bizstatus")) || GuaConBizStatusEnum.CLOSED.getValue().equals(info.getString("bizstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u5728\u6267\u884c\u4e2d\u6216\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"GuaranteeContractUnAuditValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (info.getBoolean("isneedreg") && EmptyUtil.isNoEmpty((DynamicObjectCollection)(glebill = QueryServiceHelper.query((String)"gm_pledgebill", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", info.getPkValue()), new QFilter("billsource", "=", (Object)info.getDataEntityType().getName())})))) {
                DynamicObject bill = (DynamicObject)glebill.get(0);
                String tipMsg = "";
                if (BillStatusEnum.SUBMIT.getValue().equals(bill.getString("billstatus"))) {
                    tipMsg = BillStatusEnum.SUBMIT.getName();
                } else if (BillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) {
                    tipMsg = BillStatusEnum.AUDIT.getName();
                }
                if (EmptyUtil.isNoEmpty((String)tipMsg)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u62c5\u4fdd\u751f\u6210\u7684\u62b5\u8d28\u62bc\u7269[%1$s]%2$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"GuaranteeContractUnAuditValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]), bill.getString("billno"), tipMsg));
                }
            }
            Long pk = info.getLong("id");
            QFilter gQF = new QFilter("gcontract.id", "=", (Object)pk);
            DynamicObjectCollection gcUse = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gsrcbillno", "gsrcbilltype"), (QFilter[])gQF.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)gcUse)) {
                HashMap<String, ArrayList<String>> useListMap = new HashMap<String, ArrayList<String>>(16);
                for (DynamicObject gu : gcUse) {
                    DynamicObject srcBill = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)gu.getString("gsrcbilltype"))});
                    String billtype = srcBill.getString("name");
                    ArrayList<String> billNos = (ArrayList<String>)useListMap.get(billtype);
                    if (billNos == null) {
                        billNos = new ArrayList<String>(5);
                        useListMap.put(billtype, billNos);
                    }
                    billNos.add(gu.getString("gsrcbillno"));
                }
                ArrayList<String> billmsg = new ArrayList<String>(useListMap.size());
                for (Map.Entry entry : useListMap.entrySet()) {
                    billmsg.add((String)entry.getKey() + ":" + String.join((CharSequence)",", (Iterable)entry.getValue()));
                }
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u88ab\u4e1a\u52a1\u5355\u636e%s\u5f15\u7528\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"GuaranteeContractUnAuditValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]), String.join((CharSequence)";", billmsg)));
            }
            if (!TmcDataServiceHelper.exists((String)"gm_guaranteeapply", (QFilter[])new QFilter[]{qFilter = new QFilter("guacontract.id", "=", pkValue = info.getPkValue())})) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u53d8\u66f4\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"GuaranteeContractUnAuditValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }
}

