/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.guarnateeapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaContractApplTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;

public class GuaranteeApplySaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sl = new ArrayList<String>(10);
        sl.add("bizdate");
        sl.add("begindate");
        sl.add("enddate");
        sl.add("entry_guaranteedorg");
        sl.add("b_guaranteedorg");
        sl.add("creditor");
        sl.add("applytype");
        sl.add("amount");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject applyBill = extendedDataEntity.getDataEntity();
            Date bizDate = applyBill.getDate("bizdate");
            Date beginDate = applyBill.getDate("begindate");
            Date endDate = applyBill.getDate("enddate");
            String applyType = applyBill.getString("applytype");
            BigDecimal amount = applyBill.getBigDecimal("amount");
            DynamicObjectCollection guaranteedOrgCollection = applyBill.getDynamicObjectCollection("entry_guaranteedorg");
            Long creditorId = applyBill.getLong("creditor");
            for (int i = 0; i < guaranteedOrgCollection.size(); ++i) {
                if (!EmptyUtil.isNoEmpty((Long)creditorId) || ((DynamicObject)guaranteedOrgCollection.get(i)).getLong("b_guaranteedorg") != creditorId.longValue()) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u4e2d\u88ab\u62c5\u4fdd\u4eba\u548c\u503a\u6743\u4eba\u4e0d\u80fd\u76f8\u540c\u3002", (String)"GuaranteeApplySaveValidator_2", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            if (GuaContractApplTypeEnum.isAddApply((String)applyType)) {
                if (endDate == null || endDate.after(beginDate)) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u62c5\u4fdd\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u9884\u8ba1\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u3002", (String)"GuaranteeApplySaveValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]));
                continue;
            }
            if (!GuaContractApplTypeEnum.isChangeApply((String)applyType)) continue;
            DynamicObject guaContract = applyBill.getDynamicObject("guacontract");
            QFilter[] qFilter = new QFilter[]{new QFilter("guacontract.id", "=", guaContract.getPkValue()), new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}), new QFilter("billno", "!=", (Object)applyBill.getString("billno"))};
            if (TmcDataServiceHelper.exists((String)"gm_guaranteeapply", (QFilter[])qFilter)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\u3002", (String)"GuaranteeApplySaveValidator_6", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            BigDecimal dutyAmt = GuaranteeContractHelper.getContractDutyAmtExcludeCreditLimit((Long)((Long)guaContract.getPkValue()));
            if (endDate != null && !endDate.after(beginDate)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u3002", (String)"GuaranteeApplySaveValidator_5", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (amount.compareTo(dutyAmt) >= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u8d23\u4efb\u91d1\u989d\u3002", (String)"GuaranteeApplySaveValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }
}

