/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.guarnateeapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.CtrlLimitEnum;
import kd.tmc.gm.common.enums.GmSourceBillTypeEnum;
import kd.tmc.gm.common.enums.GuaContractApplTypeEnum;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeQuotaHelper;

public class GuaranteeApplySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sl = new ArrayList<String>(10);
        sl.add("amount");
        sl.add("billno");
        sl.add("guaranteeway");
        sl.add("currency");
        sl.add("ensureentity");
        sl.add("ensureamtentity");
        sl.add("morentity");
        sl.add("enddate");
        sl.add("begindate");
        sl.add("sourcebillid");
        sl.add("pletgageentity");
        sl.add("ensureentity.e_ensurerate");
        sl.add("ensureentity.e_amount");
        sl.add("ensureentity.e_ensurerate");
        sl.add("ensureentity.e_amount");
        sl.add("ensureamtentity.a_amount");
        sl.add("ensureamtentity.a_ensurerate");
        sl.add("morentity.m_amount");
        sl.add("morentity.m_pleg");
        sl.add("pletgageentity.p_amount");
        sl.add("pletgageentity.p_pleg");
        sl.add("entry_guaranteeorg");
        sl.add("entry_guaranteedorg");
        sl.add("entry_guaranteeorg.a_guaranteetype");
        sl.add("entry_guaranteedorg.b_reguaranteetype");
        sl.add("entry_guaranteeorg.a_guaranteeorg");
        sl.add("entry_guaranteedorg.b_guaranteedorg");
        sl.add("entry_guaranteeorg.a_gamount");
        sl.add("entry_guaranteedorg.b_gamount");
        sl.add("entry_guaranteeorg.a_guaranteequota");
        sl.add("entry_guaranteedorg.b_guaranteequota");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject currency;
            DynamicObjectCollection reGuaCollection;
            DynamicObject info = extendedDataEntity.getDataEntity();
            String applyType = info.getString("applytype");
            DynamicObjectCollection guaOrgCollection = info.getDynamicObjectCollection("entry_guaranteeorg");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)guaOrgCollection)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeApplySubmitValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(reGuaCollection = info.getDynamicObjectCollection("entry_guaranteedorg")))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeApplySubmitValidator_4", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            DynamicObject changeContractBill = GuaranteeQuotaHelper.getChangeApplyQuota((DynamicObject)info);
            if (GuaContractApplTypeEnum.isAddApply((String)applyType)) {
                currency = info.getDynamicObject("currency");
                this.validateGuaOrgQuota(extendedDataEntity, guaOrgCollection, currency, null);
                this.validateReGuaQuota(extendedDataEntity, reGuaCollection, currency, null);
            } else if (EmptyUtil.isNoEmpty((DynamicObject)changeContractBill)) {
                currency = info.getDynamicObject("currency");
                if (this.isNotContainsGuaWay(info.getString("guaranteeway"), changeContractBill.getString("guaranteeway"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u539f\u59cb\u7684\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u80fd\u53bb\u6389\u3002", (String)"GuaranteeApplySubmitValidator_11", (String)"tmc-gm-business", (Object[])new Object[0]));
                }
                this.validateGuaOrgQuota(extendedDataEntity, guaOrgCollection, currency, changeContractBill);
                this.validateReGuaQuota(extendedDataEntity, reGuaCollection, currency, changeContractBill);
            }
            GuaranteeContractHelper.handleEntryByWay((DynamicObject)info);
        }
    }

    private boolean isNotContainsGuaWay(String applyGuaWay, String contractGuaWay) {
        String[] contractWaysArr;
        for (String contractWays : contractWaysArr = contractGuaWay.split(",")) {
            if (applyGuaWay.contains(contractWays)) continue;
            return true;
        }
        return false;
    }

    private void validateReGuaQuota(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection reGuaCollection, DynamicObject currency, DynamicObject changeContractBill) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reGuaCollection)) {
            return;
        }
        DynamicObject info = extendedDataEntity.getDataEntity();
        Long currencyId = currency.getLong("id");
        HashMap<Long, BigDecimal> reGuaQuotaMap = new HashMap<Long, BigDecimal>();
        for (int i = 0; i < reGuaCollection.size(); ++i) {
            BigDecimal beforeQuotaAmt;
            BigDecimal quotaAmt;
            HashSet quotaReOrgIds;
            DynamicObject reGuaEntry = (DynamicObject)reGuaCollection.get(i);
            DynamicObject guaranteeQuota = reGuaEntry.getDynamicObject("b_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.getPkValue(), (String)"gm_guaranteequota", (String)GuaranteeQuotaHelper.QUOTA_PROP_NAME);
            String quotaEnable = guaranteeQuota.getString("enable");
            if (BaseEnableEnum.DISABLE.getValue().equals(quotaEnable) || !BillStatusEnum.AUDIT.getValue().equals(guaranteeQuota.getString("status"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u5df2\u5173\u95ed\u6216\u88ab\u53cd\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_5", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            String ctrlLimit = guaranteeQuota.getString("ctrllimit");
            DynamicObjectCollection guaranteedOrgCollection = guaranteeQuota.getDynamicObjectCollection("entry_guaranteedorg");
            Set<Object> set = quotaReOrgIds = EmptyUtil.isEmpty((DynamicObjectCollection)guaranteedOrgCollection) ? new HashSet(8) : guaranteedOrgCollection.stream().map(q -> q.getLong("q_guaranteedorg")).collect(Collectors.toSet());
            if (!CtrlLimitEnum.GUARANTEED_ORG.getValue().equals(ctrlLimit) || !quotaReOrgIds.contains(reGuaEntry.getLong("b_guaranteedorg"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u63a7\u5236\u5bf9\u8c61\u6216\u88ab\u62c5\u4fdd\u4eba\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_10", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            Date beginDate = guaranteeQuota.getDate("begindate");
            Date endDate = guaranteeQuota.getDate("enddate");
            if (beginDate.after(info.getDate("begindate")) || endDate != null && endDate.before(info.getDate("begindate"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u4e0d\u5728\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u65e5\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_8", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            if (EmptyUtil.isEmpty((BigDecimal)(quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal((DynamicObject)guaranteeQuota, (Long)currencyId, (BigDecimal)reGuaEntry.getBigDecimal("b_gamount"))))) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230%1$s\u5e01\u79cd\u548c%2$s\u5e01\u79cd\u7684\u8f6c\u6362\u6c47\u7387\u3002", (String)"GuaranteeApplySubmitValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]), currency.getString("name"), guaranteeQuota.getDynamicObject("currency").getString("name")));
                continue;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)changeContractBill)) {
                BigDecimal changeContractQuotaAmt = BigDecimal.ZERO;
                QFilter idFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.getPkValue());
                idFilter.and(new QFilter("gmorgtype", "=", (Object)reGuaEntry.getString("b_reguaranteetype")));
                idFilter.and(new QFilter("gmorgid", "=", (Object)reGuaEntry.getLong("b_guaranteedorg")));
                idFilter.and(new QFilter("gmbilltype", "=", (Object)GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue()));
                idFilter.and(new QFilter("gmbillid", "=", changeContractBill.getPkValue()));
                DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)"gmactualquota,gmadvancequota", (QFilter[])new QFilter[]{idFilter});
                for (DynamicObject quotaUseDO : quotaUseList) {
                    changeContractQuotaAmt = changeContractQuotaAmt.add(quotaUseDO.getBigDecimal("gmadvancequota")).add(quotaUseDO.getBigDecimal("gmactualquota"));
                }
                quotaAmt = quotaAmt.subtract(changeContractQuotaAmt);
            }
            if (EmptyUtil.isEmpty((BigDecimal)(beforeQuotaAmt = (BigDecimal)reGuaQuotaMap.get((Long)guaranteeQuota.getPkValue())))) {
                beforeQuotaAmt = BigDecimal.ZERO;
            }
            if (quotaAmt.add(beforeQuotaAmt).compareTo(guaranteeQuota.getBigDecimal("availablequota")) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_2", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
                continue;
            }
            DynamicObjectCollection entryList = guaranteeQuota.getDynamicObjectCollection("entry_guaranteedorg");
            Long reGuaOrgId = reGuaEntry.getLong("b_guaranteedorg");
            for (DynamicObject entry : entryList) {
                if (!reGuaOrgId.equals(entry.getLong("q_guaranteedorg"))) continue;
                QFilter qidFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.getPkValue());
                List<String> guaranteedOrgTypeList = Collections.singletonList(entry.getString("q_reguaranteetype"));
                if (GuaranteeTypeEnum.TMCORG.getValue().equals(entry.getString("q_reguaranteetype"))) {
                    guaranteedOrgTypeList = Arrays.asList(GuaranteeTypeEnum.ORG.getValue(), GuaranteeTypeEnum.TMCORG.getValue());
                }
                qidFilter.and(new QFilter("gmorgtype", "in", guaranteedOrgTypeList));
                qidFilter.and(new QFilter("gmorgid", "=", (Object)entry.getLong("q_guaranteedorg")));
                DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)"gmactualquota,gmadvancequota", (QFilter[])new QFilter[]{qidFilter});
                BigDecimal usedQuotaSum = BigDecimal.ZERO;
                BigDecimal advanceQuotaSum = BigDecimal.ZERO;
                for (DynamicObject quotaUseDO : quotaUseList) {
                    usedQuotaSum = usedQuotaSum.add(quotaUseDO.getBigDecimal("gmactualquota"));
                    advanceQuotaSum = advanceQuotaSum.add(quotaUseDO.getBigDecimal("gmadvancequota"));
                }
                entry.set("q_usedquota", (Object)usedQuotaSum);
                entry.set("q_advancequota", (Object)advanceQuotaSum);
                if (quotaAmt.add(beforeQuotaAmt).compareTo(GuaranteeQuotaHelper.getAvailableQuota((DynamicObject)entry)) <= 0) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_2", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
                break;
            }
            reGuaQuotaMap.put((Long)guaranteeQuota.getPkValue(), beforeQuotaAmt.add(quotaAmt));
        }
    }

    private void validateGuaOrgQuota(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection guaOrgCollection, DynamicObject currency, DynamicObject changeContractBill) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaOrgCollection)) {
            return;
        }
        DynamicObject info = extendedDataEntity.getDataEntity();
        Long currencyId = currency.getLong("id");
        for (int i = 0; i < guaOrgCollection.size(); ++i) {
            BigDecimal quotaAmt;
            DynamicObject guaOrgEntry = (DynamicObject)guaOrgCollection.get(i);
            DynamicObject guaranteeQuota = guaOrgEntry.getDynamicObject("a_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.getPkValue(), (String)"gm_guaranteequota", (String)GuaranteeQuotaHelper.QUOTA_PROP_NAME);
            String quotaEnable = guaranteeQuota.getString("enable");
            if (BaseEnableEnum.DISABLE.getValue().equals(quotaEnable) || !BillStatusEnum.AUDIT.getValue().equals(guaranteeQuota.getString("status"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u5df2\u5173\u95ed\u6216\u88ab\u53cd\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_6", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            String ctrlLimit = guaranteeQuota.getString("ctrllimit");
            Long quotaOrgId = guaranteeQuota.getLong("org.id");
            if (!CtrlLimitEnum.GUARANTEE_ORG.getValue().equals(ctrlLimit) || !quotaOrgId.equals(guaOrgEntry.getLong("a_guaranteeorg"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u63a7\u5236\u5bf9\u8c61\u6216\u62c5\u4fdd\u4eba\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_9", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            Date beginDate = guaranteeQuota.getDate("begindate");
            Date endDate = guaranteeQuota.getDate("enddate");
            if (beginDate.after(info.getDate("begindate")) || endDate != null && endDate.before(info.getDate("begindate"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u4e0d\u5728\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u65e5\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_7", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            if (EmptyUtil.isEmpty((BigDecimal)(quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal((DynamicObject)guaranteeQuota, (Long)currencyId, (BigDecimal)guaOrgEntry.getBigDecimal("a_gamount"))))) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230%1$s\u5e01\u79cd\u548c%2$s\u5e01\u79cd\u7684\u8f6c\u6362\u6c47\u7387\u3002", (String)"GuaranteeApplySubmitValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]), currency.getString("name"), guaranteeQuota.getDynamicObject("currency").getString("name")));
                continue;
            }
            BigDecimal changeContractQuotaAmt = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObject)changeContractBill)) {
                QFilter idFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.getPkValue());
                idFilter.and(new QFilter("gmorgtype", "=", (Object)guaOrgEntry.getString("a_guaranteetype")));
                idFilter.and(new QFilter("gmorgid", "=", (Object)guaOrgEntry.getLong("a_guaranteeorg")));
                idFilter.and(new QFilter("gmbilltype", "=", (Object)GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue()));
                idFilter.and(new QFilter("gmbillid", "=", changeContractBill.getPkValue()));
                DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)"gmactualquota,gmadvancequota", (QFilter[])new QFilter[]{idFilter});
                for (DynamicObject quotaUseDO : quotaUseList) {
                    changeContractQuotaAmt = changeContractQuotaAmt.add(quotaUseDO.getBigDecimal("gmadvancequota")).add(quotaUseDO.getBigDecimal("gmactualquota"));
                }
            }
            if (quotaAmt.subtract(changeContractQuotaAmt).compareTo(guaranteeQuota.getBigDecimal("availablequota")) <= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_1", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
        }
    }
}

