/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.letterofguaapply;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.gm.common.enums.LetterOfGuaApplyBizTypeEnum;

public class LetterOfGuaApplySaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("startdate");
        sl.add("expiredate");
        sl.add("biztype");
        sl.add("letterofguarantee");
        sl.add("billno");
        return sl;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject apply = dataEntity.getDataEntity();
            Date startDate = apply.getDate("startdate");
            Date expireDate = apply.getDate("expiredate");
            String bizType = apply.getString("biztype");
            if (startDate != null && expireDate != null && startDate.after(expireDate)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u51fd\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u51fd\u5f00\u59cb\u65e5\u3002", (String)"LetterOfGuaApplySaveValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (!LetterOfGuaApplyBizTypeEnum.isChangeLetter((String)bizType)) continue;
            DynamicObject letterOfGuarantee = apply.getDynamicObject("letterofguarantee");
            if (letterOfGuarantee == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u51fd\u767b\u8bb0\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LetterOfGuaApplySaveValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
                continue;
            }
            QFilter[] qFilter = new QFilter[]{new QFilter("letterofguarantee.id", "=", letterOfGuarantee.getPkValue()), new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()}), new QFilter("billno", "!=", (Object)apply.getString("billno"))};
            if (!TmcDataServiceHelper.exists((String)"gm_letterofguaapply", (QFilter[])qFilter)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6539\u51fd\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\u3002", (String)"LetterOfGuaApplySaveValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }
}

