/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.letterofguaapply;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.LetterOfGuaApplyBizTypeEnum;

public class LetterOfGuaApplySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("creditlimit");
        sl.add("amount");
        sl.add("letterofguarantee");
        sl.add("guaranteevariety");
        sl.add("isreissue");
        sl.add("applyorg");
        sl.add("applyreissueorg");
        sl.add("currency");
        sl.add("entryentity");
        return sl;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection beneficiaryCollection = data.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)beneficiaryCollection)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4fdd\u51fd\u53d7\u76ca\u4eba\u201d\u3002", (String)"LetterOfGuaApplySubmitValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (data.getBoolean("isreissue") && data.getDynamicObject("applyorg").getPkValue().equals(data.getDynamicObject("applyreissueorg").getPkValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u5f00\u65f6\uff0c\u7533\u8bf7\u8f6c\u5f00\u516c\u53f8\u53ca\u4fdd\u51fd\u7533\u8bf7\u516c\u53f8\u4e0d\u80fd\u76f8\u540c\u3002", (String)"LetterOfGuaApplySubmitValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            DynamicObject creditLimit = data.getDynamicObject("creditlimit");
            if (!LetterOfGuaApplyBizTypeEnum.isChangeLetter((String)data.getString("biztype")) || creditLimit == null) continue;
            CreditLimitUseBean bean = new CreditLimitUseBean();
            bean.setSourceType(data.getDynamicObjectType().getName());
            bean.setPkId(Long.valueOf(data.getLong("id")));
            DynamicObject applyOrg = data.getDynamicObject("applyorg");
            if (applyOrg == null) continue;
            Long sourceBillId = Optional.ofNullable(data.getDynamicObject("letterofguarantee")).map(r -> r.getLong("id")).orElse(0L);
            bean.setSourceBillId(sourceBillId);
            Long creditTypeId = Optional.ofNullable(data.getDynamicObject("guaranteevariety")).map(r -> r.getDynamicObject("credittype")).map(c -> c.getLong("id")).orElse(0L);
            bean.setCreditTypeId(creditTypeId);
            bean.setOrgId(Long.valueOf(applyOrg.getLong("id")));
            bean.setCurrencyId(Long.valueOf(data.getDynamicObject("currency").getLong("id")));
            bean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
            bean.setBizAmt(data.getBigDecimal("amount"));
            CreditLimitF7ResBean result = CreditLimitServiceHelper.validataCreditLimitAmt((CreditLimitUseBean)bean);
            if (result.getSuccess().booleanValue()) continue;
            this.addWarningMessage(dataEntity, result.getMsg());
        }
    }
}

