/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.letterofguarantee;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LetterOfGuaranteeGenReceiveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("billstatus");
        sl.add("beneficiarytype");
        sl.add("genreceiveletter");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        String operateParam = this.getOption().getVariables().getOrDefault("genreceiveletter", null);
        if (EmptyUtil.isEmpty((String)operateParam)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject letter = dataEntity.getDataEntity();
            String billStatus = letter.getString("billstatus");
            String beneficiaryType = letter.getString("beneficiarytype");
            boolean genReceiveLetter = letter.getBoolean("genreceiveletter");
            if (BillStatusEnum.AUDIT.getValue().equals(billStatus) && OppUnitTypeEnum.BOSORG.getValue().equals(beneficiaryType) && !genReceiveLetter) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u3001\u4e14\u53d7\u76ca\u4eba\u7c7b\u578b\u4e3a\u516c\u53f8\u4e14\u672a\u751f\u6210\u6536\u51fd\u5355\u7684\u624d\u5141\u8bb8\u751f\u6210\u6536\u51fd\u5355\u3002", (String)"LetterOfGuaranteeGenReceiveValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }
}

