/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.pledgebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.gm.common.enums.PledgeStatusEnum;

public class PledgeBillAutoCancelValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selectProperties = super.getSelector();
        selectProperties.add("billno");
        selectProperties.add("billsource");
        selectProperties.add("pledgestatus");
        selectProperties.add("enddate");
        return selectProperties;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(info.getString("billstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u975e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6ce8\u9500\u3002", (String)"PledgeBillAutoCancelValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (!"gm_pledgebill".equals(info.get("billsource"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u6765\u6e90\u4e3a\u624b\u5de5\u65b0\u589e\u7684\u62b5\u8d28\u62bc\u7269\u5355\u624d\u53ef\u4ee5\u6ce8\u9500\u3002", (String)"PledgeTypeCancelAuditValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (PledgeStatusEnum.PLEDGING.getValue().equals(info.getString("pledgestatus")) || PledgeStatusEnum.CACELPLEDGE.getValue().equals(info.getString("pledgestatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u5728\u62bc\u6216\u8005\u5df2\u7ecf\u6ce8\u9500\uff0c\u4e0d\u5141\u8bb8\u6ce8\u9500\u3002", (String)"PledgeBillAutoCancelValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (!DateUtils.getCurrentDate().before(info.getDate("enddate"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%s\u62b5\uff08\u8d28\uff09\u62bc\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4eca\u5929\u3002", (String)"PledgeBillAutoCancelValidator_2", (String)"tmc-gm-business", (Object[])new Object[]{info.getString("billno")}));
        }
    }
}

