/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.pledgebill;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.StringUtils;

public class PledgeBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            QFilter pPletFilter = new QFilter("morentity.m_pleg.id", "=", data.getPkValue());
            QFilter mPletFilter = new QFilter("pletgageentity.p_pleg.id", "=", data.getPkValue());
            QFilter cpPletFilter = new QFilter("cmorentity.cm_pleg.id", "=", data.getPkValue());
            QFilter cmPletFilter = new QFilter("cpletgageentity.cp_pleg.id", "=", data.getPkValue());
            QFilter gcFilter = pPletFilter.or(mPletFilter).or(cpPletFilter).or(cmPletFilter);
            DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"id,billno", (QFilter[])gcFilter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)contractBills)) continue;
            Set billNos = contractBills.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269\u5df2\u88ab\u62c5\u4fdd\u5408\u540c\u5355\u636e%s\u5f15\u7528\u3002", (String)"PledgeTypeUnAuditValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]), StringUtils.setToString(billNos)));
        }
    }
}

