/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeWayEnum;
import kd.tmc.gm.common.enums.PledgeStatusEnum;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class GuaranteeContractHelper {
    private static final String CLASS_NAME = "GuaranteeContractHelper";
    public static final String OPERNAME = "plege";
    public static final List<String> CONTRACT_ENTRY_NAMES = Arrays.asList("entry_guaranteeorg", "entry_guaranteedorg", "ensureentity", "ensureamtentity", "morentity", "pletgageentity", "censureentity", "cmorentity", "cpletgageentity");
    public static final List<String> CHANGEFIELDS = Arrays.asList("guarantee", "creditortype", "creditor", "creditortext", "amount", "dutyamount", "currency", "guaranteeamount", "begindate", "enddate", "guaranteeway", "guaranteelimit", "isneedreg", "countorguaway", "description");

    public static void handleEntryByWay(DynamicObject info) {
        String guaWay = info.getString("guaranteeway");
        if (!guaWay.contains(GuaranteeWayEnum.ENSURE.getValue())) {
            GuaranteeContractHelper.deleteEntry(info, "ensureentity");
        }
        if (!guaWay.contains(GuaranteeWayEnum.ENSUAMT.getValue())) {
            GuaranteeContractHelper.deleteEntry(info, "ensureamtentity");
        }
        if (!guaWay.contains(GuaranteeWayEnum.MORTGAGE.getValue())) {
            GuaranteeContractHelper.deleteEntry(info, "morentity");
        }
        if (!guaWay.contains(GuaranteeWayEnum.PLEDGE.getValue())) {
            GuaranteeContractHelper.deleteEntry(info, "pletgageentity");
        }
    }

    private static void deleteEntry(DynamicObject info, String entity) {
        DynamicObjectCollection entitys = info.getDynamicObjectCollection(entity);
        if (entitys.size() > 0) {
            info.set(entity, null);
        }
    }

    public static void pledgebillWriteBack(DynamicObject pleBill, boolean isCancel) {
        DynamicObjectCollection morEntity = pleBill.getDynamicObjectCollection("morentity");
        DynamicObjectCollection pleEntity = pleBill.getDynamicObjectCollection("pletgageentity");
        morEntity.forEach(m -> GuaranteeContractHelper.getPledgeBill(m.getDynamicObject("m_pleg").getLong("id"), m.getBigDecimal("m_amount"), isCancel, pleBill.getDate("begindate"), pleBill.getDate("enddate")));
        pleEntity.forEach(m -> GuaranteeContractHelper.getPledgeBill(m.getDynamicObject("p_pleg").getLong("id"), m.getBigDecimal("p_amount"), isCancel, pleBill.getDate("begindate"), pleBill.getDate("enddate")));
        DynamicObjectCollection cmorEntity = pleBill.getDynamicObjectCollection("cmorentity");
        DynamicObjectCollection cpleEntity = pleBill.getDynamicObjectCollection("cpletgageentity");
        cmorEntity.forEach(m -> GuaranteeContractHelper.getPledgeBill(m.getDynamicObject("cm_pleg").getLong("id"), m.getBigDecimal("cm_amount"), isCancel, pleBill.getDate("begindate"), pleBill.getDate("enddate")));
        cpleEntity.forEach(m -> GuaranteeContractHelper.getPledgeBill(m.getDynamicObject("cp_pleg").getLong("id"), m.getBigDecimal("cp_amount"), isCancel, pleBill.getDate("begindate"), pleBill.getDate("enddate")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getPledgeBill(Long billId, BigDecimal pleAmt, boolean isCancel, Date beginDate, Date endDate) {
        Object[] pledgeBills = TmcDataServiceHelper.load((String)"gm_pledgebill", (String)String.join((CharSequence)",", GuaranteeContractHelper.getPledgeBillSelector()), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        if (EmptyUtil.isEmpty((Object[])pledgeBills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269\u5355\u636e\u4e0d\u5b58\u5728.", (String)"GuaranteeContractHelper_0", (String)"tmc-gm-common", (Object[])new Object[0]));
        }
        Object pledgeBill = pledgeBills[0];
        String bizStatus = pledgeBill.getString("pledgestatus");
        String billStatus = pledgeBill.getString("billstatus");
        if (PledgeStatusEnum.CACELPLEDGE.getValue().equals(bizStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269\u5df2\u88ab\u6ce8\u9500\u3002", (String)"GuaranteeContractHelper_1", (String)"tmc-gm-common", (Object[])new Object[0]));
        }
        if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269\u5355\u636e\u72b6\u6001\u975e\u5df2\u5ba1\u6838\u3002", (String)"GuaranteeContractHelper_2", (String)"tmc-gm-common", (Object[])new Object[0]));
        }
        boolean isGetLock = MutexServiceHelper.request((String)pledgeBill.getString("id"), (String)"gm_pledgebill", (String)OPERNAME);
        if (!isGetLock) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269%s\u6b63\u5728\u88ab\u66f4\u65b0, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"GuaranteeContractHelper_4", (String)"tmc-gm-common", (Object[])new Object[0]), pledgeBill.getString("billno")));
        }
        try {
            GuaranteeContractHelper.handlePledgeBill((DynamicObject)pledgeBill, pleAmt, isCancel, beginDate, endDate);
        }
        finally {
            MutexServiceHelper.release((String)pledgeBill.getString("id"), (String)"gm_pledgebill", (String)OPERNAME);
        }
    }

    public static List<String> checkPleValue(BigDecimal pledgeValue, BigDecimal pleAmt, String billNo) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (pledgeValue.compareTo(BigDecimal.ZERO) <= 0) {
            errorList.add(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269\u65e0\u53ef\u62b5\u62bc\u4ef7\u503c\u3002", (String)"GuaranteeContractHelper_3", (String)"tmc-gm-common", (Object[])new Object[0]));
        }
        if (pleAmt.compareTo(pledgeValue) > 0) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269%s\u7684\u53ef\u62b5\u62bc\u4ef7\u503c\u5c0f\u4e8e\u5f53\u524d\u62b5\u62bc\u4ef7\u503c\u3002", (String)"GuaranteeContractHelper_5", (String)"tmc-gm-common", (Object[])new Object[0]), billNo));
        }
        return errorList;
    }

    private static void handlePledgeBill(DynamicObject pledgeBill, BigDecimal pleAmt, boolean isCancel, Date beginDate, Date endDate) {
        BigDecimal totalPlegVal;
        BigDecimal currentVal = pledgeBill.getBigDecimal("currentappraisedvalue");
        BigDecimal totalPledgeValue = pledgeBill.getBigDecimal("totalpledgevalue");
        BigDecimal pleValue = pledgeBill.getBigDecimal("pledgevalue");
        if (isCancel && totalPledgeValue.compareTo(pleAmt) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269%s\u7684\u7d2f\u8ba1\u62b5\u62bc\u4ef7\u503c\u5c0f\u4e8e\u5f53\u524d\u64a4\u9500\u62c5\u4fdd\u62b5\u62bc\u4ef7\u503c\u3002", (String)"GuaranteeContractHelper_6", (String)"tmc-gm-common", (Object[])new Object[0]), pledgeBill.getString("billno")));
        }
        pledgeBill.set("totalpledgevalue", (Object)totalPledgeValue.add(isCancel ? pleAmt.negate() : pleAmt));
        pledgeBill.set("pledgevalue", (Object)pleValue.add(isCancel ? pleAmt : pleAmt.negate()));
        pledgeBill.set("pledgerate", (Object)pledgeBill.getBigDecimal("totalpledgevalue").multiply(new BigDecimal(100)).divide(currentVal, 0, RoundingMode.UP));
        Date pleEndDate = pledgeBill.getDate("enddate");
        Date pleBeginDate = pledgeBill.getDate("begindate");
        if (!isCancel && (pleEndDate == null || endDate != null && pleEndDate.before(endDate))) {
            pledgeBill.set("enddate", (Object)endDate);
        }
        if (!isCancel && (pleBeginDate == null || beginDate != null && beginDate.before(pleBeginDate))) {
            pledgeBill.set("begindate", (Object)beginDate);
        }
        pledgeBill.set("pledgestatus", (Object)((totalPlegVal = pledgeBill.getBigDecimal("totalpledgevalue")).compareTo(BigDecimal.ZERO) > 0 ? PledgeStatusEnum.PLEDGING.getValue() : PledgeStatusEnum.RELEASEPLEDGE.getValue()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pledgeBill});
    }

    private static Set<String> getPledgeBillSelector() {
        HashSet<String> sel = new HashSet<String>();
        sel.add("id");
        sel.add("pledgestatus");
        sel.add("billstatus");
        sel.add("billno");
        sel.add("pledgevalue");
        sel.add("currentappraisedvalue");
        sel.add("totalpledgevalue");
        sel.add("pledgerate");
        sel.add("enddate");
        sel.add("begindate");
        return sel;
    }

    public static BigDecimal getContractDutyAmt(Long contractId) {
        QFilter gcFilter = new QFilter("gcontract.id", "=", (Object)contractId);
        gcFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection gcUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gdebtbalance", "gexchrate"), (QFilter[])new QFilter[]{gcFilter});
        BigDecimal totalDutyAmt = BigDecimal.ZERO;
        for (DynamicObject gcUse : gcUseBills) {
            BigDecimal balance = gcUse.getBigDecimal("gdebtbalance");
            balance = balance.multiply(gcUse.getBigDecimal("gexchrate"));
            totalDutyAmt = totalDutyAmt.add(balance);
        }
        return totalDutyAmt;
    }

    public static BigDecimal getContractDutyAmtExcludeCreditLimit(Long contractId) {
        QFilter gcFilter = new QFilter("gcontract.id", "=", (Object)contractId);
        gcFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        gcFilter.and(new QFilter("gsrcbilltype", "not in", (Object)new String[]{"cfm_creditlimit", "creditm_limit_framework"}));
        DynamicObjectCollection gcUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gdebtbalance", "gratio", "gexchrate", "gsrcbilltype", "gsrcbillid", "gcontract"), (QFilter[])new QFilter[]{gcFilter});
        Set<Long> cdmIds = GuaranteeContractHelper.getDraftIds(gcUseBills);
        Map<Long, BigDecimal> letterCreditMap = GuaranteeContractHelper.getLetterCreditMap(gcUseBills);
        Map<Long, BigDecimal> loanBillMap = GuaranteeContractHelper.getLoanBillMap(gcUseBills);
        BigDecimal totalDutyAmt = BigDecimal.ZERO;
        for (DynamicObject gcUse : gcUseBills) {
            if ("cdm_payablebill".equals(gcUse.get("gsrcbilltype")) && cdmIds.contains(gcUse.getLong("gsrcbillid"))) continue;
            BigDecimal balance = gcUse.getBigDecimal("gdebtbalance");
            if ("lc_lettercredit".equals(gcUse.get("gsrcbilltype")) && EmptyUtil.isNoEmpty((BigDecimal)letterCreditMap.get(gcUse.getLong("gsrcbillid")))) {
                balance = letterCreditMap.get(gcUse.getLong("gsrcbillid")).multiply(gcUse.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED, 4, RoundingMode.HALF_UP);
            } else if (Arrays.asList("cfm_loanbill_b_l", "cfm_loanbill_e_l", "cfm_loanbill", "cfm_loanbill_bond", "cim_invest_loanbill").contains(gcUse.get("gsrcbilltype")) && EmptyUtil.isNoEmpty((BigDecimal)loanBillMap.get(gcUse.getLong("gsrcbillid")))) {
                balance = loanBillMap.get(gcUse.getLong("gsrcbillid")).multiply(gcUse.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED, 4, RoundingMode.HALF_UP);
            }
            balance = balance.multiply(gcUse.getBigDecimal("gexchrate"));
            totalDutyAmt = totalDutyAmt.add(balance);
        }
        return totalDutyAmt;
    }

    private static Set<Long> getDraftIds(DynamicObjectCollection gcUseBills) {
        HashSet<Long> cdmIds = new HashSet<Long>(16);
        Set ids = gcUseBills.stream().filter(f -> "cdm_payablebill".equals(f.getString("gsrcbilltype"))).map(g -> g.getLong("gsrcbillid")).collect(Collectors.toSet());
        if (ids.isEmpty()) {
            return cdmIds;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("draftbillstatus", "in", Arrays.asList("splited", "payoffed"))};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GuaranteeContractHelpercdm_payablebill", (String)"cdm_payablebill", (String)"id", (QFilter[])qFilters, null);
        if (dataSet.isEmpty()) {
            return cdmIds;
        }
        for (Row payableBill : dataSet.copy()) {
            cdmIds.add(payableBill.getLong("id"));
        }
        return cdmIds;
    }

    public static Map<Long, BigDecimal> getLoanBillMap(DynamicObjectCollection gcUseBills) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(16);
        Set ids = gcUseBills.stream().filter(f -> Arrays.asList("cfm_loanbill_b_l", "cfm_loanbill_e_l", "cim_invest_loanbill").contains(f.getString("gsrcbilltype"))).map(g -> g.getLong("gsrcbillid")).collect(Collectors.toSet());
        if (ids.isEmpty()) {
            return map;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("loantype", "!=", (Object)"sl")};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GuaranteeContractHelpercfm_loanbill", (String)"cfm_loanbill", (String)"id,drawamount", (QFilter[])qFilters, null);
        HashSet<Long> cfmIds = new HashSet<Long>(16);
        for (Row loanBill : dataSet.copy()) {
            cfmIds.add(loanBill.getLong("id"));
        }
        QFilter[] repaymentFilters = new QFilter[]{new QFilter("loans.e_loanbill.id", "in", cfmIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
        DataSet repaymentDs = QueryServiceHelper.queryDataSet((String)"GuaranteeContractHelpercfm_repaymentbill", (String)"cfm_repaymentbill", (String)"id,loans.e_loanbill.id as loanbillid,loans.e_repayamount as repayamount", (QFilter[])repaymentFilters, null);
        DataSet repaymentGroupDs = repaymentDs.groupBy(new String[]{"loanbillid"}).sum("repayamount").finish();
        if ((dataSet = dataSet.leftJoin(repaymentGroupDs).on("id", "loanbillid").select(new String[]{"id", "drawamount-case when repayamount = null then 0 else repayamount end as amount"}).finish()).isEmpty()) {
            return map;
        }
        for (Row letterCredit : dataSet.copy()) {
            map.put(letterCredit.getLong("id"), letterCredit.getBigDecimal("amount"));
        }
        return map;
    }

    public static Map<Long, Boolean> getExtCreditGuarantee(Set<Long> guaranteeContractSet) {
        DynamicObjectCollection guaranteeContractCol = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)String.join((CharSequence)",", "id", "guarantee", "guarantee.creditguarantee"), (QFilter[])new QFilter[]{new QFilter("id", "in", guaranteeContractSet)});
        HashMap<Long, Boolean> varietiesMap = new HashMap<Long, Boolean>(guaranteeContractSet.size());
        for (DynamicObject guaranteeContract : guaranteeContractCol) {
            varietiesMap.put(guaranteeContract.getLong("id"), guaranteeContract.getBoolean("guarantee.creditguarantee"));
        }
        return varietiesMap;
    }

    public static Map<Long, BigDecimal> getLetterCreditMap(DynamicObjectCollection gcUseBills) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(16);
        Set ids = gcUseBills.stream().filter(f -> "lc_lettercredit".equals(f.getString("gsrcbilltype"))).map(g -> g.getLong("gsrcbillid")).collect(Collectors.toSet());
        if (ids.isEmpty()) {
            return map;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GuaranteeContractHelperlc_lettercredit", (String)"lc_lettercredit", (String)"id,amount*(1+amountscaleupper/100) as debtamount", (QFilter[])qFilters, null);
        HashSet<Long> lcIds = new HashSet<Long>(16);
        for (Row letterCredit : dataSet.copy()) {
            lcIds.add(letterCredit.getLong("id"));
        }
        QFilter[] arrivalFilters = new QFilter[]{new QFilter("lettercredit.id", "in", lcIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
        DataSet arrivalDs = QueryServiceHelper.queryDataSet((String)"GuaranteeContractHelperlc_arrival", (String)"lc_arrival", (String)"id,lettercredit.id as lettercreditid,doneamount", (QFilter[])arrivalFilters, null);
        DataSet arrivalGroupDs = arrivalDs.groupBy(new String[]{"lettercreditid"}).sum("doneamount").finish();
        if ((dataSet = dataSet.leftJoin(arrivalGroupDs).on("id", "lettercreditid").select(new String[]{"id", "debtamount-case when doneamount = null then 0 else doneamount end as amount"}).finish()).isEmpty()) {
            return map;
        }
        for (Row letterCredit : dataSet.copy()) {
            map.put(letterCredit.getLong("id"), letterCredit.getBigDecimal("amount"));
        }
        return map;
    }

    public static DynamicObject getLetterOfGua(Long id) {
        DynamicObject letterOfGuarantee = TmcDataServiceHelper.loadSingle((Object)id, (String)"gm_letterofguarantee");
        GuaranteeUseHelper.genContractUseInfo((DynamicObject)letterOfGuarantee);
        return letterOfGuarantee;
    }

    public static void updateGuaranteeType(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection guaranteedCollection;
            DynamicObjectCollection guaOrgCollection = dataEntity.getDynamicObjectCollection("entry_guaranteeorg");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)guaOrgCollection)) {
                dataEntity.set("guaranteetype", (Object)((DynamicObject)guaOrgCollection.get(0)).getString("a_guaranteetype"));
                dataEntity.set("guaranteeorg", (Object)((DynamicObject)guaOrgCollection.get(0)).getString("a_guaranteeorg"));
                dataEntity.set("guaranteeorgtext", (Object)((DynamicObject)guaOrgCollection.get(0)).getString("a_guaranteeorgtext"));
                if (guaOrgCollection.size() > 1) {
                    dataEntity.set("guaranteeorgtext", (Object)(((DynamicObject)guaOrgCollection.get(0)).getString("a_guaranteeorgtext") + LetterOfGuaranteeHelper.getEndFlag()));
                }
            } else {
                dataEntity.set("guaranteetype", null);
                dataEntity.set("guaranteeorg", (Object)0L);
                dataEntity.set("guaranteeorgtext", null);
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(guaranteedCollection = dataEntity.getDynamicObjectCollection("entry_guaranteedorg")))) {
                dataEntity.set("reguaranteetype", (Object)((DynamicObject)guaranteedCollection.get(0)).getString("b_reguaranteetype"));
                dataEntity.set("guaranteedorg", (Object)((DynamicObject)guaranteedCollection.get(0)).getString("b_guaranteedorg"));
                dataEntity.set("guaranteedorgtext", (Object)((DynamicObject)guaranteedCollection.get(0)).getString("b_guaranteedorgtext"));
                if (guaranteedCollection.size() <= 1) continue;
                dataEntity.set("guaranteedorgtext", (Object)(((DynamicObject)guaranteedCollection.get(0)).getString("b_guaranteedorgtext") + LetterOfGuaranteeHelper.getEndFlag()));
                continue;
            }
            dataEntity.set("reguaranteetype", null);
            dataEntity.set("guaranteedorg", (Object)0L);
            dataEntity.set("guaranteedorgtext", null);
        }
    }
}

