/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.CtrlLimitEnum;
import kd.tmc.gm.common.enums.GmSourceBillTypeEnum;
import kd.tmc.gm.common.enums.GuaContractApplTypeEnum;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;

public class GuaranteeQuotaHelper {
    private static final Log logger = LogFactory.getLog(GuaranteeQuotaHelper.class);
    public static final String QUOTA_PROP_NAME = String.join((CharSequence)",", "id", "number", "status", "ctrllimit", "org", "name", "begindate", "enddate", "quotaproperty", "currency", "totalamount", "usedquota", "advancequota", "availablequota", "enable", "entry", String.join((CharSequence)".", "entry", "gmbilltype"), String.join((CharSequence)".", "entry", "gmbillno"), String.join((CharSequence)".", "entry", "gmbillid"), String.join((CharSequence)".", "entry", "gmbegindate"), String.join((CharSequence)".", "entry", "gmenddate"), String.join((CharSequence)".", "entry", "gmcurrency"), String.join((CharSequence)".", "entry", "gmamount"), String.join((CharSequence)".", "entry", "gmadvancequota"), String.join((CharSequence)".", "entry", "gmactualquota"), String.join((CharSequence)".", "entry", "gmdutyamount"), "entry_guaranteedorg", String.join((CharSequence)".", "entry_guaranteedorg", "q_reguaranteetype"), String.join((CharSequence)".", "entry_guaranteedorg", "q_guaranteedorg"), String.join((CharSequence)".", "entry_guaranteedorg", "q_limitamount"), String.join((CharSequence)".", "entry_guaranteedorg", "q_usedquota"), String.join((CharSequence)".", "entry_guaranteedorg", "q_advancequota"), String.join((CharSequence)".", "entry_guaranteedorg", "q_availablequota"));
    private static final String APPLY_PROP_NAME = String.join((CharSequence)",", "billno", "currency", "begindate", "enddate", "entry_guaranteeorg", String.join((CharSequence)".", "entry_guaranteeorg", "a_guaranteetype"), String.join((CharSequence)".", "entry_guaranteeorg", "a_guaranteeorg"), String.join((CharSequence)".", "entry_guaranteeorg", "a_guaranteeorgtext"), String.join((CharSequence)".", "entry_guaranteeorg", "a_gamount"), String.join((CharSequence)".", "entry_guaranteeorg", "a_gdutyamount"), String.join((CharSequence)".", "entry_guaranteeorg", "a_guaranteequota"), "entry_guaranteedorg", String.join((CharSequence)".", "entry_guaranteedorg", "b_reguaranteetype"), String.join((CharSequence)".", "entry_guaranteedorg", "b_guaranteedorg"), String.join((CharSequence)".", "entry_guaranteedorg", "b_guaranteedorgtext"), String.join((CharSequence)".", "entry_guaranteedorg", "b_gamount"), String.join((CharSequence)".", "entry_guaranteedorg", "b_guaranteequota"));
    private static final String CONTRACT_PROP_NAME = String.join((CharSequence)",", "billno", "currency", "begindate", "enddate", "guaranteeway", "entry_guaranteeorg", String.join((CharSequence)".", "entry_guaranteeorg", "a_guaranteetype"), String.join((CharSequence)".", "entry_guaranteeorg", "a_guaranteeorg"), String.join((CharSequence)".", "entry_guaranteeorg", "a_guaranteeorgtext"), String.join((CharSequence)".", "entry_guaranteeorg", "a_gamount"), String.join((CharSequence)".", "entry_guaranteeorg", "a_gdutyamount"), String.join((CharSequence)".", "entry_guaranteeorg", "a_guaranteequota"), "entry_guaranteedorg", String.join((CharSequence)".", "entry_guaranteedorg", "b_reguaranteetype"), String.join((CharSequence)".", "entry_guaranteedorg", "b_guaranteedorg"), String.join((CharSequence)".", "entry_guaranteedorg", "b_guaranteedorgtext"), String.join((CharSequence)".", "entry_guaranteedorg", "b_gamount"), String.join((CharSequence)".", "entry_guaranteedorg", "b_guaranteequota"));
    private static final String QUOTA_USE_PROP_NAME = String.join((CharSequence)",", "gmguaranteequota", "gmadvancequota", "gmactualquota");

    public static QFilter getGuaranteeQuotaFilter(Object guaranteeOrgId, Date beginDate) {
        QFilter filter = new QFilter("availablequota", ">", (Object)0);
        QFilter orgFilter = new QFilter("ctrllimit", "=", (Object)CtrlLimitEnum.GUARANTEE_ORG.getValue());
        orgFilter.and(new QFilter("org.id", "=", guaranteeOrgId));
        filter.and(orgFilter);
        QFilter endDateFilter = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)beginDate));
        filter.and(new QFilter("begindate", "<=", (Object)beginDate).and(endDateFilter));
        return filter;
    }

    public static QFilter getGuaranteedQuotaFilter(String guaranteedOrgType, Object guaranteedOrgId, Date beginDate) {
        if (GuaranteeTypeEnum.OTHER.getValue().equals(guaranteedOrgType)) {
            return new QFilter("id", "in", Collections.emptyList());
        }
        List<String> guaranteedOrgTypeList = Collections.singletonList(guaranteedOrgType);
        if (GuaranteeTypeEnum.ORG.getValue().equals(guaranteedOrgType) || GuaranteeTypeEnum.TMCORG.getValue().equals(guaranteedOrgType)) {
            guaranteedOrgTypeList = Arrays.asList(GuaranteeTypeEnum.ORG.getValue(), GuaranteeTypeEnum.TMCORG.getValue());
        }
        QFilter quotaUseFilter = new QFilter("gmorgid", "=", guaranteedOrgId);
        quotaUseFilter.and(new QFilter("gmorgtype", "in", guaranteedOrgTypeList));
        quotaUseFilter.and(new QFilter("gmguaranteequota.ctrllimit", "=", (Object)CtrlLimitEnum.GUARANTEED_ORG.getValue()));
        DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)QUOTA_USE_PROP_NAME, (QFilter[])new QFilter[]{quotaUseFilter});
        HashMap<Long, BigDecimal> quotaIdMap = new HashMap<Long, BigDecimal>(quotaUseList.size());
        for (DynamicObject quotaUseDO : quotaUseList) {
            BigDecimal usedQuotaTemp = (BigDecimal)quotaIdMap.get(quotaUseDO.getLong("gmguaranteequota"));
            if (EmptyUtil.isEmpty((BigDecimal)usedQuotaTemp)) {
                usedQuotaTemp = BigDecimal.ZERO;
            }
            quotaIdMap.put(quotaUseDO.getLong("gmguaranteequota"), usedQuotaTemp.add(quotaUseDO.getBigDecimal("gmadvancequota")).add(quotaUseDO.getBigDecimal("gmactualquota")));
        }
        QFilter quotaFilter = new QFilter("ctrllimit", "=", (Object)CtrlLimitEnum.GUARANTEED_ORG.getValue()).and(new QFilter("availablequota", ">", (Object)0)).and(new QFilter("entry_guaranteedorg.q_reguaranteetype", "in", guaranteedOrgTypeList)).and(new QFilter("entry_guaranteedorg.q_guaranteedorg", "in", guaranteedOrgId));
        QFilter endDateFilter = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)beginDate));
        quotaFilter.and(new QFilter("begindate", "<=", (Object)beginDate).and(endDateFilter));
        DynamicObjectCollection quotaList = QueryServiceHelper.query((String)"gm_guaranteequota", (String)String.join((CharSequence)",", "id", String.join((CharSequence)".", "entry_guaranteedorg", "q_limitamount")), (QFilter[])new QFilter[]{quotaFilter});
        HashSet<Long> quotaIdSet = new HashSet<Long>(quotaList.size());
        for (DynamicObject quotaDO : quotaList) {
            BigDecimal usedQuota;
            Long quotaId = quotaDO.getLong("id");
            BigDecimal bigDecimal = usedQuota = EmptyUtil.isEmpty((BigDecimal)((BigDecimal)quotaIdMap.get(quotaId))) ? BigDecimal.ZERO : (BigDecimal)quotaIdMap.get(quotaId);
            if (quotaDO.getBigDecimal(String.join((CharSequence)".", "entry_guaranteedorg", "q_limitamount")).compareTo(usedQuota) <= 0) continue;
            quotaIdSet.add(quotaId);
        }
        return new QFilter("id", "in", quotaIdSet);
    }

    public static void writeBackQuota(DynamicObject dynamicObject, String billType) {
        DynamicObject applyBill = GuaranteeQuotaHelper.handleApplyBackQuota(dynamicObject, billType);
        if (applyBill != null) {
            QFilter idFilter = new QFilter("gmbillid", "=", applyBill.getPkValue());
            idFilter.and(new QFilter("gmbilltype", "=", (Object)GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue()));
            DeleteServiceHelper.delete((String)"gm_guaranteequotause", (QFilter[])new QFilter[]{idFilter});
        }
        DynamicObjectCollection guaranteeEntryArr = dynamicObject.getDynamicObjectCollection("entry_guaranteeorg");
        List<DynamicObject> guaranteeUseList = GuaranteeQuotaHelper.genGuaranteeQuotaUse(guaranteeEntryArr, dynamicObject, billType);
        DynamicObjectCollection guaranteedEntryArr = dynamicObject.getDynamicObjectCollection("entry_guaranteedorg");
        List<DynamicObject> guaranteedUseList = GuaranteeQuotaHelper.genGuaranteedQuotaUse(guaranteedEntryArr, dynamicObject, billType);
        guaranteeUseList.addAll(guaranteedUseList);
        SaveServiceHelper.save((DynamicObject[])guaranteeUseList.toArray(new DynamicObject[0]));
        Set<Long> quotaIdSet = guaranteeUseList.stream().map(q -> q.getLong("gmguaranteequota")).collect(Collectors.toSet());
        GuaranteeQuotaHelper.updateQuota(quotaIdSet);
    }

    private static void updateQuota(Set<Long> quotaIdSet) {
        DynamicObject[] quotaBills;
        for (DynamicObject quotaBill : quotaBills = TmcDataServiceHelper.load((String)"gm_guaranteequota", (String)"id,totalamount,usedquota,advancequota,availablequota", (QFilter[])new QFilter[]{new QFilter("id", "in", quotaIdSet)})) {
            QFilter quotaIdFilter = new QFilter("gmguaranteequota", "=", quotaBill.getPkValue());
            DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)QUOTA_USE_PROP_NAME, (QFilter[])new QFilter[]{quotaIdFilter});
            BigDecimal advanceQuotaSum = BigDecimal.ZERO;
            BigDecimal actualQuotaSum = BigDecimal.ZERO;
            for (DynamicObject quotaUseDO : quotaUseList) {
                advanceQuotaSum = advanceQuotaSum.add(quotaUseDO.getBigDecimal("gmadvancequota"));
                actualQuotaSum = actualQuotaSum.add(quotaUseDO.getBigDecimal("gmactualquota"));
            }
            quotaBill.set("usedquota", (Object)actualQuotaSum);
            quotaBill.set("advancequota", (Object)advanceQuotaSum);
            quotaBill.set("availablequota", (Object)quotaBill.getBigDecimal("totalamount").subtract(advanceQuotaSum).subtract(actualQuotaSum));
        }
        SaveServiceHelper.update((DynamicObject[])quotaBills);
    }

    private static List<DynamicObject> genGuaranteeQuotaUse(DynamicObjectCollection guaranteeEntryArr, DynamicObject dynamicObject, String billType) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaranteeEntryArr)) {
            return new ArrayList<DynamicObject>(8);
        }
        DynamicObject currencyDO = dynamicObject.getDynamicObject("currency");
        Long billId = dynamicObject.getLong("id");
        Date beginDate = dynamicObject.getDate("begindate");
        Date endDate = dynamicObject.getDate("enddate");
        ArrayList<DynamicObject> guaranteeUseList = new ArrayList<DynamicObject>(guaranteeEntryArr.size());
        for (DynamicObject guaranteeEntry : guaranteeEntryArr) {
            DynamicObject guaranteeQuota = guaranteeEntry.getDynamicObject("a_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            DynamicObject quotaUseDO = TmcDataServiceHelper.newDynamicObject((String)"gm_guaranteequotause");
            quotaUseDO.set("billno", (Object)dynamicObject.getString("billno"));
            quotaUseDO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            quotaUseDO.set("gmguaranteequota", (Object)guaranteeQuota.getLong("id"));
            quotaUseDO.set("gmbilltype", (Object)billType);
            quotaUseDO.set("gmbillid", (Object)billId);
            quotaUseDO.set("gmcurrency", (Object)currencyDO);
            quotaUseDO.set("gmbegindate", (Object)beginDate);
            quotaUseDO.set("gmenddate", (Object)endDate);
            quotaUseDO.set("gmorgtype", (Object)guaranteeEntry.getString("a_guaranteetype"));
            quotaUseDO.set("gmorgname", (Object)guaranteeEntry.getString("a_guaranteeorgtext"));
            quotaUseDO.set("gmorgid", (Object)guaranteeEntry.getString("a_guaranteeorg"));
            BigDecimal amount = guaranteeEntry.getBigDecimal("a_gamount");
            quotaUseDO.set("gmamount", (Object)amount);
            BigDecimal quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal(guaranteeQuota, currencyDO.getLong("id"), amount);
            if (GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue().equals(billType)) {
                quotaUseDO.set("gmadvancequota", (Object)quotaAmt);
            } else if (GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue().equals(billType)) {
                quotaUseDO.set("gmactualquota", (Object)quotaAmt);
            }
            guaranteeUseList.add(quotaUseDO);
        }
        return guaranteeUseList;
    }

    private static List<DynamicObject> genGuaranteedQuotaUse(DynamicObjectCollection guaranteedEntryArr, DynamicObject dynamicObject, String billType) {
        if (null == guaranteedEntryArr || guaranteedEntryArr.isEmpty()) {
            return new ArrayList<DynamicObject>(8);
        }
        DynamicObject currencyDO = dynamicObject.getDynamicObject("currency");
        Long currencyId = currencyDO.getLong("id");
        String billNo = dynamicObject.getString("billno");
        Long billId = dynamicObject.getLong("id");
        Date beginDate = dynamicObject.getDate("begindate");
        Date endDate = dynamicObject.getDate("enddate");
        HashMap<Long, BigDecimal> amountMap = new HashMap<Long, BigDecimal>(guaranteedEntryArr.size());
        for (DynamicObject guaranteedEntry : guaranteedEntryArr) {
            DynamicObject guaranteeQuota = guaranteedEntry.getDynamicObject("b_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            BigDecimal amountTemp = (BigDecimal)amountMap.get((Long)guaranteeQuota.getPkValue());
            if (amountTemp == null || amountTemp.compareTo(Constants.ZERO) == 0) {
                amountTemp = BigDecimal.ZERO;
            }
            amountTemp = amountTemp.add(guaranteedEntry.getBigDecimal("b_gamount"));
            amountMap.put((Long)guaranteeQuota.getPkValue(), amountTemp);
        }
        ArrayList<DynamicObject> guaranteeUseList = new ArrayList<DynamicObject>(guaranteedEntryArr.size());
        BigDecimal quotaAmtSum = BigDecimal.ZERO;
        for (int i = 0; i < guaranteedEntryArr.size(); ++i) {
            BigDecimal quotaAmt;
            BigDecimal quotaAmtTemp;
            DynamicObject guaranteedEntry = (DynamicObject)guaranteedEntryArr.get(i);
            DynamicObject guaranteeQuota = guaranteedEntry.getDynamicObject("b_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            DynamicObject quotaUseDO = TmcDataServiceHelper.newDynamicObject((String)"gm_guaranteequotause");
            quotaUseDO.set("billno", (Object)billNo);
            quotaUseDO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            quotaUseDO.set("gmguaranteequota", (Object)guaranteeQuota.getLong("id"));
            quotaUseDO.set("gmbilltype", (Object)billType);
            quotaUseDO.set("gmbillid", (Object)billId);
            quotaUseDO.set("gmcurrency", (Object)currencyDO);
            quotaUseDO.set("gmbegindate", (Object)beginDate);
            quotaUseDO.set("gmenddate", (Object)endDate);
            quotaUseDO.set("gmorgtype", (Object)guaranteedEntry.getString("b_reguaranteetype"));
            quotaUseDO.set("gmorgname", (Object)guaranteedEntry.getString("b_guaranteedorgtext"));
            quotaUseDO.set("gmorgid", (Object)guaranteedEntry.getString("b_guaranteedorg"));
            BigDecimal amountTotal = (BigDecimal)amountMap.get((Long)guaranteeQuota.getPkValue());
            BigDecimal amount = guaranteedEntry.getBigDecimal("b_gamount");
            quotaUseDO.set("gmamount", (Object)amount);
            BigDecimal bigDecimal = quotaAmtTemp = EmptyUtil.isEmpty((BigDecimal)amountTotal) ? null : GuaranteeQuotaHelper.getQuotaBigDecimal(guaranteeQuota, currencyId, amountTotal);
            if (i == guaranteedEntryArr.size() - 1 && quotaAmtTemp != null && quotaAmtTemp.subtract(quotaAmtSum) != null && quotaAmtTemp.subtract(quotaAmtSum).compareTo(Constants.ZERO) != 0) {
                quotaAmt = quotaAmtTemp.subtract(quotaAmtSum);
            } else {
                quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal(guaranteeQuota, currencyId, amount);
                quotaAmtSum = quotaAmtSum.add(quotaAmt == null ? BigDecimal.ZERO : quotaAmt);
            }
            if (GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue().equals(billType)) {
                quotaUseDO.set("gmadvancequota", (Object)quotaAmt);
            } else if (GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue().equals(billType)) {
                quotaUseDO.set("gmactualquota", (Object)quotaAmt);
            }
            guaranteeUseList.add(quotaUseDO);
        }
        return guaranteeUseList;
    }

    public static DynamicObject handleApplyBackQuota(DynamicObject contractBill, String billType) {
        if (GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue().equals(billType)) {
            return null;
        }
        String applyBillNo = contractBill.getString("applybillno");
        DynamicObject applyBill = contractBill.getDynamicObject("applybill");
        if (EmptyUtil.isEmpty((String)applyBillNo) && EmptyUtil.isNoEmpty((DynamicObject)applyBill)) {
            applyBillNo = applyBill.getString("billno");
        }
        if (EmptyUtil.isEmpty((String)applyBillNo)) {
            return null;
        }
        QFilter qFilter = new QFilter("billno", "=", (Object)applyBillNo);
        applyBill = TmcDataServiceHelper.loadSingle((String)"gm_guaranteeapply", (String)APPLY_PROP_NAME, (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)applyBill)) {
            return null;
        }
        return applyBill;
    }

    public static BigDecimal getAvailableQuota(DynamicObject entryReGua) {
        return entryReGua.getBigDecimal("q_limitamount").subtract(entryReGua.getBigDecimal("q_usedquota")).subtract(entryReGua.getBigDecimal("q_advancequota"));
    }

    public static BigDecimal getQuotaBigDecimal(DynamicObject guaranteeQuota, Long currencyId, BigDecimal amount) {
        DynamicObject baseCurrency = guaranteeQuota.getDynamicObject("currency");
        Long baseCurrencyId = baseCurrency.getLong("id");
        Long currentOrgId = guaranteeQuota.getDynamicObject("org").getLong("id");
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (currencyId != null && !currencyId.equals(baseCurrencyId) && EmptyUtil.isEmpty((BigDecimal)(exchangeRate = TmcBusinessBaseHelper.getExchangeRate((long)currencyId, (long)baseCurrencyId, (long)currentOrgId, (Date)DateUtils.getCurrentDate())))) {
            return null;
        }
        return amount.multiply(exchangeRate).setScale(baseCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
    }

    public static void writeBackAllQuota(DynamicObject dynamicObject, String billType) {
        DynamicObjectCollection guaranteedEntryArr;
        HashSet<Long> quotaIdSet = new HashSet<Long>(16);
        DynamicObjectCollection guaranteeEntryArr = dynamicObject.getDynamicObjectCollection("entry_guaranteeorg");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)guaranteeEntryArr)) {
            for (DynamicObject guaranteeEntry : guaranteeEntryArr) {
                DynamicObject guaranteeQuota = guaranteeEntry.getDynamicObject("a_guaranteequota");
                if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota) || EmptyUtil.isEmpty((DynamicObject)(guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.get("id"), (String)"gm_guaranteequota", (String)QUOTA_PROP_NAME))) || "no_cycle".equals(guaranteeQuota.getString("quotaproperty"))) continue;
                quotaIdSet.add(guaranteeQuota.getLong("id"));
                QFilter idFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.get("id"));
                idFilter.and(new QFilter("gmorgtype", "=", (Object)guaranteeEntry.getString("a_guaranteetype")));
                idFilter.and(new QFilter("gmorgid", "=", (Object)guaranteeEntry.getLong("a_guaranteeorg")));
                idFilter.and(new QFilter("gmbilltype", "=", (Object)billType));
                idFilter.and(new QFilter("gmbillid", "=", dynamicObject.get("id")));
                DeleteServiceHelper.delete((String)"gm_guaranteequotause", (QFilter[])idFilter.toArray());
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(guaranteedEntryArr = dynamicObject.getDynamicObjectCollection("entry_guaranteedorg")))) {
            for (DynamicObject guaranteedEntry : guaranteedEntryArr) {
                DynamicObject guaranteeQuota = guaranteedEntry.getDynamicObject("b_guaranteequota");
                if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota) || EmptyUtil.isEmpty((DynamicObject)(guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.get("id"), (String)"gm_guaranteequota", (String)QUOTA_PROP_NAME))) || "no_cycle".equals(guaranteeQuota.getString("quotaproperty"))) continue;
                quotaIdSet.add(guaranteeQuota.getLong("id"));
                QFilter idFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.get("id"));
                idFilter.and(new QFilter("gmorgtype", "=", (Object)guaranteedEntry.getString("b_reguaranteetype")));
                idFilter.and(new QFilter("gmorgid", "=", (Object)guaranteedEntry.getLong("b_guaranteedorg")));
                idFilter.and(new QFilter("gmbilltype", "=", (Object)billType));
                idFilter.and(new QFilter("gmbillid", "=", dynamicObject.get("id")));
                DeleteServiceHelper.delete((String)"gm_guaranteequotause", (QFilter[])idFilter.toArray());
            }
        }
        GuaranteeQuotaHelper.updateQuota(quotaIdSet);
    }

    public static void cancelWriteBackAllQuota(DynamicObject dynamicObject, String billType) {
        DynamicObjectCollection guaranteedEntryArr;
        DynamicObject currencyDO = dynamicObject.getDynamicObject("currency");
        Long currencyId = currencyDO.getLong("id");
        Long billId = dynamicObject.getLong("id");
        Date beginDate = dynamicObject.getDate("begindate");
        Date endDate = dynamicObject.getDate("enddate");
        ArrayList<DynamicObject> guaranteeUseList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection guaranteeEntryArr = dynamicObject.getDynamicObjectCollection("entry_guaranteeorg");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)guaranteeEntryArr)) {
            for (DynamicObject guaranteeEntry : guaranteeEntryArr) {
                Object guaranteeQuota = guaranteeEntry.getDynamicObject("a_guaranteequota");
                if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota) || EmptyUtil.isEmpty((DynamicObject)(guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.get("id"), (String)"gm_guaranteequota", (String)QUOTA_PROP_NAME))) || "no_cycle".equals(guaranteeQuota.getString("quotaproperty"))) continue;
                DynamicObject quotaUseDO = TmcDataServiceHelper.newDynamicObject((String)"gm_guaranteequotause");
                quotaUseDO.set("billno", (Object)dynamicObject.getString("billno"));
                quotaUseDO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                quotaUseDO.set("gmguaranteequota", (Object)guaranteeQuota.getLong("id"));
                quotaUseDO.set("gmbilltype", (Object)billType);
                quotaUseDO.set("gmbillid", (Object)billId);
                quotaUseDO.set("gmcurrency", (Object)currencyDO);
                quotaUseDO.set("gmbegindate", (Object)beginDate);
                quotaUseDO.set("gmenddate", (Object)endDate);
                quotaUseDO.set("gmorgtype", (Object)guaranteeEntry.getString("a_guaranteetype"));
                quotaUseDO.set("gmorgname", (Object)guaranteeEntry.getString("a_guaranteeorgtext"));
                quotaUseDO.set("gmorgid", (Object)guaranteeEntry.getString("a_guaranteeorg"));
                BigDecimal amount = guaranteeEntry.getBigDecimal("a_gamount");
                quotaUseDO.set("gmamount", (Object)amount);
                BigDecimal quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal((DynamicObject)guaranteeQuota, currencyId, amount);
                if (GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue().equals(billType)) {
                    quotaUseDO.set("gmadvancequota", (Object)quotaAmt);
                } else if (GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue().equals(billType)) {
                    quotaUseDO.set("gmactualquota", (Object)quotaAmt);
                }
                guaranteeUseList.add(quotaUseDO);
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(guaranteedEntryArr = dynamicObject.getDynamicObjectCollection("entry_guaranteedorg")))) {
            HashMap<Long, BigDecimal> amountMap = new HashMap<Long, BigDecimal>(guaranteedEntryArr.size());
            for (DynamicObject guaranteedEntry : guaranteedEntryArr) {
                DynamicObject guaranteeQuota = guaranteedEntry.getDynamicObject("b_guaranteequota");
                if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
                BigDecimal amountTemp = (BigDecimal)amountMap.get((Long)guaranteeQuota.getPkValue());
                if (EmptyUtil.isEmpty((BigDecimal)amountTemp)) {
                    amountTemp = BigDecimal.ZERO;
                }
                amountTemp = amountTemp.add(guaranteedEntry.getBigDecimal("b_gamount"));
                amountMap.put((Long)guaranteeQuota.getPkValue(), amountTemp);
            }
            BigDecimal quotaAmtSum = BigDecimal.ZERO;
            for (int i = 0; i < guaranteedEntryArr.size(); ++i) {
                DynamicObject guaranteedEntry = (DynamicObject)guaranteedEntryArr.get(i);
                DynamicObject guaranteeQuota = guaranteedEntry.getDynamicObject("b_guaranteequota");
                if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota) || EmptyUtil.isEmpty((DynamicObject)(guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.get("id"), (String)"gm_guaranteequota", (String)QUOTA_PROP_NAME))) || "no_cycle".equals(guaranteeQuota.getString("quotaproperty"))) continue;
                DynamicObject quotaUseDO = TmcDataServiceHelper.newDynamicObject((String)"gm_guaranteequotause");
                quotaUseDO.set("billno", (Object)dynamicObject.getString("billno"));
                quotaUseDO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                quotaUseDO.set("gmguaranteequota", (Object)guaranteeQuota.getLong("id"));
                quotaUseDO.set("gmbilltype", (Object)billType);
                quotaUseDO.set("gmbillid", (Object)billId);
                quotaUseDO.set("gmcurrency", (Object)currencyDO);
                quotaUseDO.set("gmbegindate", (Object)beginDate);
                quotaUseDO.set("gmenddate", (Object)endDate);
                quotaUseDO.set("gmorgtype", (Object)guaranteedEntry.getString("b_reguaranteetype"));
                quotaUseDO.set("gmorgname", (Object)guaranteedEntry.getString("b_guaranteedorgtext"));
                quotaUseDO.set("gmorgid", (Object)guaranteedEntry.getString("b_guaranteedorg"));
                BigDecimal amountTotal = (BigDecimal)amountMap.get(guaranteeQuota.getLong("id"));
                BigDecimal amount = guaranteedEntry.getBigDecimal("b_gamount");
                quotaUseDO.set("gmamount", (Object)amount);
                BigDecimal quotaAmt = BigDecimal.ZERO;
                if (i == guaranteedEntryArr.size() - 1 && EmptyUtil.isNoEmpty((BigDecimal)amountTotal)) {
                    BigDecimal quotaAmtTemp = GuaranteeQuotaHelper.getQuotaBigDecimal(guaranteeQuota, currencyId, amountTotal);
                    if (quotaAmtTemp != null) {
                        quotaAmt = quotaAmtTemp.subtract(quotaAmtSum);
                    }
                } else {
                    quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal(guaranteeQuota, currencyId, amount);
                    quotaAmtSum = quotaAmtSum.add(quotaAmt);
                }
                if (GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue().equals(billType)) {
                    quotaUseDO.set("gmadvancequota", (Object)quotaAmt);
                } else if (GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue().equals(billType)) {
                    quotaUseDO.set("gmactualquota", (Object)quotaAmt);
                }
                guaranteeUseList.add(quotaUseDO);
            }
        }
        SaveServiceHelper.save((DynamicObject[])guaranteeUseList.toArray(new DynamicObject[0]));
        Set<Long> quotaIdSet = guaranteeUseList.stream().map(q -> q.getLong("gmguaranteequota")).collect(Collectors.toSet());
        GuaranteeQuotaHelper.updateQuota(quotaIdSet);
    }

    public static DynamicObject getChangeApplyQuota(DynamicObject applyBill) {
        String contractBillNo;
        String applyType = applyBill.getString("applytype");
        if (!GuaContractApplTypeEnum.isChangeApply(applyType)) {
            return null;
        }
        DynamicObject guaContractDo = applyBill.getDynamicObject("guacontract");
        String string = contractBillNo = EmptyUtil.isEmpty((DynamicObject)guaContractDo) ? null : guaContractDo.getString("billno");
        if (EmptyUtil.isEmpty((String)contractBillNo)) {
            return null;
        }
        QFilter qFilter = new QFilter("billno", "=", (Object)contractBillNo);
        DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"gm_guaranteecontract", (String)CONTRACT_PROP_NAME, (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return null;
        }
        return contractBill;
    }

    public static void writeBackChangeApplyQuota(DynamicObject applyBill) {
        String contractBillNo;
        String applyType = applyBill.getString("applytype");
        if (!GuaContractApplTypeEnum.isChangeApply(applyType)) {
            return;
        }
        DynamicObject guaContractDo = applyBill.getDynamicObject("guacontract");
        String string = contractBillNo = EmptyUtil.isEmpty((DynamicObject)guaContractDo) ? null : guaContractDo.getString("billno");
        if (EmptyUtil.isEmpty((String)contractBillNo)) {
            return;
        }
        QFilter qFilter = new QFilter("billno", "=", (Object)contractBillNo);
        DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"gm_guaranteecontract", (String)CONTRACT_PROP_NAME, (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        QFilter idFilter = new QFilter("gmbillid", "=", contractBill.get("id"));
        idFilter.and(new QFilter("gmbilltype", "=", (Object)GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue()));
        DeleteServiceHelper.delete((String)"gm_guaranteequotause", (QFilter[])new QFilter[]{idFilter});
        DynamicObjectCollection guaranteeEntryArr = applyBill.getDynamicObjectCollection("entry_guaranteeorg");
        List<DynamicObject> guaranteeUseList = GuaranteeQuotaHelper.genGuaranteeQuotaUse(guaranteeEntryArr, contractBill, GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue());
        DynamicObjectCollection guaranteedEntryArr = applyBill.getDynamicObjectCollection("entry_guaranteedorg");
        List<DynamicObject> guaranteedUseList = GuaranteeQuotaHelper.genGuaranteedQuotaUse(guaranteedEntryArr, contractBill, GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue());
        guaranteeUseList.addAll(guaranteedUseList);
        SaveServiceHelper.save((DynamicObject[])guaranteeUseList.toArray(new DynamicObject[0]));
        Set<Long> quotaIdSet = guaranteeUseList.stream().map(q -> q.getLong("gmguaranteequota")).collect(Collectors.toSet());
        GuaranteeQuotaHelper.updateQuota(quotaIdSet);
    }

    public static void cancelWriteBackChangeApplyQuota(DynamicObject guaranteeContract, DynamicObject oldContractBill) {
        QFilter idFilter = new QFilter("gmbillid", "=", guaranteeContract.get("id"));
        idFilter.and(new QFilter("gmbilltype", "=", (Object)GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue()));
        DeleteServiceHelper.delete((String)"gm_guaranteequotause", (QFilter[])new QFilter[]{idFilter});
        if (!oldContractBill.containsProperty("entry_guaranteeorg") || !oldContractBill.containsProperty("entry_guaranteedorg")) {
            return;
        }
        DynamicObjectCollection guaranteeEntryArr = oldContractBill.getDynamicObjectCollection("entry_guaranteeorg");
        List<DynamicObject> guaranteeUseList = GuaranteeQuotaHelper.genGuaranteeQuotaUse(guaranteeEntryArr, oldContractBill, GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue());
        DynamicObjectCollection guaranteedEntryArr = oldContractBill.getDynamicObjectCollection("entry_guaranteedorg");
        List<DynamicObject> guaranteedUseList = GuaranteeQuotaHelper.genGuaranteedQuotaUse(guaranteedEntryArr, oldContractBill, GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue());
        guaranteeUseList.addAll(guaranteedUseList);
        SaveServiceHelper.save((DynamicObject[])guaranteeUseList.toArray(new DynamicObject[0]));
        Set<Long> quotaIdSet = guaranteeUseList.stream().map(q -> q.getLong("gmguaranteequota")).collect(Collectors.toSet());
        GuaranteeQuotaHelper.updateQuota(quotaIdSet);
    }

    public static void cancelWriteBackQuota(DynamicObject dynamicObject, String billType) {
        DynamicObject applyBill;
        QFilter idFilter = new QFilter("gmbillid", "=", dynamicObject.getPkValue());
        idFilter.and(new QFilter("gmbilltype", "=", (Object)billType));
        DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)QUOTA_USE_PROP_NAME, (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)quotaUseList)) {
            DeleteServiceHelper.delete((String)"gm_guaranteequotause", (QFilter[])new QFilter[]{idFilter});
        }
        if ((applyBill = GuaranteeQuotaHelper.handleApplyBackQuota(dynamicObject, billType)) != null) {
            DynamicObjectCollection guaranteeEntryArr = applyBill.getDynamicObjectCollection("entry_guaranteeorg");
            List<DynamicObject> guaranteeUseList = GuaranteeQuotaHelper.genGuaranteeQuotaUse(guaranteeEntryArr, applyBill, GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue());
            DynamicObjectCollection guaranteedEntryArr = applyBill.getDynamicObjectCollection("entry_guaranteedorg");
            List<DynamicObject> guaranteedUseList = GuaranteeQuotaHelper.genGuaranteedQuotaUse(guaranteedEntryArr, applyBill, GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue());
            guaranteeUseList.addAll(guaranteedUseList);
            SaveServiceHelper.save((DynamicObject[])guaranteeUseList.toArray(new DynamicObject[0]));
        }
        Set<Long> quotaIdSet = quotaUseList.stream().map(q -> q.getLong("gmguaranteequota")).collect(Collectors.toSet());
        GuaranteeQuotaHelper.updateQuota(quotaIdSet);
    }
}

