/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.common.enums.GuaranteeWayEnum;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractBaseF7Plugin
extends AbstractBasePlugIn {
    protected abstract Map<String, Pair<String, String>> getFieldMap();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Map<String, Pair<String, String>> fieldMap = this.getFieldMap();
        if (fieldMap != null && fieldMap.size() > 0) {
            Set<String> fields = fieldMap.keySet().stream().collect(Collectors.toSet());
            this.addClickListeners(fields.toArray(new String[0]));
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (this.getFieldMap().containsKey(key) && EmptyUtil.isNoEmpty((Object)e.getValue())) {
            String typePropDisplayName = this.getTypeDisplayName(key);
            String baseType = this.getBaseType(key);
            if (!this.getTypeOtherValue().equals(baseType)) {
                e.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u975e\u5176\u4ed6\u7c7b\u578b\uff0c\u4e0d\u80fd\u76f4\u63a5\u8f93\u5165\uff0c\u8bf7\u901a\u8fc7\u70b9\u51fb\u9009\u62e9\u3002", (String)"AbstractBaseF7Plugin_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]), typePropDisplayName));
                int entryIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getView().updateView(key, 0, entryIdx);
            }
        }
    }

    private String getTypeDisplayName(String key) {
        String typeField = (String)this.getFieldMap().get(key).getLeft();
        ComboEdit control = (ComboEdit)this.getControl(typeField);
        LocaleString typeDisplayName = control.getProperty().getDisplayName();
        String typePropDisplayName = typeDisplayName.toString();
        return typePropDisplayName;
    }

    protected String getTypeOtherValue() {
        return "other";
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        String key = srcControl.getKey();
        if (this.getFieldMap().containsKey(key)) {
            String baseType = this.getBaseType(key);
            if (EmptyUtil.isEmpty((String)baseType)) {
                String typeField = (String)this.getFieldMap().get(key).getLeft();
                ComboEdit control = (ComboEdit)this.getControl(typeField);
                LocaleString fieldName = control.getProperty().getDisplayName();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"AbstractBaseF7Plugin_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]), fieldName));
                return;
            }
            if (!this.getTypeOtherValue().equals(baseType)) {
                this.showF7(key);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        if (this.skipHandleTypeChangeOnThisPlugin(e)) {
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (this.getTypeField().contains(key)) {
            String textField = this.getKeyFromType(key);
            String idField = (String)this.getFieldMap().get(textField).getRight();
            this.getModel().setValue(textField, (Object)"");
            this.getModel().setValue(idField, (Object)0L);
        }
        if (this.getFieldMap().containsKey(key) && EmptyUtil.isEmpty((Object)(newValue = changeSet[0].getNewValue()))) {
            this.getModel().setValue((String)this.getFieldMap().get(key).getRight(), (Object)0L);
        }
    }

    protected boolean skipHandleTypeChangeOnThisPlugin(PropertyChangedArgs e) {
        Object newValue;
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        return this.getTypeField().contains(key) && (newValue = changeSet[0].getNewValue()) != null && GuaranteeTypeEnum.ORG.getValue().equals(newValue);
    }

    protected void addCustomParam(String type, ListShowParameter lsp) {
        if (GuaranteeTypeEnum.ORG.getValue().equals(type) || GuaranteeTypeEnum.TMCORG.getValue().equals(type)) {
            lsp.setCustomParam("orgFuncId", (Object)"08");
        }
    }

    private void showF7(String textField) {
        String baseType = this.getBaseType(textField);
        String f7FormId = this.getF7FormId(baseType);
        if (f7FormId == null) {
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)f7FormId, (boolean)false, (int)3, (boolean)true);
        if (!GuaranteeTypeEnum.ORG.getValue().equals(baseType) && ("a_guaranteeorgtext".equals(textField) || "b_guaranteedorgtext".equals(textField))) {
            lsp.setMultiSelect(true);
        }
        this.addCustomFilter(textField, lsp);
        this.addCustomParam(baseType, lsp);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, textField);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String type = e.getActionId();
        if (this.getFieldMap().containsKey(type)) {
            ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)e.getReturnData();
            if (selectedRowCol == null) {
                return;
            }
            Long selectPk = (Long)selectedRowCol.get(0).getPrimaryKeyValue();
            String name = selectedRowCol.get(0).getName();
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)((String)this.getFieldMap().get(type).getRight()), (Object)selectPk);
            this.getModel().setValue(type, (Object)name);
            if (Arrays.asList("a_guaranteeorgtext", "b_guaranteedorgtext").contains(type)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)("a_guaranteeorgtext".equals(type) ? "a_guaranteequota" : "b_guaranteequota"), null);
                this.dealNewSelectEntryRow(selectedRowCol, type, (String)this.getModel().getValue((String)this.getFieldMap().get(type).getLeft()));
            }
        }
    }

    private void dealNewSelectEntryRow(ListSelectedRowCollection selectedRowCol, String type, String orgType) {
        if (selectedRowCol.size() <= 1) {
            return;
        }
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
        if ("a_guaranteeorgtext".equals(type)) {
            ArrayList guaEntryDataList = new ArrayList(selectedRowCol.size());
            DynamicObjectCollection guaranteeCollection = this.getModel().getEntryEntity("entry_guaranteeorg");
            for (DynamicObject guaranteeEntry : guaranteeCollection) {
                HashMap<String, Object> entry = new HashMap<String, Object>(16);
                entry.put("a_guaranteetype", guaranteeEntry.get("a_guaranteetype"));
                entry.put("a_guaranteeorg", guaranteeEntry.get("a_guaranteeorg"));
                entry.put("a_guaranteeorgtext", guaranteeEntry.get("a_guaranteeorgtext"));
                entry.put("a_gratio", guaranteeEntry.get("a_gratio"));
                entry.put("a_gamount", guaranteeEntry.get("a_gamount"));
                guaEntryDataList.add(entry);
            }
            for (int i = 1; i < selectedRowCol.size(); ++i) {
                HashMap<String, Object> entry = new HashMap<String, Object>(16);
                entry.put("a_guaranteetype", orgType);
                entry.put("a_guaranteeorg", selectedRowCol.get(i).getPrimaryKeyValue());
                entry.put("a_guaranteeorgtext", selectedRowCol.get(i).getName());
                entry.put("a_gratio", Constants.ONE_HUNDRED);
                entry.put("a_gamount", amount);
                guaEntryDataList.add(entry);
            }
            this.getModel().beginInit();
            TmcViewInputHelper.batchFillEntity((String)"entry_guaranteeorg", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), guaEntryDataList);
            this.getModel().endInit();
            this.getView().updateView("entry_guaranteeorg");
            if (isCrossGuarantee) {
                this.dealReGuaEntryRow(selectedRowCol, orgType, amount, Boolean.FALSE);
            }
        } else if ("b_guaranteedorgtext".equals(type)) {
            this.dealReGuaEntryRow(selectedRowCol, orgType, amount, Boolean.TRUE);
        }
    }

    private void dealReGuaEntryRow(ListSelectedRowCollection selectedRowCol, String orgType, BigDecimal amount, boolean isCal) {
        ArrayList reGuaEntryDataList = new ArrayList(selectedRowCol.size());
        DynamicObjectCollection guaranteedCollection = this.getModel().getEntryEntity("entry_guaranteedorg");
        BigDecimal sumRatio = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject guaranteedEntry : guaranteedCollection) {
            HashMap<String, Object> entry = new HashMap<String, Object>(16);
            entry.put("b_reguaranteetype", guaranteedEntry.get("b_reguaranteetype"));
            entry.put("b_guaranteedorg", guaranteedEntry.get("b_guaranteedorg"));
            entry.put("b_guaranteedorgtext", guaranteedEntry.get("b_guaranteedorgtext"));
            entry.put("b_gratio", guaranteedEntry.get("b_gratio"));
            entry.put("b_gamount", guaranteedEntry.get("b_gamount"));
            reGuaEntryDataList.add(entry);
            if (!isCal) continue;
            sumRatio = sumRatio.add(guaranteedEntry.getBigDecimal("b_gratio"));
            sumAmount = sumAmount.add(guaranteedEntry.getBigDecimal("b_gamount"));
        }
        for (int i = 1; i < selectedRowCol.size(); ++i) {
            HashMap<String, Object> entry = new HashMap<String, Object>(16);
            entry.put("b_reguaranteetype", orgType);
            entry.put("b_guaranteedorg", selectedRowCol.get(i).getPrimaryKeyValue());
            entry.put("b_guaranteedorgtext", selectedRowCol.get(i).getName());
            entry.put("b_gratio", Constants.ONE_HUNDRED);
            entry.put("b_gamount", amount);
            reGuaEntryDataList.add(entry);
            if (!isCal) continue;
            if (sumRatio.compareTo(Constants.ONE_HUNDRED) > 0) {
                entry.put("b_gratio", Constants.ZERO);
                entry.put("b_gamount", Constants.ZERO);
            } else {
                entry.put("b_gratio", Constants.ONE_HUNDRED.subtract(sumRatio));
                entry.put("b_gamount", amount.subtract(sumAmount));
            }
            sumRatio = sumRatio.add((BigDecimal)entry.get("b_gratio"));
            sumAmount = sumAmount.add((BigDecimal)entry.get("b_gamount"));
        }
        this.getModel().beginInit();
        TmcViewInputHelper.batchFillEntity((String)"entry_guaranteedorg", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), reGuaEntryDataList);
        this.getModel().endInit();
        this.getView().updateView("entry_guaranteedorg");
    }

    protected void addCustomFilter(String textField, ListShowParameter lsp) {
        HashSet filterIds;
        String type = this.getBaseType(textField);
        List lspQFilter = lsp.getListFilterParameter().getQFilters();
        if ("a_guaranteeorgtext".equals(textField)) {
            filterIds = new HashSet(16);
            DynamicObjectCollection guaCollection = this.getModel().getEntryEntity("entry_guaranteeorg");
            filterIds.addAll(guaCollection.stream().map(a -> a.getLong("a_guaranteeorg")).collect(Collectors.toList()));
            lspQFilter.add(new QFilter("id", "not in", filterIds));
        } else if ("b_guaranteedorgtext".equals(textField)) {
            filterIds = new HashSet(16);
            DynamicObjectCollection reGuaCollection = this.getModel().getEntryEntity("entry_guaranteedorg");
            filterIds.addAll(reGuaCollection.stream().map(b -> b.getLong("b_guaranteedorg")).collect(Collectors.toList()));
            lspQFilter.add(new QFilter("id", "not in", filterIds));
        }
        if (GuaranteeTypeEnum.TMCBANK.getValue().equals(type)) {
            lspQFilter.add(new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.BANK.getValue()).and(new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())));
        } else if (GuaranteeTypeEnum.TMCNOTBANK.getValue().equals(type)) {
            lspQFilter.add(new QFilter("finorgtype.type", "!=", (Object)FinOrgTypeEnum.BANK.getValue()).and(new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())));
        } else if (OppUnitTypeEnum.CUSTOMER.getValue().equals(type) || OppUnitTypeEnum.SUPPLIER.getValue().equals(type)) {
            DynamicObject org;
            lspQFilter.add(new QFilter("enable", "=", (Object)"1"));
            String mainOrg = this.getModel().getDataEntityType().getMainOrg();
            if (EmptyUtil.isNoEmpty((String)mainOrg) && EmptyUtil.isNoEmpty((DynamicObject)(org = (DynamicObject)this.getModel().getValue(mainOrg)))) {
                lspQFilter.add(BaseDataServiceHelper.getBaseDataFilter((String)type, (Long)org.getLong("id")));
            }
        }
        QFilter customFilter = this.getCustomFilter(textField, type);
        if (customFilter != null) {
            lspQFilter.add(customFilter);
        }
    }

    protected QFilter getCustomFilter(String textField, String type) {
        return null;
    }

    protected String getF7FormId(String type) {
        for (OppUnitTypeEnum value : OppUnitTypeEnum.values()) {
            if (!value.getValue().equals(type)) continue;
            return value.getValue();
        }
        return null;
    }

    private String getBaseType(String textField) {
        String typeField = (String)this.getFieldMap().get(textField).getLeft();
        return (String)this.getModel().getValue(typeField);
    }

    private Set<String> getTypeField() {
        Map<String, Pair<String, String>> fieldMap = this.getFieldMap();
        if (fieldMap == null) {
            return Collections.EMPTY_SET;
        }
        return fieldMap.entrySet().stream().map(o -> (String)((Pair)o.getValue()).getLeft()).collect(Collectors.toSet());
    }

    private String getKeyFromType(String type) {
        Map<String, Pair<String, String>> fieldMap = this.getFieldMap();
        if (EmptyUtil.isEmpty((String)type) || fieldMap == null) {
            return null;
        }
        for (Map.Entry<String, Pair<String, String>> field : fieldMap.entrySet()) {
            if (!type.equals(field.getValue().getLeft())) continue;
            return field.getKey();
        }
        return null;
    }

    public void guaranteePropChange(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        ComboEdit guarantee = (ComboEdit)this.getControl("guaranteeway");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(8);
        if ((oldValue == null || !this.checkWay((String)oldValue)) && newValue != null && this.checkWay((String)newValue) && ((String)newValue).contains(GuaranteeWayEnum.NONE.getValue())) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteeway", (Object)",ensure,ensuamt,mortgage,pledge,other,");
        } else if (newValue != null && ((String)newValue).contains(GuaranteeWayEnum.NONE.getValue())) {
            data.add(new ComboItem(new LocaleString(GuaranteeWayEnum.getName((String)GuaranteeWayEnum.NONE.getValue())), GuaranteeWayEnum.NONE.getValue()));
            guarantee.setComboItems(data);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteeway", (Object)GuaranteeWayEnum.NONE.getValue());
        } else {
            data.add(new ComboItem(new LocaleString(GuaranteeWayEnum.getName((String)GuaranteeWayEnum.ENSURE.getValue())), GuaranteeWayEnum.ENSURE.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeWayEnum.getName((String)GuaranteeWayEnum.ENSUAMT.getValue())), GuaranteeWayEnum.ENSUAMT.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeWayEnum.getName((String)GuaranteeWayEnum.MORTGAGE.getValue())), GuaranteeWayEnum.MORTGAGE.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeWayEnum.getName((String)GuaranteeWayEnum.PLEDGE.getValue())), GuaranteeWayEnum.PLEDGE.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeWayEnum.getName((String)GuaranteeWayEnum.OTHER.getValue())), GuaranteeWayEnum.OTHER.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeWayEnum.getName((String)GuaranteeWayEnum.NONE.getValue())), GuaranteeWayEnum.NONE.getValue()));
            guarantee.setComboItems(data);
        }
    }

    private boolean checkWay(String val) {
        return val.contains(GuaranteeWayEnum.ENSURE.getValue()) && val.contains(GuaranteeWayEnum.ENSUAMT.getValue()) && val.contains(GuaranteeWayEnum.MORTGAGE.getValue()) && val.contains(GuaranteeWayEnum.PLEDGE.getValue()) && val.contains(GuaranteeWayEnum.OTHER.getValue());
    }
}

