/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.common.enums.GuaranteeWayEnum;
import kd.tmc.gm.common.enums.PledgeStatusEnum;
import kd.tmc.gm.common.enums.UseRangeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeQuotaHelper;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGuaranteeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit morF7 = (BasedataEdit)this.getControl("m_pleg");
        morF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit pleF7 = (BasedataEdit)this.getControl("p_pleg");
        pleF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cmF7 = (BasedataEdit)this.getControl("cm_pleg");
        cmF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cpF7 = (BasedataEdit)this.getControl("cp_pleg");
        cpF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap3"});
        EntryGrid morGrid = (EntryGrid)this.getControl("morentity");
        morGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid pleGrid = (EntryGrid)this.getControl("pletgageentity");
        pleGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid cMorGrid = (EntryGrid)this.getControl("cmorentity");
        cMorGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid cPleGrid = (EntryGrid)this.getControl("cpletgageentity");
        cPleGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit guaranteeQuotaEdit = (BasedataEdit)this.getView().getControl("a_guaranteequota");
        guaranteeQuotaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit guaranteedQuotaEdit = (BasedataEdit)this.getView().getControl("b_guaranteequota");
        guaranteedQuotaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleReGuaranteeWay();
        this.handleEntryMorPle();
        this.controlReGuaranteeWay();
        this.initIsCrossGuarantee();
        this.handlerGuaEntryDutyAmt();
        this.handleCounterGuaWay();
        this.handleEntryCounterMorPle();
    }

    private void handlerGuaEntryDutyAmt() {
        Long contractId = (Long)this.getModel().getValue("id");
        BigDecimal dutyAmt = GuaranteeContractHelper.getContractDutyAmtExcludeCreditLimit((Long)contractId);
        if (EmptyUtil.isEmpty((BigDecimal)dutyAmt)) {
            return;
        }
        boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
        DynamicObjectCollection guaOrgEntry = this.getModel().getEntryEntity("entry_guaranteeorg");
        Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        DynamicObject baseCurrencyDo = (DynamicObject)this.getModel().getValue("currency");
        int scale = EmptyUtil.isNoEmpty((DynamicObject)baseCurrencyDo) ? baseCurrencyDo.getInt("amtprecision") : 6;
        for (DynamicObject guaOrgDo : guaOrgEntry) {
            if (isCrossGuarantee && orgId.equals(guaOrgDo.getLong("a_guaranteeorg"))) continue;
            guaOrgDo.set("a_gdutyamount", (Object)guaOrgDo.getBigDecimal("a_gratio").multiply(dutyAmt).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP));
        }
        this.getView().updateView("entry_guaranteeorg");
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "addentry": {
                this.rowBtnClick("newentry", "tabap");
                break;
            }
            case "delentry": {
                this.rowBtnClick("deleteentry", "tabap");
                break;
            }
            case "copyentry": {
                this.rowBtnClick("copyentryrow", "tabap");
                break;
            }
            case "addcentry": {
                this.rowBtnClick("newentry", "tabap2");
                break;
            }
            case "delcentry": {
                this.rowBtnClick("deleteentry", "tabap2");
                break;
            }
            case "copycentry": {
                this.rowBtnClick("copyentryrow", "tabap2");
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.defCurrency();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().contains("newentry")) {
            AbstractOperate op = (AbstractOperate)args.getSource();
            String entityName = String.valueOf(op.getParameter().get("entryId"));
            this.handleByAddRow(entityName);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("entry_guaranteeorg".equals(entryName) || "entry_guaranteedorg".equals(entryName)) {
            this.handleGuaTypeByAddRow(entryName, e.getRowDataEntities()[0].getRowIndex());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
        if ("entry_guaranteeorg".equals(entryName) && isCrossGuarantee) {
            this.getModel().deleteEntryRows("entry_guaranteedorg", e.getRowIndexs());
        }
    }

    private void handleGuaTypeByAddRow(String entityName, int rowIdx) {
        boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
        if ("entry_guaranteeorg".equals(entityName)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"a_gratio", (Object)Constants.ONE_HUNDRED, (int)rowIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"a_gamount", (Object)this.getModel().getValue("amount"), (int)rowIdx);
            if (isCrossGuarantee) {
                this.getModel().createNewEntryRow("entry_guaranteedorg");
            }
        } else if ("entry_guaranteedorg".equals(entityName)) {
            BigDecimal bizAmt = (BigDecimal)this.getModel().getValue("amount");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gratio", (Object)Constants.ONE_HUNDRED, (int)rowIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)this.getModel().getValue("amount"), (int)rowIdx);
            if (isCrossGuarantee) {
                return;
            }
            DynamicObjectCollection guaranteedCollection = this.getModel().getEntryEntity("entry_guaranteedorg");
            BigDecimal sumRatio = BigDecimal.ZERO;
            BigDecimal sumAmount = BigDecimal.ZERO;
            boolean isShow = true;
            for (int i = 0; i < rowIdx; ++i) {
                int j = i;
                if (i > guaranteedCollection.size() - 1) {
                    isShow = false;
                    j = guaranteedCollection.size() - 1;
                }
                DynamicObject guaranteedEntry = (DynamicObject)guaranteedCollection.get(j);
                sumRatio = sumRatio.add(guaranteedEntry.getBigDecimal("b_gratio"));
                sumAmount = sumAmount.add(guaranteedEntry.getBigDecimal("b_gamount"));
            }
            DynamicObject guaranteeVarieties = (DynamicObject)this.getModel().getValue("guarantee");
            boolean isCredit = false;
            if (EmptyUtil.isNoEmpty((DynamicObject)guaranteeVarieties)) {
                boolean bl = isCredit = EmptyUtil.isEmpty((DynamicObject)(guaranteeVarieties = QueryServiceHelper.queryOne((String)"gm_guaranteevarieties", (String)"creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)guaranteeVarieties.getLong("id"))}))) ? false : guaranteeVarieties.getBoolean("creditguarantee");
            }
            if (isCredit) {
                return;
            }
            if (sumRatio.compareTo(Constants.ONE_HUNDRED) > 0) {
                if (isShow) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e100%\u3002", (String)"AbstractGuaranteeEdit_13", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gratio", (Object)Constants.ZERO, (int)rowIdx);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)Constants.ZERO, (int)rowIdx);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gratio", (Object)Constants.ONE_HUNDRED.subtract(sumRatio), (int)rowIdx);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)bizAmt.subtract(sumAmount), (int)rowIdx);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        Object oldVal = e.getChangeSet()[0].getOldValue();
        int rowIdx = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "a_guaranteetype": {
                this.handleAGuaranteeType(newVal, rowIdx);
                break;
            }
            case "a_guaranteeorgtext": {
                this.handleAGuaranteeOrgText(newVal, rowIdx);
                break;
            }
            case "a_gratio": {
                this.checkGRatio("a_gamount", (BigDecimal)newVal, rowIdx);
                break;
            }
            case "a_gamount": {
                this.checkGAmount("a_gratio", (BigDecimal)newVal, (BigDecimal)e.getChangeSet()[0].getOldValue(), rowIdx);
                break;
            }
            case "b_reguaranteetype": {
                this.handleBreGuaranteeType(newVal, rowIdx);
                break;
            }
            case "b_gratio": {
                this.checkGRatio("b_gamount", (BigDecimal)newVal, rowIdx);
                this.checkGuaranteedRatio((BigDecimal)oldVal, rowIdx);
                break;
            }
            case "b_gamount": {
                if (!this.checkGAmount("b_gratio", (BigDecimal)newVal, (BigDecimal)oldVal, rowIdx)) break;
                this.checkGuaranteedAmount((BigDecimal)oldVal, rowIdx);
                break;
            }
            case "creditortype": {
                this.handleCreditorType();
                break;
            }
            case "amount": {
                this.handleAmount();
                break;
            }
            case "currency": {
                Long newGuaId = EmptyUtil.isEmpty((Object)newVal) ? 0L : ((DynamicObject)newVal).getLong("id");
                Long oldGuaId = EmptyUtil.isEmpty((Object)oldVal) ? 0L : ((DynamicObject)oldVal).getLong("id");
                if (newGuaId.equals(oldGuaId)) break;
                this.clearEntryCol("morentity", "m_pleg", "m_pledgevalue", "m_totalpledgevalue");
                this.clearEntryCol("pletgageentity", "p_pleg", "p_pledgevalue", "p_totalpledgevalue");
                break;
            }
            case "guarantee": {
                Long newGuaId = EmptyUtil.isEmpty((Object)newVal) ? 0L : ((DynamicObject)newVal).getLong("id");
                Long oldGuaId = EmptyUtil.isEmpty((Object)oldVal) ? 0L : ((DynamicObject)oldVal).getLong("id");
                if (newGuaId.equals(oldGuaId)) break;
                this.controlGuaranteeVarieties();
                break;
            }
            case "guaranteeway": {
                this.handleReGuaranteeWay();
                break;
            }
            case "e_type": {
                this.handleChangeEType("ensureentity", "e_ensure", "e_ensuretext");
                break;
            }
            case "e_ensurerate": {
                this.handleEnsureRate("ensureentity", "e_ensurerate", "e_amount");
                break;
            }
            case "e_amount": {
                this.handleRowAmount("ensureentity", "e_amount", "e_ensurerate");
                break;
            }
            case "a_type": {
                this.handleChangeEType("ensureamtentity", "a_ensure", "a_ensuretext");
                break;
            }
            case "a_ensurerate": {
                this.handleEnsureRate("ensureamtentity", "a_ensurerate", "a_amount");
                break;
            }
            case "a_amount": {
                this.handleRowAmount("ensureamtentity", "a_amount", "a_ensurerate");
                break;
            }
            case "m_pleg": {
                this.pledgeBaseSelect(e, "mortgage");
                break;
            }
            case "p_pleg": {
                this.pledgeBaseSelect(e, "pledge");
                break;
            }
            case "isneedreg": {
                this.controlReGuaranteeWay();
                boolean isNeedReg = (Boolean)this.getModel().getValue("isneedreg");
                if (!isNeedReg) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"countorguaway", null);
                }
                this.handleCounterGuaWay();
                break;
            }
            case "countorguaway": {
                this.handleCounterGuaWay();
                break;
            }
            case "cm_pleg": {
                this.pledgeBaseBack("cmortgage", rowIdx);
                break;
            }
            case "cp_pleg": {
                this.pledgeBaseBack("cpledge", rowIdx);
                break;
            }
            case "iscrossguarantee": {
                this.getModel().deleteEntryData("entry_guaranteeorg");
                this.getModel().deleteEntryData("entry_guaranteedorg");
                this.initIsCrossGuarantee();
                break;
            }
        }
    }

    public void pledgeBaseBack(String key, int rowIndex) {
        if (StringUtils.equals((CharSequence)"cmortgage", (CharSequence)key)) {
            Object morPle = this.getModel().getValue("cm_pleg", rowIndex);
            this.setBaseDataId((DynamicObject)morPle, "cm_pledgevalue", "cm_totalpledgevalue", "cm_amount", rowIndex);
        } else if (StringUtils.equals((CharSequence)"cpledge", (CharSequence)key)) {
            Object morPle = this.getModel().getValue("cp_pleg", rowIndex);
            this.setBaseDataId((DynamicObject)morPle, "cp_pledgevalue", "cp_totalpledgevalue", "cp_amount", rowIndex);
        }
    }

    private void handleCounterGuaWay() {
        Object countReGuaWay = this.getModel().getValue("countorguaway");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabcensure", "tabcmortgage", "tabcpledge", "advconap2"});
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((Object)countReGuaWay) && EmptyUtil.isNoEmpty((String)String.valueOf(countReGuaWay).replaceAll(",", ""))), new String[]{"advcontoolbarap3", "advconap2"});
        String way = String.valueOf(countReGuaWay);
        String tabKey = "";
        if (way.contains(GuaranteeWayEnum.ENSURE.getValue())) {
            tabKey = "tabcensure";
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabcensure"});
            this.setCounterGuaDefaultVal("censureentity", "ce_type", "ce_ensure");
        }
        if (way.contains(GuaranteeWayEnum.MORTGAGE.getValue())) {
            if (EmptyUtil.isEmpty((String)tabKey)) {
                tabKey = "tabcmortgage";
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabcmortgage"});
        }
        if (way.contains(GuaranteeWayEnum.PLEDGE.getValue())) {
            if (EmptyUtil.isEmpty((String)tabKey)) {
                tabKey = "tabcpledge";
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabcpledge"});
        }
        Tab tab = (Tab)this.getView().getControl("tabap2");
        tab.activeTab(tabKey);
    }

    private void setCounterGuaDefaultVal(String entry, String field, String baseField) {
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        DynamicObjectCollection guaranteedEntry = this.getModel().getEntryEntity("entry_guaranteedorg");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaranteedEntry)) {
            return;
        }
        Object reGuaType = ((DynamicObject)guaranteedEntry.get(0)).get("b_reguaranteetype");
        Object reGuaOrg = ((DynamicObject)guaranteedEntry.get(0)).get("b_guaranteedorg");
        Object reGuaOrgText = ((DynamicObject)guaranteedEntry.get(0)).get("b_guaranteedorgtext");
        Object enType = this.getModel().getValue(field);
        for (int i = 0; i < entryRowCount; ++i) {
            if (!EmptyUtil.isEmpty((Object)enType)) continue;
            this.getModel().setValue(field, GuaranteeTypeEnum.ORG.getValue().equals(reGuaType) ? GuaranteeTypeEnum.TMCORG.getValue() : reGuaType, i);
            this.getModel().setValue(baseField, reGuaOrg, i);
            this.getModel().setValue(baseField + "text", reGuaOrgText, i);
        }
    }

    private void handleEntryCounterMorPle() {
        int i;
        int morEntity = this.getModel().getEntryRowCount("cmorentity");
        int pleEntity = this.getModel().getEntryRowCount("cpletgageentity");
        boolean dataChanged = this.getModel().getDataChanged();
        for (i = 0; i < morEntity; ++i) {
            Object mor = this.getModel().getValue("cm_pleg", i);
            if (mor == null) continue;
            this.getModel().setValue("cm_pledgevalue", (Object)((DynamicObject)mor).getBigDecimal("pledgevalue"), i);
            this.getModel().setValue("cm_totalpledgevalue", (Object)((DynamicObject)mor).getBigDecimal("totalpledgevalue"), i);
        }
        for (i = 0; i < pleEntity; ++i) {
            Object ple = this.getModel().getValue("cp_pleg", i);
            if (ple == null) continue;
            this.getModel().setValue("cp_pledgevalue", (Object)((DynamicObject)ple).getBigDecimal("pledgevalue"), i);
            this.getModel().setValue("cp_totalpledgevalue", (Object)((DynamicObject)ple).getBigDecimal("totalpledgevalue"), i);
        }
        this.getModel().setDataChanged(dataChanged);
    }

    private void controlGuaranteeVarieties() {
        for (int i = 0; i < this.getModel().getEntryEntity("entry_guaranteedorg").size(); ++i) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gratio", (Object)Constants.ZERO, (int)i);
        }
    }

    private void checkGRatio(String propName, BigDecimal val, int rowIdx) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (EmptyUtil.isEmpty((BigDecimal)val)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)0, (int)rowIdx);
            return;
        }
        DynamicObject baseCurrencyDo = (DynamicObject)this.getModel().getValue("currency");
        int scale = EmptyUtil.isNoEmpty((DynamicObject)baseCurrencyDo) ? baseCurrencyDo.getInt("amtprecision") : 6;
        BigDecimal gAmt = amount.multiply(val).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)gAmt, (int)rowIdx);
    }

    private void checkGuaranteedRatio(BigDecimal oldVal, int rowIdx) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        DynamicObjectCollection guaranteedCollection = this.getModel().getEntryEntity("entry_guaranteedorg");
        BigDecimal sumRatio = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (int i = 0; i < guaranteedCollection.size() - 1; ++i) {
            DynamicObject guaranteedEntry = (DynamicObject)guaranteedCollection.get(i);
            sumRatio = sumRatio.add(guaranteedEntry.getBigDecimal("b_gratio"));
            sumAmount = sumAmount.add(guaranteedEntry.getBigDecimal("b_gamount"));
        }
        DynamicObject guaranteeVarieties = (DynamicObject)this.getModel().getValue("guarantee");
        boolean isCredit = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)guaranteeVarieties)) {
            boolean bl = isCredit = EmptyUtil.isEmpty((DynamicObject)(guaranteeVarieties = QueryServiceHelper.queryOne((String)"gm_guaranteevarieties", (String)"creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)guaranteeVarieties.getLong("id"))}))) ? false : guaranteeVarieties.getBoolean("creditguarantee");
        }
        if (isCredit) {
            return;
        }
        if (sumRatio.compareTo(Constants.ONE_HUNDRED) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e100%\u3002", (String)"AbstractGuaranteeEdit_13", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gratio", (Object)oldVal, (int)rowIdx);
            DynamicObject baseCurrencyDo = (DynamicObject)this.getModel().getValue("currency");
            int scale = EmptyUtil.isNoEmpty((DynamicObject)baseCurrencyDo) ? baseCurrencyDo.getInt("amtprecision") : 6;
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)amount.multiply(oldVal).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP), (int)rowIdx);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gratio", (Object)Constants.ONE_HUNDRED.subtract(sumRatio), (int)(guaranteedCollection.size() - 1));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)amount.subtract(sumAmount), (int)(guaranteedCollection.size() - 1));
        }
    }

    private boolean checkGAmount(String propName, BigDecimal val, BigDecimal oldVal, int rowIdx) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (EmptyUtil.isEmpty((BigDecimal)amount)) {
            this.getView().showTipNotification("gm_guaranteecontract".equals(this.getModel().getDataEntityType().getName()) ? ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d\u201d\u3002", (String)"AbstractGuaranteeEdit_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u62c5\u4fdd\u7533\u8bf7\u91d1\u989d\u201d\u3002", (String)"AbstractGuaranteeEdit_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)amount) && amount.compareTo(val) < 0) {
            if ("a_gratio".equals(propName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d\u3002", (String)"AbstractGuaranteeEdit_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d\u3002", (String)"AbstractGuaranteeEdit_3", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)("a_gratio".equals(propName) ? "a_gamount" : "b_gamount"), (Object)oldVal, (int)rowIdx);
            return false;
        }
        if (EmptyUtil.isEmpty((BigDecimal)val)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)0, (int)rowIdx);
            return false;
        }
        BigDecimal ration = Constants.ONE_HUNDRED.multiply(val).divide(amount, 6, RoundingMode.HALF_UP);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)ration, (int)rowIdx);
        return true;
    }

    private void checkGuaranteedAmount(BigDecimal oldVal, int rowIdx) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        DynamicObjectCollection guaranteedCollection = this.getModel().getEntryEntity("entry_guaranteedorg");
        BigDecimal sumRatio = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (int i = 0; i < guaranteedCollection.size() - 1; ++i) {
            DynamicObject guaranteedEntry = (DynamicObject)guaranteedCollection.get(i);
            sumRatio = sumRatio.add(guaranteedEntry.getBigDecimal("b_gratio"));
            sumAmount = sumAmount.add(guaranteedEntry.getBigDecimal("b_gamount"));
        }
        DynamicObject guaranteeVarieties = (DynamicObject)this.getModel().getValue("guarantee");
        boolean isCredit = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)guaranteeVarieties)) {
            boolean bl = isCredit = EmptyUtil.isEmpty((DynamicObject)(guaranteeVarieties = QueryServiceHelper.queryOne((String)"gm_guaranteevarieties", (String)"creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)guaranteeVarieties.getLong("id"))}))) ? false : guaranteeVarieties.getBoolean("creditguarantee");
        }
        if (isCredit) {
            return;
        }
        if (sumAmount.compareTo(amount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u91d1\u989d\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d\u3002", (String)"AbstractGuaranteeEdit_14", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gratio", (Object)Constants.ONE_HUNDRED.multiply(oldVal).divide(amount, 6, RoundingMode.HALF_UP), (int)rowIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)oldVal, (int)rowIdx);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gratio", (Object)Constants.ONE_HUNDRED.subtract(sumRatio), (int)(guaranteedCollection.size() - 1));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)amount.subtract(sumAmount), (int)(guaranteedCollection.size() - 1));
        }
    }

    private void initIsCrossGuarantee() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
        items.add(new ComboItem(new LocaleString(GuaranteeTypeEnum.getName((String)GuaranteeTypeEnum.ORG.getValue())), GuaranteeTypeEnum.ORG.getValue()));
        items.add(new ComboItem(new LocaleString(GuaranteeTypeEnum.getName((String)GuaranteeTypeEnum.TMCORG.getValue())), GuaranteeTypeEnum.TMCORG.getValue()));
        if (!isCrossGuarantee) {
            items.add(new ComboItem(new LocaleString(GuaranteeTypeEnum.getName((String)GuaranteeTypeEnum.TMCBANK.getValue())), GuaranteeTypeEnum.TMCBANK.getValue()));
            items.add(new ComboItem(new LocaleString(GuaranteeTypeEnum.getName((String)GuaranteeTypeEnum.TMCNOTBANK.getValue())), GuaranteeTypeEnum.TMCNOTBANK.getValue()));
            items.add(new ComboItem(new LocaleString(GuaranteeTypeEnum.getName((String)GuaranteeTypeEnum.PARTNER.getValue())), GuaranteeTypeEnum.PARTNER.getValue()));
        }
        ComboEdit property = (ComboEdit)this.getControl("a_guaranteetype");
        property.setComboItems(items);
    }

    private void controlReGuaranteeWay() {
        boolean isNeedReg = (Boolean)this.getModel().getValue("isneedreg");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isNeedReg, (String[])new String[]{"countorguaway"});
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName = args.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)args.getFormShowParameter();
        int rowIndex = args.getRow();
        switch (propName) {
            case "m_pleg": {
                this.openPledgeBillList("mortgage", "", "entry_guaranteeorg", "entry_guaranteedorg", formShowParameter, args);
                break;
            }
            case "p_pleg": {
                this.openPledgeBillList("pledge", "", "entry_guaranteeorg", "entry_guaranteedorg", formShowParameter, args);
                break;
            }
            case "cm_pleg": {
                this.openPledgeBillList("mortgage", "countor", "entry_guaranteedorg", null, formShowParameter, args);
                break;
            }
            case "cp_pleg": {
                this.openPledgeBillList("pledge", "countor", "entry_guaranteedorg", null, formShowParameter, args);
                break;
            }
            case "a_guaranteequota": {
                this.filterGuaranteeQuota(args, rowIndex);
                break;
            }
            case "b_guaranteequota": {
                this.filterGuaranteedQuota(args, rowIndex);
                break;
            }
        }
    }

    private void filterGuaranteeQuota(BeforeF7SelectEvent event, int rowIndex) {
        DynamicObjectCollection guaranteeEntry = this.getModel().getEntryEntity("entry_guaranteeorg");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaranteeEntry)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGuaranteeEdit_4", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Object guaranteeType = this.getModel().getValue("a_guaranteetype", rowIndex);
        if (EmptyUtil.isEmpty((Object)guaranteeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGuaranteeEdit_6", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Object guaranteeOrgId = this.getModel().getValue("a_guaranteeorg", rowIndex);
        if (EmptyUtil.isEmpty((Object)guaranteeOrgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGuaranteeEdit_7", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Date beginDate = (Date)this.getModel().getValue("begindate");
        if (EmptyUtil.isEmpty((Object)beginDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGuaranteeEdit_8", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        ListFilterParameter listFilterParameter = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(GuaranteeQuotaHelper.getGuaranteeQuotaFilter((Object)guaranteeOrgId, (Date)beginDate));
        event.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "a_guaranteequota"));
    }

    private void filterGuaranteedQuota(BeforeF7SelectEvent event, int rowIndex) {
        DynamicObjectCollection guaranteedEntry = this.getModel().getEntryEntity("entry_guaranteedorg");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaranteedEntry)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGuaranteeEdit_9", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Object reGuaranteeType = this.getModel().getValue("b_reguaranteetype", rowIndex);
        if (EmptyUtil.isEmpty((Object)reGuaranteeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGuaranteeEdit_11", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Object guaranteedOrgId = this.getModel().getValue("b_guaranteedorg", rowIndex);
        if (!GuaranteeTypeEnum.OTHER.getValue().equals(reGuaranteeType) && EmptyUtil.isEmpty((Object)guaranteedOrgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGuaranteeEdit_12", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Date beginDate = (Date)this.getModel().getValue("begindate");
        if (EmptyUtil.isEmpty((Object)beginDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGuaranteeEdit_8", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        ListFilterParameter listFilterParameter = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(GuaranteeQuotaHelper.getGuaranteedQuotaFilter((String)((String)reGuaranteeType), (Object)guaranteedOrgId, (Date)beginDate));
        event.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "b_guaranteequota"));
    }

    private void handleCreditorType() {
        this.getModel().setValue("creditor", (Object)0L);
    }

    private void handleBreGuaranteeType(Object val, int rowIdx) {
        DynamicObject org;
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorg", (Object)0L, (int)rowIdx);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorgtext", (Object)"", (int)rowIdx);
        if (GuaranteeTypeEnum.ORG.getValue().equals(val) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorg", (Object)org.getPkValue(), (int)rowIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorgtext", (Object)org.getString("name"), (int)rowIdx);
        }
    }

    private void handleAGuaranteeOrgText(Object val, int rowIdx) {
        boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
        if (isCrossGuarantee) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorg", (Object)this.getModel().getValue("a_guaranteeorg"), (int)rowIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorgtext", (Object)val, (int)rowIdx);
        }
    }

    private void handleAGuaranteeType(Object val, int rowIdx) {
        DynamicObject org;
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"a_guaranteeorg", (Object)0L, (int)rowIdx);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"a_guaranteeorgtext", (Object)"", (int)rowIdx);
        boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
        if (isCrossGuarantee) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_reguaranteetype", (Object)val, (int)rowIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorg", (Object)0L, (int)rowIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorgtext", (Object)"", (int)rowIdx);
        }
        if (GuaranteeTypeEnum.ORG.getValue().equals(val) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"a_guaranteeorg", (Object)org.getPkValue(), (int)rowIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"a_guaranteeorgtext", (Object)org.getString("name"), (int)rowIdx);
            if (isCrossGuarantee) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorg", (Object)org.getPkValue(), (int)rowIdx);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_guaranteedorgtext", (Object)org.getString("name"), (int)rowIdx);
            }
        }
    }

    private boolean checkOrg(Object val, int rowIdx, String propName, boolean flag) {
        if (flag) {
            DynamicObjectCollection guaCollection = this.getModel().getEntryEntity("entry_guaranteeorg");
            for (int i = 0; i < guaCollection.size(); ++i) {
                if ("a_guaranteetype".equals(propName) && i == rowIdx || !val.equals(((DynamicObject)guaCollection.get(i)).get("a_guaranteetype"))) continue;
                return true;
            }
        } else {
            DynamicObjectCollection reGuaCollection = this.getModel().getEntryEntity("entry_guaranteedorg");
            for (int i = 0; i < reGuaCollection.size(); ++i) {
                if ("b_reguaranteetype".equals(propName) && i == rowIdx || !val.equals(((DynamicObject)reGuaCollection.get(i)).get("b_reguaranteetype"))) continue;
                return true;
            }
        }
        return false;
    }

    private void defCurrency() {
        DynamicObject orgDO = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)orgDO)) {
            return;
        }
        DynamicObject ccyDO = TmcBusinessBaseHelper.getBaseCurrency((long)orgDO.getLong("id"));
        this.getModel().setValue("currency", (Object)ccyDO);
    }

    private void handleReGuaranteeWay() {
        Object guaWay = this.getModel().getValue("guaranteeway");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabensure", "tabensureamt", "tabmortgage", "tabpledge", "advconap"});
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((Object)guaWay)), new String[]{"advcontoolbarap", "advconap"});
        String way = String.valueOf(guaWay);
        String tabKey = "";
        if (way.contains(GuaranteeWayEnum.ENSURE.getValue())) {
            tabKey = "tabensure";
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabensure"});
            this.setDefaultVal("ensureentity", "e_type", "e_ensure");
        }
        if (way.contains(GuaranteeWayEnum.ENSUAMT.getValue())) {
            if (EmptyUtil.isEmpty((String)tabKey)) {
                tabKey = "tabensureamt";
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabensureamt"});
            this.setDefaultVal("ensureamtentity", "a_type", "a_ensure");
        }
        if (way.contains(GuaranteeWayEnum.MORTGAGE.getValue())) {
            if (EmptyUtil.isEmpty((String)tabKey)) {
                tabKey = "tabmortgage";
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabmortgage"});
        }
        if (way.contains(GuaranteeWayEnum.PLEDGE.getValue())) {
            if (EmptyUtil.isEmpty((String)tabKey)) {
                tabKey = "tabpledge";
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabpledge"});
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(tabKey);
    }

    private void handleEntryMorPle() {
        int i;
        int morEntity = this.getModel().getEntryRowCount("morentity");
        int pleEntity = this.getModel().getEntryRowCount("pletgageentity");
        boolean dataChanged = this.getModel().getDataChanged();
        for (i = 0; i < morEntity; ++i) {
            Object mor = this.getModel().getValue("m_pleg", i);
            if (mor == null) continue;
            this.getModel().setValue("m_pledgevalue", (Object)((DynamicObject)mor).getBigDecimal("pledgevalue"), i);
            this.getModel().setValue("m_totalpledgevalue", (Object)((DynamicObject)mor).getBigDecimal("totalpledgevalue"), i);
        }
        for (i = 0; i < pleEntity; ++i) {
            Object ple = this.getModel().getValue("p_pleg", i);
            if (ple == null) continue;
            this.getModel().setValue("p_pledgevalue", (Object)((DynamicObject)ple).getBigDecimal("pledgevalue"), i);
            this.getModel().setValue("p_totalpledgevalue", (Object)((DynamicObject)ple).getBigDecimal("totalpledgevalue"), i);
        }
        this.getModel().setDataChanged(dataChanged);
    }

    protected void setDefaultVal(String entry, String field, String baseField) {
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        DynamicObjectCollection guaOrgEntry = this.getModel().getEntryEntity("entry_guaranteeorg");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaOrgEntry)) {
            return;
        }
        Object guaType = ((DynamicObject)guaOrgEntry.get(0)).get("a_guaranteetype");
        Object guaOrg = ((DynamicObject)guaOrgEntry.get(0)).get("a_guaranteeorg");
        Object guaOrgText = ((DynamicObject)guaOrgEntry.get(0)).get("a_guaranteeorgtext");
        Object enType = this.getModel().getValue(field);
        for (int i = 0; i < entryRowCount; ++i) {
            if (!EmptyUtil.isEmpty((Object)enType)) continue;
            this.getModel().setValue(field, GuaranteeTypeEnum.ORG.getValue().equals(guaType) ? GuaranteeTypeEnum.TMCORG.getValue() : guaType, i);
            this.getModel().setValue(baseField, guaOrg, i);
            this.getModel().setValue(baseField + "text", guaOrgText, i);
        }
    }

    private void handleEnsureRate(String entity, String rateField, String amtField) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entity);
        Object amt = this.getModel().getValue("amount");
        Object rate = this.getModel().getValue(rateField, rowIndex);
        if (EmptyUtil.isEmpty((Object)rate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)amtField, (Object)0, (int)rowIndex);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)amtField, (Object)this.getAmount(amt, rate), (int)rowIndex);
        }
    }

    private BigDecimal getAmount(Object amt, Object rate) {
        BigDecimal amtBig = amt instanceof BigDecimal ? (BigDecimal)amt : new BigDecimal(amt.toString());
        BigDecimal rateBig = rate instanceof BigDecimal ? (BigDecimal)rate : new BigDecimal(rate.toString());
        return amtBig.multiply(rateBig).divide(new BigDecimal("100.0"), 4);
    }

    private void handleAmount() {
        Object rate;
        int i;
        Object rate2;
        int i2;
        BigDecimal amt = (BigDecimal)this.getModel().getValue("amount");
        int enCount = this.getModel().getEntryRowCount("ensureentity");
        int enAmtCount = this.getModel().getEntryRowCount("ensureamtentity");
        for (i2 = 0; i2 < enCount; ++i2) {
            rate2 = this.getModel().getValue("e_ensurerate", i2);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_amount", (Object)this.getAmount(amt, rate2), (int)i2);
        }
        for (i2 = 0; i2 < enAmtCount; ++i2) {
            rate2 = this.getModel().getValue("a_ensurerate", i2);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"a_amount", (Object)this.getAmount(amt, rate2), (int)i2);
        }
        boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
        int guaOrgCount = this.getModel().getEntryRowCount("entry_guaranteeorg");
        int guaranteedCount = this.getModel().getEntryRowCount("entry_guaranteedorg");
        for (i = 0; i < guaOrgCount; ++i) {
            rate = this.getModel().getValue("a_gratio", i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"a_gamount", (Object)this.getAmount(amt, rate), (int)i);
            if (i >= guaranteedCount || !isCrossGuarantee) continue;
            rate = this.getModel().getValue("b_gratio", i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)this.getAmount(amt, rate), (int)i);
        }
        if (!this.getView().getFormShowParameter().getCustomParams().containsKey("openHistoryId") && !isCrossGuarantee) {
            for (i = 0; i < guaranteedCount; ++i) {
                rate = this.getModel().getValue("b_gratio", i);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"b_gamount", (Object)this.getAmount(amt, rate), (int)i);
            }
        }
    }

    private void handleRowAmount(String entity, String field, String fieldRate) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entity);
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (EmptyUtil.isEmpty((BigDecimal)amount)) {
            return;
        }
        BigDecimal eAmount = (BigDecimal)this.getModel().getValue(field, entryCurrentRowIndex);
        if (eAmount.compareTo(amount) > 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)field, (Object)amount, (int)entryCurrentRowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)fieldRate, (Object)100, (int)entryCurrentRowIndex);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)fieldRate, (Object)eAmount.divide(amount, RoundingMode.HALF_UP).multiply(new BigDecimal(100)), (int)entryCurrentRowIndex);
        }
    }

    public void pledgeBaseSelect(PropertyChangedArgs e, String key) {
        ChangeData changeSet = e.getChangeSet()[0];
        int rowIndex = changeSet.getRowIndex();
        if (StringUtils.equals((CharSequence)"mortgage", (CharSequence)key)) {
            Object morPle = this.getModel().getValue("m_pleg", rowIndex);
            this.setBaseDataId((DynamicObject)morPle, "m_pledgevalue", "m_totalpledgevalue", "m_amount", rowIndex);
        } else if (StringUtils.equals((CharSequence)"pledge", (CharSequence)key)) {
            Object morPle = this.getModel().getValue("p_pleg", rowIndex);
            this.setBaseDataId((DynamicObject)morPle, "p_pledgevalue", "p_totalpledgevalue", "p_amount", rowIndex);
        }
    }

    private void setBaseDataId(DynamicObject bill, String value, String totalVal, String amountVal, int rowIndex) {
        if (EmptyUtil.isEmpty((DynamicObject)bill)) {
            this.getModel().setValue(value, (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue(totalVal, (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue(amountVal, (Object)BigDecimal.ZERO, rowIndex);
            return;
        }
        this.getModel().setValue(value, (Object)bill.getBigDecimal("pledgevalue"), rowIndex);
        this.getModel().setValue(totalVal, (Object)bill.getBigDecimal("totalpledgevalue"), rowIndex);
        this.getModel().setValue(amountVal, (Object)bill.getBigDecimal("pledgevalue"), rowIndex);
    }

    private void handleChangeEType(String entry, String fieldId, String fieldText) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entry);
        this.getModel().setValue(fieldText, (Object)"", entryCurrentRowIndex);
        this.getModel().setValue(fieldId, (Object)0, entryCurrentRowIndex);
    }

    private void clearEntryCol(String entry, String field, String val, String totalVal) {
        int entryPlRowCount = this.getModel().getEntryRowCount(entry);
        for (int i = 0; i < entryPlRowCount; ++i) {
            this.getModel().setValue(field, null, i);
            this.getModel().setValue(val, (Object)0, i);
            this.getModel().setValue(totalVal, (Object)0, i);
        }
    }

    private void rowBtnClick(String opKey, String tabProp) {
        Tab tab = (Tab)this.getView().getControl(tabProp);
        String currentTab = tab.getCurrentTab();
        this.getView().invokeOperation(currentTab.replace("tab", "") + opKey);
    }

    private void handleByAddRow(String entityName) {
        if ("ensureamtentity".equals(entityName) || "ensureentity".equals(entityName)) {
            String field = "ensureentity".equals(entityName) ? "e_type" : "a_type";
            String baseField = "ensureentity".equals(entityName) ? "e_ensure" : "a_ensure";
            DynamicObjectCollection guaOrgEntry = this.getModel().getEntryEntity("entry_guaranteeorg");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)guaOrgEntry)) {
                Object guaType = ((DynamicObject)guaOrgEntry.get(0)).get("a_guaranteetype");
                Object guaOrg = ((DynamicObject)guaOrgEntry.get(0)).get("a_guaranteeorg");
                Object guaOrgText = ((DynamicObject)guaOrgEntry.get(0)).get("a_guaranteeorgtext");
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entityName);
                this.getModel().setValue(field, GuaranteeTypeEnum.ORG.getValue().equals(guaType) ? GuaranteeTypeEnum.TMCORG.getValue() : guaType, entryCurrentRowIndex);
                this.getModel().setValue(baseField, guaOrg, entryCurrentRowIndex);
                this.getModel().setValue(baseField + "text", guaOrgText, entryCurrentRowIndex);
            }
        }
    }

    protected void openPledgeBillList(String type, String prefix, String orgEntryName, String guaranteedEntryName, ListShowParameter formShowParameter, BeforeF7SelectEvent args) {
        QFilter dupicationEntryFilter2;
        DynamicObjectCollection guaOrgEntry = this.getModel().getEntryEntity(orgEntryName);
        List guaOrgIds = "entry_guaranteeorg".equals(orgEntryName) ? guaOrgEntry.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.get("a_guaranteeorg"))).map(a -> a.get("a_guaranteeorg")).collect(Collectors.toList()) : guaOrgEntry.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.get("b_guaranteedorg"))).map(a -> a.get("b_guaranteedorg")).collect(Collectors.toList());
        List guaranteedIds = null;
        if (EmptyUtil.isNoEmpty((String)guaranteedEntryName)) {
            DynamicObjectCollection guaranteedEntry = this.getModel().getEntryEntity(guaranteedEntryName);
            guaranteedIds = guaranteedEntry.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.get("b_guaranteedorg"))).map(b -> b.get("b_guaranteedorg")).collect(Collectors.toList());
        }
        Object currency = this.getModel().getValue("currency");
        if (guaOrgIds.isEmpty() || !TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"currency")) {
            args.setCancel(true);
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, prefix + type);
        QFilter filter = new QFilter("attribute", "=", (Object)type).and("currencyid", "=", ((DynamicObject)currency).getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("pledgestatus", "!=", (Object)PledgeStatusEnum.CACELPLEDGE.getValue());
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_pledgebill", (String)"47150e89000000ac");
        QFilter realRightPersonFilter = new QFilter("realrightpersonid", "in", guaOrgIds);
        if (guaranteedIds != null) {
            realRightPersonFilter = realRightPersonFilter.or("realrightpersonid", "in", guaranteedIds);
        }
        QFilter orgFilter = new QFilter("usablerange", "=", (Object)UseRangeEnum.ORG.getValue()).and(realRightPersonFilter).and("org", "in", (Object)comIdList);
        QFilter shareOrgEntryFilter = new QFilter("realrightpersonid", "in", guaOrgIds).or(new QFilter("shareorgentry.eorg", "in", guaOrgIds));
        if (guaranteedIds != null) {
            shareOrgEntryFilter = shareOrgEntryFilter.or(new QFilter("realrightpersonid", "in", guaranteedIds)).or(new QFilter("shareorgentry.eorg", "in", guaranteedIds));
        }
        QFilter specifyShareFilter = new QFilter("usablerange", "=", (Object)UseRangeEnum.SPECIFY_SHARE.getValue()).and(shareOrgEntryFilter).and(new QFilter("org", "in", (Object)comIdList).or(new QFilter("shareorgentry.eorg", "in", (Object)comIdList)));
        QFilter shareFilter = new QFilter("usablerange", "=", (Object)UseRangeEnum.SHARE.getValue());
        filter.and(orgFilter.or(specifyShareFilter).or(shareFilter));
        String filterFieldName = "billno";
        QFilter dupicationEntryFilter = null;
        if ("mortgage".equals(type)) {
            dupicationEntryFilter = this.filterDuplicationEntry("cmorentity", "cm_pleg", filterFieldName, "not in");
            dupicationEntryFilter2 = this.filterDuplicationEntry("morentity", "m_pleg", filterFieldName, "not in");
            if (dupicationEntryFilter == null) {
                dupicationEntryFilter = dupicationEntryFilter2;
            } else {
                dupicationEntryFilter.and(dupicationEntryFilter2);
            }
        }
        if ("pledge".equals(type)) {
            dupicationEntryFilter = this.filterDuplicationEntry("cpletgageentity", "cp_pleg", filterFieldName, "not in");
            dupicationEntryFilter2 = this.filterDuplicationEntry("pletgageentity", "p_pleg", filterFieldName, "not in");
            if (dupicationEntryFilter == null) {
                dupicationEntryFilter = dupicationEntryFilter2;
            } else {
                dupicationEntryFilter.and(dupicationEntryFilter2);
            }
        }
        if (dupicationEntryFilter != null) {
            filter.and(dupicationEntryFilter);
        }
        formShowParameter.getListFilterParameter().getQFilters().add(filter);
        formShowParameter.setCloseCallBack(closeCallBack);
    }

    protected QFilter filterDuplicationEntry(String entityName, String fieldName, String filterFieldName, String qcp) {
        DynamicObjectCollection morEntities = this.getModel().getEntryEntity(entityName);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)morEntities)) {
            return null;
        }
        ArrayList<String> billNos = new ArrayList<String>(morEntities.size());
        for (DynamicObject dynamicObject : morEntities) {
            DynamicObject mPet = dynamicObject.getDynamicObject(fieldName);
            if (mPet == null) continue;
            String billNo = mPet.getString(filterFieldName);
            billNos.add(billNo);
        }
        if (EmptyUtil.isNoEmpty(billNos)) {
            return new QFilter(filterFieldName, qcp, billNos);
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        switch (actionId) {
            case "mortgage": {
                this.setRowValAfterCloseBack(e, "morentity", "m_pleg", "m_pledgevalue", "m_totalpledgevalue");
                break;
            }
            case "pledge": {
                this.setRowValAfterCloseBack(e, "pletgageentity", "p_pleg", "p_pledgevalue", "p_totalpledgevalue");
                break;
            }
            case "countormortgage": {
                this.setRowValAfterCloseBack(e, "cmorentity", "cm_pleg", "m_pledgevalue", "cm_totalpledgevalue");
                break;
            }
            case "countorpledge": {
                this.setRowValAfterCloseBack(e, "cpletgageentity", "cp_pleg", "p_pledgevalue", "cp_totalpledgevalue");
                break;
            }
            case "a_guaranteequota": {
                this.setGuaQuotaAfterCloseBack(rows, "a_gamount", "a_guaranteequota");
                break;
            }
            case "b_guaranteequota": {
                this.setGuaQuotaAfterCloseBack(rows, "b_gamount", "b_guaranteequota");
                break;
            }
        }
    }

    private void setGuaQuotaAfterCloseBack(ListSelectedRowCollection rows, String amountProp, String quotaProp) {
        if (EmptyUtil.isNoEmpty((Object)rows) && rows.size() > 0) {
            ListSelectedRow listSelectedRow = rows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject quota = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"gm_guaranteequota", (String)"availablequota");
            BigDecimal amount = (BigDecimal)this.getModel().getValue(amountProp);
            if (amount.compareTo(quota.getBigDecimal("availablequota")) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractGuaranteeEdit_15", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue(quotaProp, primaryKeyValue);
            }
        }
    }

    protected void setRowValAfterCloseBack(ClosedCallBackEvent e, String entity, String baseField, String val, String totalVal) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (EmptyUtil.isNoEmpty((Object)rows)) {
            int morCount = this.getModel().getEntryRowCount(entity);
            int rowIndex = this.getModel().getEntryCurrentRowIndex(entity);
            int newRows = rows.size() - (morCount - rowIndex);
            if (newRows > 0) {
                this.getModel().batchCreateNewEntryRow(entity, newRows);
            }
            for (ListSelectedRow row : rows) {
                this.getModel().setValue(baseField, row.getPrimaryKeyValue(), rowIndex);
                ++rowIndex;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIdx = e.getRowIndex();
        Object value = e.getValue();
        switch (key) {
            case "a_guaranteetype": {
                if (!GuaranteeTypeEnum.ORG.getValue().equals(value) || !this.checkOrg(value, rowIdx, "a_guaranteetype", Boolean.TRUE)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u4fe1\u606f\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u672c\u7ec4\u7ec7\u3002", (String)"AbstractGuaranteeEdit_5", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("a_guaranteetype", rowIdx);
                boolean isCrossGuarantee = (Boolean)this.getModel().getValue("iscrossguarantee");
                if (!isCrossGuarantee) break;
                this.getView().updateView("b_reguaranteetype", rowIdx);
                break;
            }
            case "b_reguaranteetype": {
                if (!GuaranteeTypeEnum.ORG.getValue().equals(value) || !this.checkOrg(value, rowIdx, "b_reguaranteetype", Boolean.FALSE)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u4fe1\u606f\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u672c\u7ec4\u7ec7\u3002", (String)"AbstractGuaranteeEdit_10", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("b_reguaranteetype", rowIdx);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIdx = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        DynamicObject mpDo = null;
        if ("m_pleg".equals(fieldName)) {
            mpDo = (DynamicObject)this.getModel().getValue("m_pleg", rowIdx);
        } else if ("p_pleg".equals(fieldName)) {
            mpDo = (DynamicObject)this.getModel().getValue("p_pleg", rowIdx);
        } else if ("cm_pleg".equals(fieldName)) {
            mpDo = (DynamicObject)this.getModel().getValue("cm_pleg", rowIdx);
        } else if ("cp_pleg".equals(fieldName)) {
            mpDo = (DynamicObject)this.getModel().getValue("cp_pleg", rowIdx);
        }
        if (mpDo != null) {
            BillShowParameter param = new BillShowParameter();
            param.setFormId("gm_pledgebill");
            param.setPkId(mpDo.getPkValue());
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setBillStatus(BillOperationStatus.VIEW);
            param.getCustomParams().put("fromchange", "true");
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

