/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.common;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AbstractLetterBaseEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit gv = (BasedataEdit)this.getControl("guaranteevariety");
        gv.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit applyorg = (BasedataEdit)this.getControl("applyorg");
        applyorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit localreissuebank = (BasedataEdit)this.getControl("localreissuebank");
        localreissuebank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent f7Evt) {
        String propName;
        switch (propName = f7Evt.getProperty().getName()) {
            case "guaranteevariety": {
                this.guaranteeVarietyF7Evt(f7Evt);
                break;
            }
            case "applyorg": {
                this.applyOrgF7Evt(f7Evt);
                break;
            }
            case "org": {
                this.orgF7Evt();
                break;
            }
            case "localreissuebank": {
                this.localReissueBankF7Evt(f7Evt);
                break;
            }
        }
    }

    private void localReissueBankF7Evt(BeforeF7SelectEvent f7Evt) {
        DynamicObject finorginfo;
        boolean isreissue = (Boolean)this.getModel().getValue("isreissue");
        if (isreissue && EmptyUtil.isNoEmpty((DynamicObject)(finorginfo = (DynamicObject)this.getModel().getValue("finorginfo")))) {
            ListShowParameter formShowParameter = (ListShowParameter)f7Evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", finorginfo.getPkValue()));
        }
    }

    private void orgF7Evt() {
        boolean isreissue = (Boolean)this.getModel().getValue("isreissue");
        if (isreissue) {
            this.getModel().setValue("applyorg", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.applyDefCurrency();
    }

    public void applyOrgF7Evt(BeforeF7SelectEvent f7Evt) {
        boolean isreissue = (Boolean)this.getModel().getValue("isreissue");
        ListShowParameter showParameter = (ListShowParameter)f7Evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.removeIf(e -> "id".equals(e.getProperty()));
        if (!isreissue) {
            String appId = this.getView().getFormShowParameter().getAppId();
            List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            qFilters.add(new QFilter("id", "in", (Object)comIdList));
        }
    }

    private void guaranteeVarietyF7Evt(BeforeF7SelectEvent f7Evt) {
        IDataEntityProperty prop = this.getModel().getProperty("guaranteevariety");
        LocaleString curDisplayName = prop.getDisplayName();
        ListShowParameter sp = (ListShowParameter)f7Evt.getFormShowParameter();
        sp.setCaption(curDisplayName.toString());
        sp.setF7Style(2);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "startdate": {
                this.startDateChgEvt();
                break;
            }
            case "expiredate": {
                this.expireDateChgEvt();
                break;
            }
            case "guaranteeterm": {
                this.guaranteeTermChgEvt();
                break;
            }
            case "org": {
                this.applyDefCurrency();
                break;
            }
            case "isreissue": {
                this.reissueChgEvt((Boolean)newVal);
                break;
            }
            case "finorginfo": {
                this.getModel().setValue("localreissuebank", null);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "startdate": {
                this.verifyStartdate(key, value, e);
                break;
            }
            case "expiredate": {
                this.verifyEnddate(key, value, e);
                break;
            }
        }
    }

    private void verifyStartdate(String key, Object value, BeforeFieldPostBackEvent e) {
        if (value == null) {
            return;
        }
        Date endDate = (Date)this.getModel().getValue("expiredate");
        if (endDate == null) {
            return;
        }
        String fmtStr = ((DateEdit)this.getControl("expiredate")).getFormatString();
        Date startDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        if (startDate.after(endDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u51fd\u8d77\u59cb\u65e5\u4e0d\u80fd\u665a\u4e8e\u5f00\u51fd\u5230\u671f\u65e5\u3002", (String)"LetterOfGuaranteeEdit_01", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        }
    }

    private void verifyEnddate(String key, Object value, BeforeFieldPostBackEvent e) {
        if (value == null) {
            return;
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (startDate == null) {
            return;
        }
        String fmtStr = ((DateEdit)this.getControl("expiredate")).getFormatString();
        Date endDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        if (startDate.after(endDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u51fd\u5230\u671f\u65e5\u4e0d\u80fd\u65e9\u4e8e\u5f00\u51fd\u8d77\u59cb\u65e5\u3002", (String)"LetterOfGuaranteeEdit_02", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        }
    }

    private void startDateChgEvt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (startDate == null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteeterm", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", null);
        } else {
            String term = (String)this.getModel().getValue("guaranteeterm");
            if (term != null) {
                Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)endDate);
            }
        }
    }

    private void guaranteeTermChgEvt() {
        String term = (String)this.getModel().getValue("guaranteeterm");
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (term != null && startDate != null) {
            Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)endDate);
        }
    }

    private void expireDateChgEvt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("expiredate");
        if (startDate != null && endDate != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteeterm", (Object)DateUtils.getDiff_ymd((Date)startDate, (Date)endDate));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteeterm", null);
        }
    }

    private void applyDefCurrency() {
        DynamicObject orgDO = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)orgDO)) {
            return;
        }
        DynamicObject ccyDO = TmcBusinessBaseHelper.getBaseCurrency((long)orgDO.getLong("id"));
        this.getModel().setValue("currency", (Object)ccyDO);
    }

    private void reissueChgEvt(Boolean newVal) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)newVal, (String[])new String[]{"issuebankfeerate", "reissuebankfeerate"});
    }
}

