/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.formplugin.common.AbstractBaseF7Plugin;
import org.apache.commons.lang3.tuple.Pair;

public class GuarnateeContractF7Edit
extends AbstractBaseF7Plugin {
    public static final String ID = "id";
    public static final String ORG = "org";
    public static final String FINORGTYPE_TYPE = "finorgtype.type";

    @Override
    protected Map<String, Pair<String, String>> getFieldMap() {
        HashMap<String, Pair<String, String>> fieldMap = new HashMap<String, Pair<String, String>>();
        fieldMap.put("a_guaranteeorgtext", Pair.of((Object)"a_guaranteetype", (Object)"a_guaranteeorg"));
        fieldMap.put("b_guaranteedorgtext", Pair.of((Object)"b_reguaranteetype", (Object)"b_guaranteedorg"));
        fieldMap.put("q_guaranteedorgtext", Pair.of((Object)"q_reguaranteetype", (Object)"q_guaranteedorg"));
        fieldMap.put("creditortext", Pair.of((Object)"creditortype", (Object)"creditor"));
        fieldMap.put("e_ensuretext", Pair.of((Object)"e_type", (Object)"e_ensure"));
        fieldMap.put("a_ensuretext", Pair.of((Object)"a_type", (Object)"a_ensure"));
        fieldMap.put("ce_ensuretext", Pair.of((Object)"ce_type", (Object)"ce_ensure"));
        return fieldMap;
    }

    @Override
    protected void addCustomFilter(String textField, ListShowParameter lsp) {
        super.addCustomFilter(textField, lsp);
        List lspQFilter = lsp.getListFilterParameter().getQFilters();
        QFilter filter = this.getRemoveDuplicationFilter(textField);
        if (filter != null) {
            lspQFilter.add(filter);
        }
    }

    private QFilter getRemoveDuplicationFilter(String textField) {
        QFilter qFilter = null;
        if ("e_ensuretext".equals(textField)) {
            qFilter = this.createRemoveDuplicationFilter("ensureentity", "e_ensure", ID, "not in");
        }
        if ("a_ensuretext".equals(textField)) {
            qFilter = this.createRemoveDuplicationFilter("ensureamtentity", "a_ensure", ID, "not in");
        }
        if ("ce_ensuretext".equals(textField)) {
            qFilter = this.createRemoveDuplicationFilter("censureentity", "ce_ensure", ID, "not in");
        }
        return qFilter;
    }

    @Override
    protected String getF7FormId(String type) {
        for (GuaranteeTypeEnum value : GuaranteeTypeEnum.values()) {
            if (!value.getValue().equals(type)) continue;
            return value.getFormid();
        }
        return null;
    }

    private QFilter createRemoveDuplicationFilter(String entityName, String filedName, String filterFieldName, String qcp) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        DynamicObjectCollection ensureEntities = this.getModel().getEntryEntity(entityName);
        for (DynamicObject dynamicObject : ensureEntities) {
            long id = dynamicObject.getLong(filedName);
            if (id == 0L) continue;
            ids.add(id);
        }
        if (EmptyUtil.isNoEmpty(ids)) {
            return new QFilter(filterFieldName, qcp, ids);
        }
        return null;
    }

    @Override
    protected QFilter getCustomFilter(String textField, String type) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (GuaranteeTypeEnum.TMCORG.getValue().equals(type)) {
            if ("creditortext".equals(textField)) {
                DynamicObjectCollection guaOrgEntry = this.getModel().getEntryEntity("entry_guaranteeorg");
                List guaOrgIds = guaOrgEntry.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.get("a_guaranteeorg"))).map(a -> a.get("a_guaranteeorg")).collect(Collectors.toList());
                return new QFilter(ID, "not in", guaOrgIds);
            }
            List<String> needExcludeOwnFields = Arrays.asList("a_guaranteeorgtext", "b_guaranteedorgtext");
            if (needExcludeOwnFields.contains(textField) && EmptyUtil.isNoEmpty((DynamicObject)org)) {
                return new QFilter(ID, "!=", org.getPkValue());
            }
        }
        List<String> needFilterFields = Arrays.asList("a_guaranteeorgtext", "creditortext", "e_ensuretext", "a_ensuretext");
        if (GuaranteeTypeEnum.TMCBANK.getValue().equals(type) && needFilterFields.contains(textField)) {
            return new QFilter(FINORGTYPE_TYPE, "=", (Object)FinOrgTypeEnum.BANK.getValue());
        }
        if (GuaranteeTypeEnum.TMCNOTBANK.getValue().equals(type) && needFilterFields.contains(textField)) {
            return new QFilter(FINORGTYPE_TYPE, "!=", (Object)FinOrgTypeEnum.BANK.getValue());
        }
        return null;
    }
}

