/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.contract;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;

public class GuaranteeContractUseEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private static final String[] gcProps = new String[]{"gcomment", "gcparty", "gsrcbillid", "gsrcbillno", "gsrcbilltype", "gdebtorg", "gdebtorgtext", "gdebtcurrency", "gdebtamount", "gdebtbalance", "gratio", "gexchrate", "gdebtstartdate", "gdebtenddate", "gcontract", "gsrcbillbizamount", "gcreditortype", "gcreditor", "gcreditortext"};

    public void registerListener(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getControl("guaranteedebt_entry");
        grid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid creditLimit = (EntryGrid)this.getControl("creditlimit_entity");
        creditLimit.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadGuaranteeContractUse();
    }

    private void loadGuaranteeContractUse() {
        Long billId = (Long)this.getModel().getValue("id");
        if (EmptyUtil.isEmpty((Long)billId)) {
            return;
        }
        QFilter gQF = new QFilter("gcontract.id", "=", (Object)billId);
        gQF.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection gcUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", gcProps), (QFilter[])gQF.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gcUseBills)) {
            return;
        }
        Map letterCreditMap = GuaranteeContractHelper.getLetterCreditMap((DynamicObjectCollection)gcUseBills);
        Map loanBillMap = GuaranteeContractHelper.getLoanBillMap((DynamicObjectCollection)gcUseBills);
        DynamicObject[] gcUseBillArr = GuaranteeUseHelper.removeExpireData((DynamicObject[])((DynamicObject[])gcUseBills.toArray((Object[])new DynamicObject[gcUseBills.size()])));
        BigDecimal sumOfBal = BigDecimal.ZERO;
        DynamicObject gContractCcy = (DynamicObject)this.getModel().getValue("currency");
        Long gContractCcyId = (Long)gContractCcy.getPkValue();
        ArrayList entryDataList = new ArrayList(gcUseBills.size());
        ArrayList<Long> creditLimitIds = new ArrayList<Long>();
        for (DynamicObject gcBIll : gcUseBillArr) {
            if ("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)gcBIll.getString("gsrcbilltype")))) {
                creditLimitIds.add(gcBIll.getLong("gsrcbillid"));
                continue;
            }
            BigDecimal debtBalance = gcBIll.getBigDecimal("gdebtbalance");
            if ("lc_lettercredit".equals(gcBIll.get("gsrcbilltype")) && EmptyUtil.isNoEmpty((BigDecimal)((BigDecimal)letterCreditMap.get(gcBIll.getLong("gsrcbillid"))))) {
                debtBalance = ((BigDecimal)letterCreditMap.get(gcBIll.getLong("gsrcbillid"))).multiply(gcBIll.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED, 4, RoundingMode.HALF_UP);
            } else if (Arrays.asList("cfm_loanbill_b_l", "cfm_loanbill_e_l", "cfm_loanbill", "cim_invest_loanbill").contains(gcBIll.get("gsrcbilltype")) && EmptyUtil.isNoEmpty((BigDecimal)((BigDecimal)loanBillMap.get(gcBIll.getLong("gsrcbillid"))))) {
                debtBalance = ((BigDecimal)loanBillMap.get(gcBIll.getLong("gsrcbillid"))).multiply(gcBIll.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED, 4, RoundingMode.HALF_UP);
            }
            Long debtBillOrg = gcBIll.getLong("gdebtorg");
            String debtBillOrgText = gcBIll.getString("gdebtorgtext");
            Long debtBillCcy = gcBIll.getLong("gdebtcurrency");
            if (EmptyUtil.isNoEmpty((Long)debtBillCcy) && !gContractCcyId.equals(debtBillCcy) && debtBalance.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal gExchangeRate = gcBIll.getBigDecimal("gexchrate");
                debtBalance = debtBalance.multiply(gExchangeRate);
            }
            HashMap<String, Object> entry = new HashMap<String, Object>(16);
            entry.put("gsrcbilltype", gcBIll.get("gsrcbilltype"));
            entry.put("gsrcbillno", gcBIll.get("gsrcbillno"));
            entry.put("gsrcbillid", gcBIll.get("gsrcbillid"));
            entry.put("gcparty", EmptyUtil.isNoEmpty((String)gcBIll.getString("gcreditortext")) ? gcBIll.get("gcreditortext") : gcBIll.get("gcparty"));
            entry.put("gdebtorg", debtBillOrg);
            entry.put("gdebtorgtext", debtBillOrgText);
            entry.put("gdebtcurrency", debtBillCcy);
            entry.put("gdebtamount", gcBIll.get("gsrcbillbizamount"));
            entry.put("gdebtbalance", debtBalance);
            entry.put("gdebtstartdate", gcBIll.get("gdebtstartdate"));
            entry.put("gdebtenddate", gcBIll.get("gdebtenddate"));
            String billTypeEntity = this.containsEntity(gcBIll.getString("gsrcbilltype"));
            if (billTypeEntity != null) {
                QFilter gSrcBillIdFilter = new QFilter("id", "=", gcBIll.get("gsrcbillid"));
                DynamicObject gSrcDo = TmcDataServiceHelper.loadSingle((String)billTypeEntity, (String)("cfm_loanbill".equals(billTypeEntity) ? "renewalexpiredate,drawtype" : "renewalexpiredate"), (QFilter[])gSrcBillIdFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)gSrcDo) && EmptyUtil.isNoEmpty((Object)gSrcDo.get("renewalexpiredate"))) {
                    entry.put("gdebtenddate", gSrcDo.get("renewalexpiredate"));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)gSrcDo) && "cfm_loanbill".equals(billTypeEntity) && "closeout".equals(gSrcDo.getString("drawtype"))) {
                    debtBalance = BigDecimal.ZERO;
                    entry.put("gdebtbalance", debtBalance);
                }
            }
            entry.put("gcomment", gcBIll.get("gcomment"));
            entry.put("gstatus", gcBIll.getBigDecimal("gratio").compareTo(BigDecimal.ZERO) == 0 ? "C" : (BigDecimal.ZERO.compareTo(debtBalance) != 0 ? "A" : "B"));
            entryDataList.add(entry);
            sumOfBal = sumOfBal.add(debtBalance);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = model.getDataChanged();
        model.beginInit();
        TmcViewInputHelper.batchFillEntity((String)"guaranteedebt_entry", (AbstractFormDataModel)model, entryDataList);
        model.endInit();
        this.getView().updateView("guaranteedebt_entry");
        model.setValue("dutyamount", (Object)sumOfBal);
        this.setCreditLimitEntry(creditLimitIds);
        this.getModel().setDataChanged(dataChanged);
    }

    private String containsEntity(String gSrcBillType) {
        if ("cfm_loancontractbill".equals(gSrcBillType)) {
            return gSrcBillType;
        }
        if (gSrcBillType != null && gSrcBillType.indexOf("_loanbill") > 0) {
            return "cfm_loanbill";
        }
        return null;
    }

    private void setCreditLimitEntry(List<Long> creditLimitIds) {
        if (creditLimitIds.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("creditlimit_entity", creditLimitIds.size());
        for (int i = 0; i < creditLimitIds.size(); ++i) {
            this.getModel().setValue("creditlimitno", (Object)creditLimitIds.get(i), i);
            DynamicObject creditNo = (DynamicObject)this.getModel().getValue("creditlimitno", i);
            if (creditNo == null) continue;
            this.getModel().setValue("creditlimitcurrency", creditNo.getDynamicObject("currency").getPkValue(), i);
            this.getModel().setValue("creditlimittotalamt", (Object)creditNo.getBigDecimal("totalamt"), i);
            this.getModel().setValue("creditlimitavaamt", (Object)creditNo.getBigDecimal("avaramt"), i);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIdx = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        if ("creditlimitno".equals(fieldName)) {
            DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimitno", rowIdx);
            if (creditLimit != null) {
                if (!QueryServiceHelper.exists((String)"cfm_creditlimit", (QFilter[])new QFilter("id", "=", creditLimit.getPkValue()).toArray())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"GuaranteeContractUseEdit_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    return;
                }
                BaseShowParameter param = new BaseShowParameter();
                param.setFormId("cfm_creditlimit");
                param.setPkId(creditLimit.getPkValue());
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setBillStatus(BillOperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)param);
            }
        } else {
            Long srcBillId = (Long)this.getModel().getValue("gsrcbillid", rowIdx);
            String srcBillEntity = (String)this.getModel().getValue("gsrcbilltype", rowIdx);
            ProductTypeEnum TypeEnum = ProductTypeEnum.getEnumByFormId((String)srcBillEntity);
            String string = srcBillEntity = TypeEnum == null ? srcBillEntity : TypeEnum.getEntity();
            if (!QueryServiceHelper.exists((String)srcBillEntity, (QFilter[])new QFilter("id", "=", (Object)srcBillId).toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"GuaranteeContractUseEdit_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter fp = new BillShowParameter();
            fp.setFormId(srcBillEntity);
            fp.setPkId((Object)srcBillId);
            fp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fp.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)fp);
        }
    }
}

