/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.debt;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.DebtChangeTypeEnum;

public class DebtRegisterEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit gmBillNo = (BasedataEdit)this.getView().getControl("gmbillno");
        gmBillNo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "gmbillno": {
                this.gmContractF7Evt(evt);
            }
        }
    }

    private void gmContractF7Evt(BeforeF7SelectEvent evt) {
        Object org = this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u767b\u8bb0\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"DebtRegisterEdit_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", ((DynamicObject)org).getPkValue()));
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_debt_register", (String)"47150e89000000ac");
        qFilters.add(new QFilter("org.id", "in", (Object)orgIdList));
        evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gmbillno"));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(event);
        String key = event.getActionId();
        if ("gmbillno".equals(key) && EmptyUtil.isNoEmpty((Object)(selectedRows = (ListSelectedRowCollection)event.getReturnData())) && selectedRows.size() > 0) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject contract = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"gm_guaranteecontract", (String)"billno,entry_guaranteedorg,entry_guaranteedorg.b_guaranteedorg,entry_guaranteedorg.b_guaranteedorgtext,creditortext,currency");
            this.getModel().setValue("gmbillno", primaryKeyValue);
            this.getModel().setValue("guaranteedorgtext", null);
            this.getModel().setValue("creditortext", (Object)contract.getString("creditortext"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String changeType = (String)this.getModel().getValue("changetype");
        if (DebtChangeTypeEnum.DEBT_RELEASE.getValue().equals(changeType)) {
            BigDecimal leftReleaseAmount = this.calLeftReleaseAmount(this.getModel().getValue("rootid"));
            this.getModel().setValue("leftreleaseamount", (Object)leftReleaseAmount);
        } else {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("gmbillno");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (EmptyUtil.isEmpty((DynamicObject)contract) || EmptyUtil.isEmpty((DynamicObject)currency)) {
                return;
            }
            if (Long.valueOf(currency.getLong("id")).equals(contract.getDynamicObject("currency").getLong("id"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"convertrate"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"convertrate"});
            }
        }
    }

    private BigDecimal calLeftReleaseAmount(Object id) {
        DynamicObject occupyDebtBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"gm_debt_register", (String)"occupyamount");
        if (EmptyUtil.isEmpty((DynamicObject)occupyDebtBill)) {
            return null;
        }
        BigDecimal occupyAmount = occupyDebtBill.getBigDecimal("occupyamount");
        QFilter debtFilter = new QFilter("changetype", "=", (Object)DebtChangeTypeEnum.DEBT_RELEASE.getValue()).and(new QFilter("rootid", "=", (Object)id.toString()));
        DynamicObjectCollection releaseDebtBills = QueryServiceHelper.query((String)"gm_debt_register", (String)"releaseamount", (QFilter[])new QFilter[]{debtFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)releaseDebtBills)) {
            return occupyAmount;
        }
        BigDecimal releaseAmountTotal = BigDecimal.ZERO;
        for (DynamicObject debtBill : releaseDebtBills) {
            releaseAmountTotal = releaseAmountTotal.add(debtBill.getBigDecimal("releaseamount"));
        }
        return occupyAmount.subtract(releaseAmountTotal);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "gmbillno": {
                this.getModel().setValue("guaranteedorgtext", null);
                DynamicObject gmContract = (DynamicObject)this.getModel().getValue("gmbillno");
                if (EmptyUtil.isNoEmpty((DynamicObject)gmContract)) {
                    this.getModel().setValue("creditortext", (Object)gmContract.getString("creditortext"));
                }
            }
            case "currency": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("gmbillno");
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                if (!EmptyUtil.isNoEmpty((DynamicObject)contract) || !EmptyUtil.isNoEmpty((DynamicObject)currency)) break;
                if (Long.valueOf(currency.getLong("id")).equals(contract.getDynamicObject("currency").getLong("id"))) {
                    this.getModel().setValue("convertrate", (Object)BigDecimal.ONE);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"convertrate"});
                    break;
                }
                Long currencyId = currency.getLong("id");
                Long baseCurrencyId = contract.getDynamicObject("currency").getLong("id");
                Long currentOrgId = TmcOrgDataHelper.getCurrentOrg().getLong("id");
                BigDecimal exchangeRate = TmcBusinessBaseHelper.getExchangeRate((long)currencyId, (long)baseCurrencyId, (long)currentOrgId, (Date)DateUtils.getCurrentDate());
                this.getModel().setValue("convertrate", (Object)exchangeRate);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"convertrate"});
                break;
            }
            case "amount": 
            case "guaranteerate": {
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
                BigDecimal guaranteeRate = (BigDecimal)this.getModel().getValue("guaranteerate");
                if (!EmptyUtil.isNoEmpty((BigDecimal)amount) || !EmptyUtil.isNoEmpty((BigDecimal)guaranteeRate)) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"occupyamount", (Object)amount.multiply(guaranteeRate.divide(new BigDecimal("100"))));
                break;
            }
            case "reguaranteetype": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteedorg", (Object)0L);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteedorgtext", (Object)"");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                if (DebtChangeTypeEnum.DEBT_RELEASE.getValue().equals(this.getModel().getValue("changetype")) && EmptyUtil.isEmpty((Object)this.getModel().getValue("releaseamount"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91ca\u653e\u62c5\u4fdd\u91d1\u989d\u201d\u3002", (String)"DebtRegisterEdit_3", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (this.isDataChanged(operateKey) && !this.updateValidate()) break;
                args.setCancel(true);
            }
        }
    }

    private boolean updateValidate() {
        BigDecimal releaseAmount = (BigDecimal)this.getModel().getValue("releaseamount");
        DynamicObject debtBill = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"gm_debt_register", (String)"releaseamount");
        BigDecimal originReleaseAmount = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((DynamicObject)debtBill)) {
            originReleaseAmount = debtBill.getBigDecimal("releaseamount");
        }
        BigDecimal leftReleaseAmount = (BigDecimal)this.getModel().getValue("leftreleaseamount");
        if (EmptyUtil.isNoEmpty((BigDecimal)releaseAmount) && releaseAmount.compareTo(originReleaseAmount) != 0 && releaseAmount.subtract(originReleaseAmount).compareTo(leftReleaseAmount) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u91ca\u653e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5269\u4f59\u53ef\u91ca\u653e\u91d1\u989d\u3002", (String)"DebtRegisterEdit_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isDataChanged(String operateKey) {
        if ("save".equals(operateKey) && !this.getModel().getDataChanged()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"DebtRegisterEdit_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "save": 
            case "submit": {
                if (!Objects.equals(this.getModel().getValue("changetype"), DebtChangeTypeEnum.DEBT_RELEASE.getValue())) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"leftreleaseamount", (Object)this.calLeftReleaseAmount(this.getModel().getValue("rootid")));
                this.getModel().setDataChanged(false);
            }
        }
    }
}

