/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.debt;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.gm.common.enums.DebtChangeTypeEnum;

public class DebtRegisterListPlugin
extends AbstractListPlugin {
    private static final String REFRESH_LIST = "refresh_list";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblnew"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "newdata": {
                if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) break;
                this.popDebtRegisterNewWin();
                break;
            }
            case "release": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                HashSet idSet = new HashSet(selectedRows.size());
                selectedRows.forEach(o -> idSet.add((Long)o.getPrimaryKeyValue()));
                if (idSet.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u4e00\u7b14\u62c5\u4fdd\u503a\u52a1\u767b\u8bb0\u8fdb\u884c\u62c5\u4fdd\u91ca\u653e\u3002", (String)"DebtRegisterListPlugin_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject debtRegisterDynamicObject = BusinessDataServiceHelper.loadSingle(idSet.iterator().next(), (String)"gm_debt_register", (String)String.join((CharSequence)",", "billstatus", "changetype", "gmbillno"));
                String errorMessage = this.checkDebtRegisterDynamicObject(debtRegisterDynamicObject);
                if (errorMessage.length() > 0) {
                    this.getView().showTipNotification(errorMessage);
                    return;
                }
                this.popDebtRegisterEditWin((Long)debtRegisterDynamicObject.getPkValue());
            }
        }
    }

    private String checkDebtRegisterDynamicObject(DynamicObject debtRegisterDynamicObject) {
        StringBuilder errorMessage = new StringBuilder();
        if (!Objects.equals(debtRegisterDynamicObject.getString("changetype"), DebtChangeTypeEnum.DEBT_OCCUPY.getValue())) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u767b\u8bb0\u7c7b\u578b\u4e3a\u503a\u52a1\u5360\u7528\u7684\u8bb0\u5f55\u3002", (String)"DebtRegisterListPlugin_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return errorMessage.toString();
        }
        if (!Objects.equals(debtRegisterDynamicObject.getString("billstatus"), BillStatusEnum.AUDIT.getValue())) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u7684\u8bb0\u5f55\u3002", (String)"DebtRegisterListPlugin_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
        }
        return errorMessage.toString();
    }

    private void popDebtRegisterEditWin(Long debtRegisterId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("gm_debt_register_dynamic");
        parameter.setCustomParam("operateType", (Object)"RELEASE");
        parameter.setCustomParam("debtRegisterId", (Object)debtRegisterId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFRESH_LIST));
        this.getView().showForm(parameter);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilterColumn.setDefaultValue(null);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            List customFilter = (List)filterValues.get("customfilter");
            for (Map filterItem : customFilter) {
                String fieldName = ((List)filterItem.get("FieldName")).get(0).toString();
                List item = (List)filterItem.get("Value");
                if (!fieldName.startsWith("org") || item.isEmpty() || "".equals(item.get(0))) continue;
                this.getPageCache().put("selectedFilterOrgs", item.get(0).toString());
            }
        }
    }

    private void popDebtRegisterNewWin() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gm_debt_register_dynamic");
        showParameter.setCustomParam("operateType", (Object)"NEW");
        showParameter.setCustomParam("selectedFilterOrgs", (Object)this.getPageCache().get("selectedFilterOrgs"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFRESH_LIST));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.equals(actionId, REFRESH_LIST)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

