/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.guaranteeapply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.BizRangeTypeEnum;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.EntityMapFactory;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;
import kd.tmc.gm.common.enums.GuaContractApplTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class GuaranteeApplyChangeEdit
extends AbstractBillPlugIn {
    private final List<String> FILLBACKFILEDS = Arrays.asList("org", "guarantee", "creditortype", "creditor", "creditortext", "amount", "currency", "guaranteeamount", "begindate", "enddate", "guaranteeway", "guaranteelimit", "isneedreg", "countorguaway", "isexceedstock", "description", "iscrossguarantee");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"guacontracttext"});
    }

    public void beforeBindData(EventObject e) {
        this.loadGuaContractText();
        this.tipUpdatedFields();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.applyTypeChgEvt();
        this.controlGuaContract();
    }

    private void controlGuaContract() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT == status && this.isChangeGuaContract()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"applytype", "guacontracttext"});
        }
    }

    private void loadGuaContractText() {
        DynamicObject guaContract = (DynamicObject)this.getModel().getValue("guacontract");
        if (guaContract != null) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"guacontracttext", (Object)guaContract.get("billno"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object guaContractId = formShowParameter.getCustomParam("guaContractId");
        Object change = formShowParameter.getCustomParam("change");
        if (change != null && ((Boolean)change).booleanValue() && !EmptyUtil.isEmpty((Object)guaContractId)) {
            this.applyTypeChgEvt();
            this.getModel().setValue("applytype", (Object)GuaContractApplTypeEnum.CHANGE.getValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{"guacontracttext"});
            TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])new String[]{"applytype", "guacontracttext"});
            this.fillBackData(guaContractId);
            this.controlGuaranteedEntry(guaContractId);
        }
    }

    private void controlGuaranteedEntry(Object guaContractId) {
        DynamicObjectCollection guaranteedOrgEntry = this.getModel().getEntryEntity("entry_guaranteedorg");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaranteedOrgEntry)) {
            return;
        }
        Set guaranteedIdSet = guaranteedOrgEntry.stream().map(v -> v.getLong("b_guaranteedorg")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("gcontract", "=", guaContractId);
        qFilter.and(new QFilter("gdebtorg", "in", guaranteedIdSet));
        DynamicObjectCollection debtOrgCol = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)"gdebtorg", (QFilter[])new QFilter[]{qFilter});
        Set debtOrgIdSet = debtOrgCol.stream().map(v -> v.getLong("gdebtorg")).collect(Collectors.toSet());
        for (int rowIdx = 0; rowIdx < guaranteedOrgEntry.size(); ++rowIdx) {
            if (!debtOrgIdSet.contains(((DynamicObject)guaranteedOrgEntry.get(rowIdx)).getLong("b_guaranteedorg"))) continue;
            this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{"b_reguaranteetype", "b_guaranteedorgtext", "b_guaranteequota"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "applytype": {
                this.applyTypeChgEvt();
                break;
            }
            case "amount": {
                this.amountChgEvt();
                break;
            }
            case "guaranteeway": {
                this.guaranteeWayChgEvt();
                break;
            }
        }
    }

    private void guaranteeWayChgEvt() {
        String applyType = (String)this.getModel().getValue("applytype");
        if (GuaContractApplTypeEnum.isChangeApply((String)applyType)) {
            String guaranteeWay = (String)this.getModel().getValue("guaranteeway");
            DynamicObject guaContract = (DynamicObject)this.getModel().getValue("guacontract");
            if (guaContract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62c5\u4fdd\u5408\u540c", (String)"GuaranteeApplyChangeEdit_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            } else {
                String oldGuaranteeWay = guaContract.getString("guaranteeway");
                String[] oldGuaranteeWays = oldGuaranteeWay.split(",");
                boolean tip = false;
                for (String split : oldGuaranteeWays) {
                    if (!EmptyUtil.isEmpty((String)guaranteeWay) && guaranteeWay.contains(split)) continue;
                    tip = true;
                    break;
                }
                if (tip) {
                    TmcViewInputHelper.showErrTip((IFormView)this.getView(), (String)"guaranteeway", (String)ResManager.loadKDString((String)"\u539f\u59cb\u7684\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u80fd\u53bb\u6389", (String)"GuaranteeApplyChangeEdit_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                } else {
                    TmcViewInputHelper.hideErrTip((IFormView)this.getView(), (String)"guaranteeway");
                }
            }
        }
    }

    private void amountChgEvt() {
        String applyType = (String)this.getModel().getValue("applytype");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal dutyAmount = (BigDecimal)this.getModel().getValue("dutyamount");
        if (GuaContractApplTypeEnum.isChangeApply((String)applyType)) {
            DynamicObject guaContract = (DynamicObject)this.getModel().getValue("guacontract");
            if (guaContract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62c5\u4fdd\u5408\u540c", (String)"GuaranteeApplyChangeEdit_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            } else {
                BigDecimal dutyAmt = GuaranteeContractHelper.getContractDutyAmtExcludeCreditLimit((Long)((Long)guaContract.getPkValue()));
                if (dutyAmount.compareTo(dutyAmt) != 0) {
                    this.getModel().setValue("dutyamount", (Object)dutyAmt);
                }
                if (amount.compareTo(dutyAmt) < 0) {
                    TmcViewInputHelper.showErrTip((IFormView)this.getView(), (String)"amount", (String)ResManager.loadKDString((String)"\u4e0d\u80fd\u5c0f\u4e8e\u62c5\u4fdd\u8d23\u4efb\u91d1\u989d", (String)"GuaranteeApplyChangeEdit_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                } else {
                    TmcViewInputHelper.hideErrTip((IFormView)this.getView(), (String)"amount");
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("guacontracttext".equals(key)) {
            this.guaContractF7Evt();
        }
    }

    private void guaContractF7Evt() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"gm_guaranteecontract", (boolean)false, (int)0, (boolean)true);
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("bizstatus", "=", (Object)GuaConBizStatusEnum.DOING.getValue()));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_guaranteecontract", (String)"47150e89000000ac");
        qFilters.add(new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", (Object)comIdList).or("entry_guaranteedorg.b_guaranteedorg", "in", (Object)comIdList).or("creator", "in", (Object)comIdList));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gm_guaranteecontract"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void applyTypeChgEvt() {
        String applyType = (String)this.getModel().getValue("applytype");
        if (GuaContractApplTypeEnum.isChangeApply((String)applyType)) {
            FieldEdit desc = (FieldEdit)this.getControl("description");
            desc.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9650\u5236\u6027\u6761\u6b3e\u8bf4\u660e", (String)"GuaranteeApplyChangeEdit_3", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
            FieldEdit amount = (FieldEdit)this.getControl("amount");
            amount.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d", (String)"GuaranteeApplyChangeEdit_4", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
            FieldEdit beginDate = (FieldEdit)this.getControl("begindate");
            beginDate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f", (String)"GuaranteeApplyChangeEdit_5", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
            FieldEdit endDate = (FieldEdit)this.getControl("enddate");
            endDate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62c5\u4fdd\u7ed3\u675f\u65e5\u671f", (String)"GuaranteeApplyChangeEdit_6", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"guacontract", "guacontracttext"});
        } else if (GuaContractApplTypeEnum.isAddApply((String)applyType)) {
            FieldEdit desc = (FieldEdit)this.getControl("description");
            desc.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"GuaranteeApplyChangeEdit_7", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
            FieldEdit amount = (FieldEdit)this.getControl("amount");
            amount.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62c5\u4fdd\u7533\u8bf7\u91d1\u989d", (String)"GuaranteeApplyChangeEdit_8", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
            FieldEdit beginDate = (FieldEdit)this.getControl("begindate");
            beginDate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f", (String)"GuaranteeApplyChangeEdit_9", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
            FieldEdit endDate = (FieldEdit)this.getControl("enddate");
            endDate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u62c5\u4fdd\u7ed3\u675f\u65e5\u671f", (String)"GuaranteeApplyChangeEdit_10", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
            DynamicObject guaContract = (DynamicObject)this.getModel().getValue("guacontract");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            if (!EmptyUtil.isEmpty((DynamicObject)guaContract)) {
                this.getModel().setValue("guacontract", null);
                this.getModel().setValue("guacontracttext", null);
                this.clearFields(this.FILLBACKFILEDS);
                model.deleteEntryData("entry_guaranteeorg");
                model.deleteEntryData("entry_guaranteedorg");
            }
            model.deleteEntryData("ensureentity");
            model.deleteEntryData("ensureamtentity");
            model.deleteEntryData("morentity");
            model.deleteEntryData("pletgageentity");
            model.endInit();
            model.setDataChanged(false);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"guacontract", "guacontracttext", "description"});
        }
    }

    private void clearFields(List<String> clearFields) {
        for (String clearFiled : clearFields) {
            FieldEdit control = (FieldEdit)this.getControl(clearFiled);
            Class propertyType = control.getProperty().getPropertyType();
            if (propertyType == Boolean.TYPE) {
                this.getModel().setValue(clearFiled, (Object)false);
                continue;
            }
            this.getModel().setValue(clearFiled, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("gm_guaranteecontract".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
            ListSelectedRow listSelectedRow = data.get(0);
            this.fillBackData(listSelectedRow.getPrimaryKeyValue());
            this.controlGuaranteedEntry(listSelectedRow.getPrimaryKeyValue());
        }
    }

    private void fillBackData(Object primaryKeyValue) {
        DynamicObject guaranteeContract = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"gm_guaranteecontract");
        this.getModel().setValue("guacontracttext", guaranteeContract.get("billno"));
        this.getModel().setValue("guacontract", guaranteeContract.getPkValue());
        this.fillBackHeadData(guaranteeContract, this.FILLBACKFILEDS);
        this.fillBackEntryData(guaranteeContract, new String[]{"entry_guaranteeorg", "entry_guaranteedorg", "ensureentity", "ensureamtentity", "morentity", "pletgageentity", "censureentity", "cmorentity", "cpletgageentity"});
        EntityMapFactory.getDealService((String)BizRangeTypeEnum.CHANGE.getValue()).execute(new DynamicObject[]{guaranteeContract}, this.getModel(), BizRangeTypeEnum.CHANGE.getValue());
    }

    private void fillBackEntryData(DynamicObject guaranteeContract, String[] entryNames) {
        List extFields = EntityMapFactory.getDealService((String)BizRangeTypeEnum.CHANGE.getValue()).getExtSelectorProp("gm_guaranteeapply", "gm_guaranteecontract", BizRangeTypeEnum.CHANGE.getValue(), false);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (String entryName : entryNames) {
            model.deleteEntryData(entryName);
            DynamicObjectCollection entry = guaranteeContract.getDynamicObjectCollection(entryName);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) continue;
            TableValueSetter vs = new TableValueSetter(new String[0]);
            DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
            ArrayList<String> list = new ArrayList<String>(16);
            DataEntityPropertyCollection modelProperties = model.getEntryEntity(entryName).getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                boolean flag;
                String name = property.getName();
                boolean bl = flag = modelProperties.stream().filter(p -> name.equals(p.getName())).count() > 0L;
                if ("id".equals(name) || !flag || !this.noContains(extFields, name)) continue;
                vs.addField(name, new Object[0]);
                list.add(name);
            }
            for (DynamicObject dynamicObject : entry) {
                ArrayList<Object> addRow = new ArrayList<Object>(16);
                for (String key : list) {
                    if ("id".equals(key)) continue;
                    addRow.add(dynamicObject.get(key));
                }
                vs.addRow(addRow.toArray());
            }
            model.batchCreateNewEntryRow(entryName, vs);
        }
        model.endInit();
        for (String entryName : entryNames) {
            this.getView().updateView(entryName);
        }
        model.setDataChanged(false);
    }

    private boolean noContains(List<String> extFields, String name) {
        for (String extField : extFields) {
            String[] extFieldArray;
            if (StringUtils.isEmpty((CharSequence)extField) || name.indexOf(extField = (extFieldArray = extField.split("\\."))[extFieldArray.length - 1]) == -1) continue;
            return false;
        }
        return true;
    }

    private void fillBackHeadData(DynamicObject guaranteeContract, List<String> fillBackFields) {
        for (String fillBackField : fillBackFields) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)fillBackField, (Object)guaranteeContract.get(fillBackField));
        }
        BigDecimal contractDutyAmt = GuaranteeContractHelper.getContractDutyAmtExcludeCreditLimit((Long)((Long)guaranteeContract.getPkValue()));
        this.getModel().setValue("dutyamount", (Object)contractDutyAmt);
    }

    private boolean isChangeGuaContract() {
        return GuaContractApplTypeEnum.isChangeApply((String)((String)this.getModel().getValue("applytype")));
    }

    private void tipUpdatedFields() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus) && this.isChangeGuaContract()) {
            StringBuilder sb = new StringBuilder();
            DynamicObject guaContractF7 = (DynamicObject)this.getModel().getValue("guacontract");
            DynamicObject guaContract = TmcDataServiceHelper.loadSingle((Object)guaContractF7.getPkValue(), (String)"gm_guaranteecontract");
            DataEntityPropertyCollection propertys = this.getModel().getDataEntityType().getProperties();
            boolean isChangedEntrys = false;
            boolean isChanged = false;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Map newDataEntity = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)dataEntity, (boolean)true);
            Map oldDataEntity = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)guaContract, (boolean)true);
            Map diffs = DynamicObjectCompareHelper.entriesDiffering((Map)oldDataEntity, (Map)newDataEntity);
            for (IDataEntityProperty property : propertys) {
                String name = property.getName();
                LocaleString displayName = property.getDisplayName();
                if (GuaranteeContractHelper.CONTRACT_ENTRY_NAMES.contains(name)) {
                    if (!LetterOfGuaranteeHelper.isChangePropForEntryGrid((DynamicObject)guaContract, (DynamicObject)dataEntity, (List)GuaranteeContractHelper.CONTRACT_ENTRY_NAMES, Arrays.asList("a_guaranteeorg", "b_guaranteedorg", "e_ensure", "a_ensure", "m_pleg", "p_pleg"))) continue;
                    isChangedEntrys = true;
                    continue;
                }
                if (!diffs.containsKey(name) || !this.FILLBACKFILEDS.contains(name)) continue;
                List objects = (List)diffs.get(name);
                Object oldVal = objects.get(0);
                Object newVal = objects.get(1);
                Control control = this.getControl(name);
                isChanged = true;
                if ("beneficiary".equals(name)) continue;
                if (oldVal instanceof DynamicObject || newVal instanceof DynamicObject || control instanceof ComboEdit || oldVal.getClass() == Boolean.class) {
                    sb.append(displayName).append(ResManager.loadKDString((String)"\u6709\u4fee\u6539", (String)"LetterOfGuaApplyChangeEdit_9", (String)"tmc-gm-formplugin", (Object[])new Object[0])).append('\n');
                    continue;
                }
                if (control instanceof DecimalEdit) {
                    BigDecimal oldV = (BigDecimal)oldVal;
                    oldVal = oldV.setScale(4, RoundingMode.HALF_UP);
                    BigDecimal newV = newVal == null ? BigDecimal.ZERO : (BigDecimal)newVal;
                    newVal = newV.setScale(4, RoundingMode.HALF_UP);
                }
                sb.append(displayName).append(' ').append(ResManager.loadKDString((String)"\u4ece", (String)"LetterOfGuaApplyChangeEdit_4", (String)"tmc-gm-formplugin", (Object[])new Object[0])).append(' ').append(oldVal).append(' ').append(ResManager.loadKDString((String)"\u4fee\u6539\u4e3a", (String)"LetterOfGuaApplyChangeEdit_5", (String)"tmc-gm-formplugin", (Object[])new Object[0])).append(' ').append(newVal).append('\n');
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (isChanged) {
                stringBuilder.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5b57\u6bb5\u6709\u4fee\u6539\uff1a", (String)"LetterOfGuaApplyChangeEdit_6", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                stringBuilder.append('\n');
                stringBuilder.append((CharSequence)sb);
            }
            if (isChangedEntrys) {
                stringBuilder.append(ResManager.loadKDString((String)"\u62c5\u4fdd\u4fe1\u606f\u6709\u4fee\u6539", (String)"LetterOfGuaApplyChangeEdit_7", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            }
            if (isChanged || isChangedEntrys) {
                this.getView().showTipNotification(stringBuilder.toString());
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (e.isCancel()) {
            return;
        }
        if ("entry_guaranteedorg".equals(e.getEntryProp().getName()) && GuaContractApplTypeEnum.isChangeApply((String)((String)this.getModel().getValue("applytype")))) {
            DynamicObject guaContractDo = (DynamicObject)this.getModel().getValue("guacontract");
            DynamicObjectCollection guaranteedOrgEntry = this.getModel().getEntryEntity("entry_guaranteedorg");
            Set guaranteedIdSet = guaranteedOrgEntry.stream().map(v -> v.getLong("b_guaranteedorg")).collect(Collectors.toSet());
            if (EmptyUtil.isEmpty((DynamicObject)guaContractDo) || guaranteedIdSet.isEmpty()) {
                return;
            }
            QFilter qFilter = new QFilter("gcontract", "=", guaContractDo.getPkValue());
            qFilter.and(new QFilter("gdebtorg", "in", guaranteedIdSet));
            DynamicObjectCollection debtOrgCol = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)"gdebtorg", (QFilter[])new QFilter[]{qFilter});
            Set debtOrgIdSet = debtOrgCol.stream().map(v -> v.getLong("gdebtorg")).collect(Collectors.toSet());
            for (int rowIndex : e.getRowIndexs()) {
                if (!debtOrgIdSet.contains((Long)this.getModel().getValue("b_guaranteedorg", rowIndex))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba%s\u5df2\u53d1\u751f\u503a\u52a1\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"LetterOfGuaApplyChangeEdit_8", (String)"tmc-gm-formplugin", (Object[])new Object[]{this.getModel().getValue("b_guaranteedorgtext", rowIndex)}));
                e.setCancel(true);
                break;
            }
        }
    }
}

