/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.letterofguarantee;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;
import kd.tmc.gm.formplugin.common.AbstractLetterBaseEdit;

public class LetterOfGuaranteeEdit
extends AbstractLetterBaseEdit {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"applybillno"});
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        String bizStatus = (String)this.getModel().getValue("bizstatus");
        if (BizStatusEnum.CLAIMED.getValue().equals(bizStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cancel"});
        }
        this.reissueChgEvt((Boolean)this.getModel().getValue("isreissue"), false);
        this.getPageCache().put("CREDITCHOOSE", "1");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("applybillno".equals(key)) {
            this.getView().invokeOperation("drawapplybill");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "isreissue": {
                this.reissueChgEvt((Boolean)newVal, true);
                break;
            }
            case "hasunfrozenfund": {
                this.hasUnfrozenFundChgEvt((Boolean)newVal);
                break;
            }
            case "applyorg": {
                this.getModel().setValue("creditlimit", null);
                break;
            }
            case "applybillno": {
                String applyBillNo = (String)this.getModel().getValue("applybillno");
                if (!EmptyUtil.isEmpty((String)applyBillNo)) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void reissueChgEvt(Boolean newVal, Boolean isPropChange) {
        if (newVal.booleanValue()) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("applyreissueorg"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applyreissueorg", (Object)this.getModel().getValue("org"));
            }
            if (isPropChange.booleanValue()) {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"applyorg"});
            }
            String applyBillNo = (String)this.getModel().getValue("applybillno");
            this.getView().setEnable(Boolean.valueOf(EmptyUtil.isEmpty((String)applyBillNo)), new String[]{"applyreissueorg"});
        } else {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("applyorg"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applyorg", (Object)this.getModel().getValue("org"));
            }
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"localreissuebank", "issuebankfeerate", "reissuebankfeerate", "applyreissueorg"});
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)newVal, (String[])new String[]{"issuebankfeerate", "reissuebankfeerate"});
    }

    private void hasUnfrozenFundChgEvt(Boolean newVal) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)newVal, (String[])new String[]{"unfrozenfundbank"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        Long id = (Long)this.getModel().getValue("id");
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!LetterOfGuaranteeHelper.checkPermisionForIsreissue(Collections.singletonList(id), (String)appId) && !LetterOfGuaranteeHelper.NOTNEED_PERMISSIONOP.contains(op.getOperateKey())) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5305\u542b\u94f6\u884c\u8f6c\u5f00\u65e0\u64cd\u4f5c\u6743\u9650\u7684\u6570\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LetterOfGuaranteeList_11", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey = e.getOperateKey();
        OperationResult opr = e.getOperationResult();
        if (opr != null && opr.isSuccess()) {
            switch (opKey) {
                case "setcanceldate": {
                    this.openDateForm(ResManager.loadResFormat((String)"\u5f00\u51fd\u767b\u8bb0-\u6ce8\u9500", (String)"LetterOfGuaranteeList_10", (String)"tmc-gm-formplugin", (Object[])new Object[0]), ResManager.loadResFormat((String)"\u6ce8\u9500\u65e5\u671f", (String)"LetterOfGuaranteeList_9", (String)"tmc-gm-formplugin", (Object[])new Object[0]), "setcanceldate");
                    break;
                }
            }
        }
    }

    private void openDateForm(String title, String dateName, String callBackName) {
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackName);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setHasRight(true);
        showParameter.setFormId("gm_date_f7");
        showParameter.setCaption(title);
        showParameter.setCloseCallBack(callBack);
        showParameter.setCustomParam("dateName", (Object)dateName);
        showParameter.setCustomParam("startdate", this.getModel().getValue("startdate"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        switch (event.getActionId()) {
            case "setcanceldate": {
                DynamicObject returnData = (DynamicObject)event.getReturnData();
                if (!EmptyUtil.isNoEmpty((DynamicObject)returnData)) break;
                Date date = (Date)returnData.get("date");
                OperateOption op = OperateOption.create();
                op.setVariableValue("date", DateUtils.formatString((Date)date, (String)"yyyy-MM-dd"));
                this.getView().invokeOperation("cancel", op);
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Date endDate = (Date)this.getModel().getValue("expiredate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"guaranteeterm", (Object)DateUtils.getDiff_ymd((Date)startDate, (Date)endDate));
        }
        this.setBenefitId();
    }

    private void setBenefitId() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        for (DynamicObject row : entry) {
            String type = Optional.ofNullable(row.getString("e_beneficiarytype")).orElse("");
            if ("other".equals(type)) continue;
            List idList = QueryServiceHelper.queryPrimaryKeys((String)type, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)row.getString("e_textbeneficiary"))}, (String)"", (int)-1);
            if (EmptyUtil.isEmpty((Collection)idList)) continue;
            row.set("e_beneficiary", idList.get(0));
        }
    }
}

