/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.pledgebill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.PledgeSourceEnum;
import kd.tmc.gm.common.enums.PledgeTypeEnum;
import kd.tmc.gm.common.enums.RealRightEnum;
import kd.tmc.gm.common.enums.UseRangeEnum;
import kd.tmc.gm.common.helper.GuaranteeHelper;

public class PledgeBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit pledgeTypeEdit = (BasedataEdit)this.getControl("pledgetypeid");
        pledgeTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit eOrgEdit = (BasedataEdit)this.getControl("eorg");
        eOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long baseCurrencyID = GuaranteeHelper.getCurrencyByOrg((long)RequestContext.get().getOrgId());
        this.getModel().setValue("currencyid", (Object)baseCurrencyID);
        this.changeRightPerson();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkIsFromChange();
        String realRightValue = (String)this.getModel().getValue("realright");
        if (RealRightEnum.USER_ORG.getValue().equals(realRightValue)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"realrightpersonid"});
        }
        this.showPledgeNo();
        this.initPledgeValue((BigDecimal)this.getModel().getValue("totalpledgevalue"));
    }

    private void initPledgeValue(BigDecimal totalPledgeValue) {
        BigDecimal currentAppraisedValue = (BigDecimal)this.getModel().getValue("currentappraisedvalue");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pledgevalue", (Object)currentAppraisedValue.subtract(totalPledgeValue));
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("pledgevalue", this.getModel().getValue("currentappraisedvalue"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (Arrays.asList("submit", "unsubmit", "audit", "unaudit").contains(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (key) {
            case "pledgetypeid": {
                BasedataEdit basedataEdit;
                String attributeValue = (String)this.getModel().getValue("attribute");
                if (PledgeTypeEnum.COUNTER_GUARANTEE.getValue().equals(attributeValue) || null == (basedataEdit = (BasedataEdit)this.getControl("pledgetypeid"))) break;
                QFilter qFilter = new QFilter("attribute", "=", (Object)attributeValue);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "eorg": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"PledgeBillEdit_04", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                QFilter qFilter = new QFilter("id", "!=", org.getPkValue());
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "realright": {
                this.changeRightPerson();
                break;
            }
            case "attribute": {
                this.getModel().setValue("pledgetypeid", null);
                break;
            }
            case "pledgetypeid": {
                this.showPledgeNo();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pledgeno", (Object)0L);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pledgename", null);
                break;
            }
            case "begindate": {
                Date beginDate = (Date)this.getModel().getValue("begindate");
                Date endDate = (Date)this.getModel().getValue("enddate");
                if (!EmptyUtil.isNoEmpty((Object)beginDate) || !EmptyUtil.isNoEmpty((Object)endDate) || !beginDate.after(endDate)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"PledgeBillEdit_01", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("begindate", null);
                return;
            }
            case "enddate": {
                Date beginDate = (Date)this.getModel().getValue("begindate");
                Date endDate = (Date)this.getModel().getValue("enddate");
                if (!EmptyUtil.isNoEmpty((Object)beginDate) || !EmptyUtil.isNoEmpty((Object)endDate) || !endDate.before(beginDate)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PledgeBillEdit_02", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("enddate", null);
                return;
            }
            case "usablerange": {
                String useRange = (String)this.getModel().getValue("usablerange");
                if (UseRangeEnum.SPECIFY_SHARE.getValue().equals(useRange)) break;
                this.getModel().deleteEntryData("shareorgentry");
                break;
            }
            case "initialappraisedvalue": {
                if (this.checkIsUnderZero("initialappraisedvalue", BigDecimal.ZERO)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u521d\u8bc4\u4f30\u4ef7\u503c\u8981\u5927\u4e8e0\u3002", (String)"PledgeBillEdit_7", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    break;
                }
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (!BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus")) || customParams.containsKey("openHistoryId")) break;
                this.getModel().setValue("currentappraisedvalue", this.getModel().getValue("initialappraisedvalue"));
                break;
            }
            case "currentappraisedvalue": {
                if (this.checkIsUnderZero("currentappraisedvalue", BigDecimal.ZERO)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u4f30\u4ef7\u503c\u8981\u5927\u4e8e0\u3002", (String)"PledgeBillEdit_8", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    break;
                }
                BigDecimal totalPledgeValue = (BigDecimal)this.getModel().getValue("totalpledgevalue");
                if (this.checkIsUnderZero("currentappraisedvalue", totalPledgeValue)) break;
                this.initPledgeValue(totalPledgeValue);
                break;
            }
            case "originalvalue": {
                if (!this.checkIsUnderZero("originalvalue", BigDecimal.ZERO)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u503c\u8981\u5927\u4e8e0\u3002", (String)"PledgeBillEdit_9", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean checkIsUnderZero(String propName, BigDecimal compPropValue) {
        QFilter qFilter = new QFilter("id", "=", this.getModel().getValue("id"));
        DynamicObject pledgeBill = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)propName, (QFilter[])qFilter.toArray());
        BigDecimal propValue = (BigDecimal)this.getModel().getValue(propName);
        if (propValue.compareTo(compPropValue) < 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)pledgeBill.getBigDecimal(propName));
            return true;
        }
        return false;
    }

    private void showPledgeNo() {
        DynamicObject pledgeType = (DynamicObject)this.getModel().getValue("pledgetypeid");
        if (EmptyUtil.isNoEmpty((DynamicObject)pledgeType)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"originalvalue", "initialappraisedvalue"});
            Object source = pledgeType.get("source");
            if (PledgeSourceEnum.DEPOSIT_MANAGEMENT.getValue().equals(source) || PledgeSourceEnum.INVESTMENT_FINANCE.getValue().equals(source)) {
                TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])new String[]{"originalvalue", "initialappraisedvalue"});
            }
        }
    }

    private void changeRightPerson() {
        String realRightValue = (String)this.getModel().getValue("realright");
        if (RealRightEnum.USER_ORG.getValue().equals(realRightValue)) {
            DynamicObject orgIdObject = (DynamicObject)this.getModel().getValue("org");
            this.getView().setEnable(Boolean.FALSE, new String[]{"realrightpersonid", "realrightpersontext"});
            if (EmptyUtil.isNoEmpty((DynamicObject)orgIdObject)) {
                Long orgId = orgIdObject.getLong("id");
                boolean hasAdminBiz = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
                if (hasAdminBiz) {
                    DynamicObject org = TmcOrgDataHelper.getOrgById((long)orgId);
                    this.getModel().setValue("realrightpersonid", (Object)orgId);
                    this.getModel().setValue("realrightpersontext", (Object)org.getString("name"));
                } else {
                    Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId);
                    if (EmptyUtil.isNoEmpty((Object)companyByOrg)) {
                        DynamicObject org = TmcOrgDataHelper.getOrgById((long)orgId);
                        this.getModel().setValue("realrightpersontext", (Object)org.getString("name"));
                        this.getModel().setValue("realrightpersonid", companyByOrg.get("id"));
                    }
                }
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"realrightpersonid", "realrightpersontext"});
        }
    }

    private void checkIsFromChange() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("fromchange")) {
            if (customParams.containsKey("openHistoryId")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bizdate", "attribute", "realright", "realrightpersontext", "currencyid", "pledgetypeid", "pledgeno", "pledgename", "totalpledgevalue", "pledgevalue", "begindate", "remark"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"billstatus", "pledgestatus"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"pledgerate"});
            }
            if (BillStatusEnum.AUDIT.getValue().equals(this.getModel().getValue("billstatus"))) {
                DynamicObject historyDyn = BillChangeHistoryHelper.getLastChangeHistory((Long)((Long)this.getModel().getValue("id")), (String)this.getModel().getDataEntityType().getName());
                if (EmptyUtil.isEmpty((DynamicObject)historyDyn)) {
                    return;
                }
                historyDyn = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)historyDyn);
                BigDecimal originalValue = historyDyn.getBigDecimal("originalvalue");
                BigDecimal initialAppraisedValue = historyDyn.getBigDecimal("initialappraisedvalue");
                BigDecimal appraisedValue = historyDyn.getBigDecimal("currentappraisedvalue");
                int pledgeRate = historyDyn.getInt("pledgerate");
                String usableRange = historyDyn.getString("usablerange");
                Date endDate = historyDyn.getDate("enddate");
                BigDecimal originalValueNew = (BigDecimal)this.getModel().getValue("originalvalue");
                BigDecimal initialAppraisedValueNew = (BigDecimal)this.getModel().getValue("initialappraisedvalue");
                BigDecimal appraisedValueNew = (BigDecimal)this.getModel().getValue("currentappraisedvalue");
                int pledgeRateNew = (Integer)this.getModel().getValue("pledgerate");
                String usableRangeNew = (String)this.getModel().getValue("usablerange");
                Date endDateNew = (Date)this.getModel().getValue("enddate");
                String prefix = ResManager.loadKDString((String)"\u4ee5\u4e0b\u5b57\u6bb5\u6709\u4fee\u6539\uff1a\n", (String)"PledgeBillEdit_10", (String)"tmc-gm-formplugin", (Object[])new Object[0]);
                String tips = "";
                if (originalValue.compareTo(originalValueNew) != 0) {
                    tips = tips + String.format(ResManager.loadKDString((String)"\u539f\u503c \u4ece%1$s\u4fee\u6539\u4e3a%2$s\n", (String)"PledgeBillEdit_11", (String)"tmc-gm-formplugin", (Object[])new Object[0]), originalValue.setScale(2, 4), originalValueNew.setScale(2, 4));
                }
                if (initialAppraisedValue.compareTo(initialAppraisedValueNew) != 0) {
                    tips = tips + String.format(ResManager.loadKDString((String)"\u6700\u521d\u8bc4\u4f30\u4ef7\u503c \u4ece%1$s\u4fee\u6539\u4e3a%2$s\n", (String)"PledgeBillEdit_12", (String)"tmc-gm-formplugin", (Object[])new Object[0]), initialAppraisedValue.setScale(2, 4), initialAppraisedValueNew.setScale(2, 4));
                }
                if (appraisedValue.compareTo(appraisedValueNew) != 0) {
                    tips = tips + String.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u4ef7\u503c \u4ece%1$s\u4fee\u6539\u4e3a%2$s\n", (String)"PledgeBillEdit_13", (String)"tmc-gm-formplugin", (Object[])new Object[0]), appraisedValue.setScale(2, 4), appraisedValueNew.setScale(2, 4));
                }
                if (pledgeRate != pledgeRateNew) {
                    tips = tips + String.format(ResManager.loadKDString((String)"\u201c\u62b5\u8d28\u62bc\u7387\u201d\u4ece\u201c%1$s\u201d\u4fee\u6539\u4e3a\u201c%2$s\u201d\n", (String)"PledgeBillEdit_14", (String)"tmc-gm-formplugin", (Object[])new Object[0]), pledgeRate, pledgeRateNew);
                }
                if (!usableRange.equals(usableRangeNew)) {
                    tips = tips + String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u8303\u56f4 \u4ece%1$s\u4fee\u6539\u4e3a%2$s\n", (String)"PledgeBillEdit_15", (String)"tmc-gm-formplugin", (Object[])new Object[0]), UseRangeEnum.getName((String)usableRange), UseRangeEnum.getName((String)usableRangeNew));
                }
                if (endDate.compareTo(endDateNew) != 0) {
                    tips = tips + String.format(ResManager.loadKDString((String)"\u62b5\uff08\u8d28\uff09\u62bc\u7ed3\u675f\u65e5 \u4ece%1$s\u4fee\u6539\u4e3a%2$s\n", (String)"PledgeBillEdit_16", (String)"tmc-gm-formplugin", (Object[])new Object[0]), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)endDateNew, (String)"yyyy-MM-dd"));
                }
                if (EmptyUtil.isNoEmpty((String)tips)) {
                    this.getView().showTipNotification(prefix + tips);
                }
            }
        }
    }
}

