/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.pledgebill;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.gm.common.bean.BillIdAndBillNo;
import kd.tmc.gm.common.helper.PledgeBillHelper;

public class PledgeBillList
extends AbstractTmcBillBaseList {
    private Long getSelectDataById() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e!", (String)"PledgeBillList_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\uff01", (String)"PledgeBillList_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return (Long)selectedRows.get(0).getPrimaryKeyValue();
    }

    private Set<BillIdAndBillNo> getSelectDataByIds() {
        HashSet<BillIdAndBillNo> billNoAndIds = new HashSet<BillIdAndBillNo>();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e!", (String)"PledgeBillList_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return billNoAndIds;
        }
        for (ListSelectedRow selectedRow : selectedRows) {
            Long id = (Long)selectedRow.getPrimaryKeyValue();
            String billNo = selectedRow.getBillNo();
            billNoAndIds.add(new BillIdAndBillNo(id, billNo));
        }
        return billNoAndIds;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "cancel": {
                Set<BillIdAndBillNo> billNoAndIdBeans = this.getSelectDataByIds();
                String checkStr = PledgeBillHelper.checkGcByPledgeBill(billNoAndIdBeans);
                if (!EmptyUtil.isNoEmpty((String)checkStr)) break;
                this.getView().showConfirm(checkStr, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirm_back_tblcancel", (IFormPlugin)this));
                args.setCancel(true);
                break;
            }
            case "change": {
                if (!this.changeValidator()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean changeValidator() {
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e!", (String)"PledgeBillList_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (selectedIdList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\uff01", (String)"PledgeBillList_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        Long selectedId = (Long)selectedIdList.get(0);
        String selectFields = "id,billstatus";
        DynamicObject pledgeBillDyn = TmcDataServiceHelper.loadSingle((Object)selectedId, (String)"gm_pledgebill", (String)selectFields);
        String status = pledgeBillDyn.getString("billstatus");
        if (!BillStatusEnum.AUDIT.getValue().equals(status)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"PledgeBillList_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        switch (op.getOperateKey()) {
            case "cancel": 
            case "uncancel": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "searchuse": {
                Long id = this.getSelectDataById();
                if (EmptyUtil.isEmpty((Long)id)) {
                    return;
                }
                this.showSearchUseForm(id);
                break;
            }
            case "updatevalue": {
                Long id = this.getSelectDataById();
                if (EmptyUtil.isEmpty((Long)id)) {
                    return;
                }
                this.showUpdateValueForm(id);
                break;
            }
            case "change": {
                this.showPledgeBill();
            }
        }
    }

    private void showPledgeBill() {
        Long selectedId = this.getSelectedId();
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("gm_pledgebill_change");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPkId((Object)selectedId);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setBillStatus(BillOperationStatus.EDIT);
        parameter.getCustomParams().put("fromchange", "true");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirm_back_tblcancel".equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("needCheck", "false");
            BillList billList = (BillList)this.getView().getControl("billlistap");
            TmcOperateServiceHelper.execOperate((String)"cancel", (String)"gm_pledgebill", (Object[])billList.getSelectedRows().getPrimaryKeyValues(), (OperateOption)operateOption);
            this.getView().invokeOperation("refresh");
        }
    }

    private void showSearchUseForm(Long id) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gm_pledge_use");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getCustomParams().put("id", id);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirm_back_tblsearchuse"));
        this.getView().showForm(showParameter);
    }

    private void showUpdateValueForm(Long id) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gm_pledge_update");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        QFilter filter = new QFilter("id", "=", (Object)id);
        StringJoiner stringJoiner = new StringJoiner(",").add("id").add("currentappraisedvalue").add("totalpledgevalue").add("currencyid");
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((String)"gm_pledgebill", (String)stringJoiner.toString(), (QFilter[])filter.toArray());
        Object currentAppraisedValue = dynamicObject.get("currentappraisedvalue");
        showParameter.getCustomParams().put("currentappraisedvalue", currentAppraisedValue);
        showParameter.getCustomParams().put("totalpledgevalue", dynamicObject.get("totalpledgevalue"));
        showParameter.getCustomParams().put("id", id);
        showParameter.getCustomParams().put("currencyid", dynamicObject.getDynamicObject("currencyid").getPkValue());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirm_back_tblupdatevalue"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "confirm_back_tblupdatevalue": 
            case "confirm_back_tblcancel": 
            case "confirm_back_tblsearchuse": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }
}

