/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.quota;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GmSourceBillTypeEnum;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeQuotaHelper;

public class GuaranteeQuotaEntryEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    protected final String[] QUOTA_PROPS = new String[]{"billno", "billstatus", "gmguaranteequota", "gmbilltype", "gmbillid", "gmcurrency", "gmbegindate", "gmenddate", "gmamount", "gmadvancequota", "gmactualquota"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object pk = this.getModel().getDataEntity().getPkValue();
        if (EmptyUtil.isEmpty((Object)pk)) {
            return;
        }
        this.loadQuotaUseEntry(pk);
        this.loadReGuaDetailEntry(pk);
    }

    private void loadReGuaDetailEntry(Object id) {
        DynamicObjectCollection reGuaEntryList = this.getModel().getEntryEntity("entry_guaranteedorg");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reGuaEntryList)) {
            return;
        }
        for (DynamicObject reGuaEntry : reGuaEntryList) {
            QFilter idFilter = new QFilter("gmguaranteequota", "=", id);
            List<String> orgTypeList = Collections.singletonList(reGuaEntry.getString("q_reguaranteetype"));
            if (GuaranteeTypeEnum.ORG.getValue().equals(reGuaEntry.getString("q_reguaranteetype")) || GuaranteeTypeEnum.TMCORG.getValue().equals(reGuaEntry.getString("q_reguaranteetype"))) {
                orgTypeList = Arrays.asList(GuaranteeTypeEnum.ORG.getValue(), GuaranteeTypeEnum.TMCORG.getValue());
            }
            idFilter.and(new QFilter("gmorgtype", "in", orgTypeList));
            idFilter.and(new QFilter("gmorgid", "=", (Object)reGuaEntry.getLong("q_guaranteedorg")));
            DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)String.join((CharSequence)",", this.QUOTA_PROPS), (QFilter[])new QFilter[]{idFilter}, (String)"id");
            BigDecimal usedQuotaSum = BigDecimal.ZERO;
            BigDecimal advanceQuotaSum = BigDecimal.ZERO;
            for (DynamicObject quotaUseDO : quotaUseList) {
                usedQuotaSum = usedQuotaSum.add(quotaUseDO.getBigDecimal("gmactualquota"));
                advanceQuotaSum = advanceQuotaSum.add(quotaUseDO.getBigDecimal("gmadvancequota"));
            }
            reGuaEntry.set("q_usedquota", (Object)usedQuotaSum);
            reGuaEntry.set("q_advancequota", (Object)advanceQuotaSum);
            reGuaEntry.set("q_availablequota", (Object)GuaranteeQuotaHelper.getAvailableQuota((DynamicObject)reGuaEntry));
        }
        this.getView().updateView("entry_guaranteedorg");
        this.getModel().setDataChanged(false);
    }

    private void loadQuotaUseEntry(Object id) {
        QFilter idFilter = new QFilter("gmguaranteequota", "=", id);
        DataSet quotaDataSet = QueryServiceHelper.queryDataSet((String)"gm_guaranteequotause", (String)"gm_guaranteequotause", (String)String.join((CharSequence)",", this.QUOTA_PROPS), (QFilter[])new QFilter[]{idFilter}, (String)"id");
        GroupbyDataSet groupDs = quotaDataSet.copy().groupBy(new String[]{"billno"});
        groupDs = groupDs.sum("gmamount").sum("gmadvancequota").sum("gmactualquota");
        DataSet bizDs = groupDs.finish().leftJoin(quotaDataSet).on("billno", "billno").select(quotaDataSet.getRowMeta().getFieldNames()).finish().distinct();
        ArrayList gcEntryList = new ArrayList(16);
        for (Row row : bizDs) {
            HashMap<String, Object> useEntry = new HashMap<String, Object>(16);
            useEntry.put("gmbilltype", row.get("gmbilltype"));
            useEntry.put("gmbillno", row.get("billno"));
            useEntry.put("gmbillid", row.get("gmbillid"));
            useEntry.put("gmbegindate", row.get("gmbegindate"));
            useEntry.put("gmenddate", row.get("gmenddate"));
            useEntry.put("gmcurrency", row.get("gmcurrency"));
            useEntry.put("gmamount", row.get("gmamount"));
            useEntry.put("gmadvancequota", row.get("gmadvancequota"));
            useEntry.put("gmactualquota", row.get("gmactualquota"));
            if (GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue().equals(row.getString("gmbilltype"))) {
                BigDecimal dutyAmt = GuaranteeContractHelper.getContractDutyAmtExcludeCreditLimit((Long)row.getLong("gmbillid"));
                useEntry.put("gmdutyamount", dutyAmt);
                QFilter contractIdFilter = new QFilter("id", "=", (Object)row.getLong("gmbillid"));
                DynamicObject contractDyn = QueryServiceHelper.queryOne((String)"gm_guaranteecontract", (String)"bizstatus", (QFilter[])new QFilter[]{contractIdFilter});
                useEntry.put("gmcontractstatus", EmptyUtil.isEmpty((DynamicObject)contractDyn) ? null : contractDyn.getString("bizstatus"));
            } else {
                useEntry.put("gmdutyamount", Constants.ZERO);
                useEntry.put("gmcontractstatus", null);
            }
            gcEntryList.add(useEntry);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = this.getModel().getDataChanged();
        model.beginInit();
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)model, gcEntryList);
        model.endInit();
        this.getView().updateView("entry");
        this.getModel().setDataChanged(dataChanged);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        String billEntity = (String)this.getModel().getValue("gmbilltype", rowIndex);
        BillShowParameter param = new BillShowParameter();
        param.setFormId(billEntity);
        param.setPkId(this.getModel().getValue("gmbillid", rowIndex));
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }
}

