/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.quota;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class GuaranteeQuotaList
extends AbstractTmcBillBaseList {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        ListShowParameter fsp = (ListShowParameter)e.getFormShowParameter();
        if (EmptyUtil.isNoEmpty((Object)fsp)) {
            fsp.setSelectedEntity(fsp.getBillFormId());
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilterColumn.setDefaultValue(null);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        if (this.getView().getParentView() == null) {
            return;
        }
        final Object pkValue = this.getView().getParentView().getModel().getDataEntity().getPkValue();
        if (pkValue == null) {
            return;
        }
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObject[] limits;
                DynamicObjectCollection dataList = super.getData(arg0, arg1);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                Set ids = dataList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                for (DynamicObject limit : limits = TmcDataServiceHelper.load((String)"gm_guaranteequota", (String)"usedquota,availablequota,entry.gmbillid,entry.advancequota", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                    DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
                    Optional<DynamicObject> first = entry.stream().filter(e -> e.getLong("gmbillid") == ((Long)pkValue).longValue()).findFirst();
                    if (!first.isPresent()) continue;
                    Optional<DynamicObject> firstDataOptional = dataList.stream().filter(e -> e.getLong("id") == ((Long)limit.getPkValue()).longValue()).findFirst();
                    DynamicObject dynamicObject = first.get();
                    if (!firstDataOptional.isPresent()) break;
                    DynamicObject firstData = firstDataOptional.get();
                    firstData.set("usedquota", (Object)limit.getBigDecimal("usedquota").subtract(dynamicObject.getBigDecimal("advancequota")));
                    firstData.set("availablequota", (Object)limit.getBigDecimal("availablequota").add(dynamicObject.getBigDecimal("advancequota")));
                    break;
                }
                return dataList;
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "change": {
                if (!this.changeValidator()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean changeValidator() {
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"GuaranteeQuotaList_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (selectedIdList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (String)"GuaranteeQuotaList_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        Long selectedId = (Long)selectedIdList.get(0);
        String selectFields = "id,status,enable,usedquota,advancequota,availablequota";
        DynamicObject guaranteeQuotaDo = TmcDataServiceHelper.loadSingle((Object)selectedId, (String)"gm_guaranteequota", (String)selectFields);
        String status = guaranteeQuotaDo.getString("status");
        String enable = guaranteeQuotaDo.getString("enable");
        BigDecimal usedQuota = guaranteeQuotaDo.getBigDecimal("usedquota");
        BigDecimal advanceQuota = guaranteeQuotaDo.getBigDecimal("advancequota");
        if (!BillStatusEnum.AUDIT.getValue().equals(status) || BaseEnableEnum.DISABLE.getValue().equals(enable) || usedQuota.add(advanceQuota).compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u4f7f\u7528\u72b6\u6001\u4e3a\u53ef\u7528\uff0c\u4e14\u5df2\u7528\u6216\u9884\u5360\u989d\u5ea6\u5927\u4e8e0\u624d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"GuaranteeQuotaList_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "change": {
                this.showGuaranteeQuota();
                break;
            }
        }
    }

    private void showGuaranteeQuota() {
        Long selectedId = this.getSelectedId();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("gm_guaranteequota");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPkId((Object)selectedId);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setBillStatus(BillOperationStatus.EDIT);
        parameter.getCustomParams().put("fromchange", "true");
        this.getView().showForm((FormShowParameter)parameter);
    }
}

