/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.service;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;
import kd.tmc.gm.common.enums.BizStatusEnum;

public class ReceiveLetterRecBillWriteBackService
extends AbstractRecBillWriteBackService {
    private static final String SELECT_PROP = "id,billno,billstatus,bizstatus,currency,amount,recbillno,eassrcid";

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("recbillno", (Object)param.getRecBill().getRecBillNo());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitExecute(param, sourceBill);
        this.doSaveExecute(param, sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("recbillno", null);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        ReceiveLetterRecBillWriteBackService.checkBillStatus(sourceBill);
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitValidateExecute(param, sourceBill);
        ReceiveLetterRecBillWriteBackService.checkBillStatus(sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        if (EmptyUtil.isEmpty((Long)param.getRecBill().getSourceBillId())) {
            return TmcBotpHelper.getSourceBill((String)"cas_recbill", (Object)param.getRecBill().getRecBillId(), (String)"gm_receiveletter");
        }
        return TmcDataServiceHelper.loadSingle((Object)param.getRecBill().getSourceBillId(), (String)"gm_receiveletter", (String)SELECT_PROP);
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("amount");
    }

    private static void checkBillStatus(DynamicObject sourceBill) {
        if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)sourceBill.getString("billstatus"))) {
            throw new KDBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u6536\u51fd\u767b\u8bb0[%s]\u7684\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u7d22\u8d54\u6536\u6b3e\u3002", (String)"ReceiveLetterRecBillWriteBackService_0", (String)"tmc-gm-mservice", (Object[])new Object[]{sourceBill.getString("billno")})});
        }
        if (!StringUtils.equals((CharSequence)BizStatusEnum.CLAIMED.getValue(), (CharSequence)sourceBill.getString("bizstatus"))) {
            throw new KDBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u6536\u51fd\u767b\u8bb0[%s]\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u7d22\u8d54\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u7d22\u8d54\u6536\u6b3e\u3002", (String)"ReceiveLetterRecBillWriteBackService_1", (String)"tmc-gm-mservice", (Object[])new Object[]{sourceBill.getString("billno")})});
        }
        if (EmptyUtil.isNoEmpty((String)sourceBill.getString("eassrcid"))) {
            throw new KDBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u6536\u51fd\u767b\u8bb0[%s]\u7684EAS ID\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u7d22\u8d54\u6536\u6b3e\u3002", (String)"ReceiveLetterRecBillWriteBackService_2", (String)"tmc-gm-mservice", (Object[])new Object[]{sourceBill.getString("billno")})});
        }
    }
}

