/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.helper.GmReportHelper;

public class GuaranteeUseAnalysesDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private final List<QFilter> guaContractFilterList = new ArrayList<QFilter>(16);
    private final List<QFilter> guaUseFilterList = new ArrayList<QFilter>(16);
    private static final String GUARANTEECONTRACT_FIELDS = "id gid,billno g_billno,entry_guaranteeorg.a_guaranteeorg g_guaranteeorg,entry_guaranteeorg.a_guaranteeorgtext g_guaranteeorgtext,guaranteedorgtext g_guaranteedorgtext,creditortext g_creditortext,reguaranteetype g_reguaranteetype,guaranteeway g_guaranteeway,guarantee.name as g_guaranteetext,currency g_currency,currency.name g_currencytext,entry_guaranteeorg.a_gamount g_amount,entry_guaranteeorg.a_gratio as g_ratio,begindate g_begindate,enddate g_enddate,iscrossguarantee,org.id orgid";
    private static final String GUARANTEEUSE_FIELDS = "gsrcbillid uid,gsrcbillno u_billno,gcontract.id gcontractid,gdebtamount u_gdebtamount,gsrcbilltype u_gsrcbilltype,gcparty u_gcparty,gdebtcurrency u_gdebtcurrency,gdebtcurrency.name u_gdebtcurrencytext,gdebtstartdate u_gdebtstartdate,gdebtenddate u_gdebtenddate,";

    public DataSet queryDataSet(ReportQueryParam param) {
        this.init(param);
        return this.queryBillData();
    }

    private DataSet queryBillData() {
        DataSet guaranteeContracts = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_guaranteecontract"), (String)"gm_guaranteecontract", (String)GUARANTEECONTRACT_FIELDS, (QFilter[])this.guaContractFilterList.toArray(new QFilter[0]), (String)"createtime desc,id").distinct();
        if (!guaranteeContracts.copy().isEmpty()) {
            HashSet<Long> ids = new HashSet<Long>(16);
            for (Row guaranteeContract : guaranteeContracts.copy()) {
                Long id = (Long)guaranteeContract.get("gid");
                ids.add(id);
            }
            DataSet payableBillDS = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cdm_payablebill"), (String)"cdm_payablebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("draftbillstatus", "in", Arrays.asList("splited", "payoffed"))}, null);
            StringBuilder stringBuilder = new StringBuilder();
            for (Row payableBill : payableBillDS.copy()) {
                stringBuilder.append(payableBill.get("id")).append(",");
            }
            String payableIds = stringBuilder.toString();
            payableIds = EmptyUtil.isNoEmpty((String)payableIds) ? payableIds.substring(0, payableIds.length() - 1) : "0";
            this.guaUseFilterList.add(new QFilter("gsrcbilltype", "!=", (Object)"cfm_creditlimit"));
            this.guaUseFilterList.add(new QFilter("gsrcbilltype", "!=", (Object)"creditm_limit_framework"));
            this.guaUseFilterList.add(new QFilter("gcontract.id", "in", ids));
            this.guaUseFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            DataSet guaranteeUse = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_guaranteeuse"), (String)"gm_guaranteeuse", (String)("gsrcbillid uid,gsrcbillno u_billno,gcontract.id gcontractid,gdebtamount u_gdebtamount,gsrcbilltype u_gsrcbilltype,gcparty u_gcparty,gdebtcurrency u_gdebtcurrency,gdebtcurrency.name u_gdebtcurrencytext,gdebtstartdate u_gdebtstartdate,gdebtenddate u_gdebtenddate,case when gsrcbilltype='cdm_payablebill' and gsrcbillid in (" + payableIds + ") then 0 else gdebtbalance*gexchrate end u_gdebtbalance,case when gratio = 0 then 'C' when gdebtbalance = 0 or (gsrcbilltype='cdm_payablebill' and gsrcbillid in (" + payableIds + ")) then 'B' else 'A' end u_gstatus"), (QFilter[])this.guaUseFilterList.toArray(new QFilter[0]), null);
            DataSet guaranteeUseGroup = guaranteeUse.copy().groupBy(new String[]{"gcontractid", "uid"}).sum("u_gdebtbalance").finish();
            guaranteeUseGroup = guaranteeUseGroup.select("gcontractid,uid,u_gdebtbalance");
            RowMeta rowMeta = guaranteeContracts.getRowMeta();
            RowMeta urowMeta = guaranteeUse.getRowMeta();
            guaranteeContracts = guaranteeContracts.leftJoin(guaranteeUse).on("gid", "gcontractid").select(rowMeta.getFieldNames(), urowMeta.getFieldNames()).finish();
            guaranteeContracts = guaranteeContracts.leftJoin(guaranteeUseGroup).on("gid", "gcontractid").on("uid", "uid").select(guaranteeContracts.getRowMeta().getFieldNames(), new String[]{"case when iscrossguarantee=true and orgid=g_guaranteeorg then 0 else u_gdebtbalance*g_ratio/100 end g_dutyamount"}).finish();
        } else {
            guaranteeContracts = guaranteeContracts.addField("0", "g_dutyamount");
        }
        return guaranteeContracts;
    }

    private void init(ReportQueryParam reportQueryParam) {
        FilterInfo filters = reportQueryParam.getFilter();
        FilterItemInfo guarantees = filters.getFilterItem("filter_guarantee");
        FilterItemInfo beginDate = filters.getFilterItem("filter_begindate");
        FilterItemInfo cutOffDate = filters.getFilterItem("filter_cutoffdate");
        FilterItemInfo currency = filters.getFilterItem("filter_currency");
        FilterItemInfo closed = filters.getFilterItem("filter_closed");
        FilterItemInfo settled = filters.getFilterItem("filter_settled");
        FilterItemInfo outGroup = filters.getFilterItem("filter_outgroup");
        if (EmptyUtil.isNoEmpty((Object)guarantees.getValue())) {
            DynamicObjectCollection guaranteesColl = (DynamicObjectCollection)guarantees.getValue();
            this.guaContractFilterList.add(new QFilter("guarantee", "in", (Object)guaranteesColl.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        this.guaContractFilterList.add(GmReportHelper.getDateFilter(beginDate, cutOffDate));
        List queryOrgIds = this.getQueryOrgIds(reportQueryParam);
        GmReportHelper.getOrgFilter(queryOrgIds, this.guaContractFilterList);
        GmReportHelper.dealFilter(this.guaContractFilterList, "currency", currency);
        this.guaContractFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (!((Boolean)closed.getValue()).booleanValue()) {
            this.guaContractFilterList.add(new QFilter("bizstatus", "!=", (Object)GuaConBizStatusEnum.CLOSED.getValue()));
        }
        if (!((Boolean)outGroup.getValue()).booleanValue()) {
            this.guaContractFilterList.add(new QFilter("entry_guaranteedorg.b_reguaranteetype", "not in", (Object)new String[]{GuaranteeTypeEnum.OTHER.getValue(), GuaranteeTypeEnum.PARTNER.getValue()}));
        }
        if (!((Boolean)settled.getValue()).booleanValue()) {
            this.guaUseFilterList.add(new QFilter("gratio", "!=", (Object)0).and("gdebtbalance", "!=", (Object)0));
        } else {
            this.guaUseFilterList.add(new QFilter("gratio", "!=", (Object)0));
        }
    }

    protected String getCurrencyField() {
        return "g_currency";
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("g_amount", "g_dutyamount", "u_gdebtamount", "u_gdebtbalance");
    }

    public List<String> sumAmountFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("g_dutyamount_report");
        return fields;
    }

    public String sumNameField() {
        return "g_guaranteeorgtext";
    }
}

