/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.helper.GmReportHelper;
import org.apache.commons.lang3.tuple.Pair;

public class LetterOfGuaranteeDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Map<String, Object> paramMap = null;
    private String groupString = null;
    private String orderString = null;
    private final List<QFilter> filterList = new ArrayList<QFilter>(12);
    private static final String COMMON_FIELDS = "id,billno,finorginfo.bank_cate.id bankcateid,finorginfo.bank_cate.name bankcatename,finorginfo,finorginfo.name finorginfotext,guaranteevariety.name guaranteevariety,guaranteetype,guaranteetype.name guaranteetypetext,currency,currency.name currencytext,amount";
    private static final String LETTER_FIELDS = "applyorg,applyorg.name applyorgtext,beneficiarytype,textbeneficiary,startdate,expiredate,comprehfeerate,feepaymentmethod";
    private static final String RECEIVE_FIELDS = "applyorg beneficiary,applyorg.name beneficiarytext,beneficiarytype appliertype,textbeneficiary applier,startdate,expiredate";

    public DataSet queryDataSet(ReportQueryParam param) {
        this.init(param);
        return this.queryBillData();
    }

    private DataSet queryBillData() {
        String bizType = (String)this.paramMap.get("filter_biztype");
        if ("send".equals(bizType)) {
            return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_letterofguarantee"), (String)"gm_letterofguarantee", (String)"id,billno,finorginfo.bank_cate.id bankcateid,finorginfo.bank_cate.name bankcatename,finorginfo,finorginfo.name finorginfotext,guaranteevariety.name guaranteevariety,guaranteetype,guaranteetype.name guaranteetypetext,currency,currency.name currencytext,amount,applyorg,applyorg.name applyorgtext,beneficiarytype,textbeneficiary,startdate,expiredate,comprehfeerate,feepaymentmethod", (QFilter[])this.filterList.toArray(new QFilter[0]), (String)this.orderString);
        }
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_receiveletter"), (String)"gm_receiveletter", (String)"id,billno,finorginfo.bank_cate.id bankcateid,finorginfo.bank_cate.name bankcatename,finorginfo,finorginfo.name finorginfotext,guaranteevariety.name guaranteevariety,guaranteetype,guaranteetype.name guaranteetypetext,currency,currency.name currencytext,amount,applyorg beneficiary,applyorg.name beneficiarytext,beneficiarytype appliertype,textbeneficiary applier,startdate,expiredate", (QFilter[])this.filterList.toArray(new QFilter[0]), (String)this.orderString);
    }

    private void init(ReportQueryParam reportQueryParam) {
        ArrayList<String> bizStatus;
        boolean lookUpDetail;
        String startDate;
        String[] dimensions;
        this.paramMap = this.transQueryParam(reportQueryParam);
        this.paramMap.putAll(reportQueryParam.getCustomParam());
        FilterInfo filters = reportQueryParam.getFilter();
        String dimension = (String)this.paramMap.get("filter_statdim");
        StringBuilder group = new StringBuilder(dimension.replaceAll("_", ","));
        for (String s : dimensions = dimension.split("_")) {
            group.append(',').append(s).append("text");
        }
        this.groupString = group.toString();
        this.orderString = dimension.replaceAll("_", ",");
        DynamicObjectCollection finorginfo = (DynamicObjectCollection)this.paramMap.get("filter_finorginfo");
        FilterItemInfo currency = filters.getFilterItem("filter_currency");
        String bizType = (String)this.paramMap.get("filter_biztype");
        if ("send".equals(bizType)) {
            List applyOrg = this.getQueryOrgIds(reportQueryParam);
            this.filterList.add(new QFilter("applyorg", "in", (Object)(EmptyUtil.isNoEmpty((Object)applyOrg) ? applyOrg : new ArrayList(10))));
        } else {
            List beneficiary = this.getQueryOrgIds(reportQueryParam, "filter_beneficiary_org", "filter_beneficiary_orgv");
            this.filterList.add(new QFilter("applyorg", "in", (Object)(EmptyUtil.isNoEmpty((Object)beneficiary) ? beneficiary : new ArrayList(10))));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finorginfo)) {
            List ids = finorginfo.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            this.filterList.add(new QFilter("finorginfo", "in", ids));
        }
        if (EmptyUtil.isNotEmpty((CharSequence)(startDate = (String)this.paramMap.get("filter_startdate")))) {
            QFilter qFilter = GmReportHelper.buildDateRangesFilter(startDate, "startdate", "startdateranges", this.paramMap);
            this.filterList.add(qFilter);
        }
        GmReportHelper.dealFilter(this.filterList, "currency.id", currency);
        this.filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        boolean hasCanceled = (Boolean)this.paramMap.get("filter_hascanceled");
        boolean hasClaimed = (Boolean)this.paramMap.get("filter_hasclaimed");
        Date filtercutoffdate = (Date)this.paramMap.get("filter_cutoffdate");
        if (EmptyUtil.isNoEmpty((Object)filtercutoffdate)) {
            QFilter startdateFilter = new QFilter("startdate", "<=", (Object)filtercutoffdate);
            if (!hasClaimed) {
                QFilter claimDateFilter = new QFilter("claimdate", ">", (Object)filtercutoffdate).or(new QFilter("claimdate", "is null", null));
                startdateFilter = startdateFilter.and(claimDateFilter);
            }
            if (!hasCanceled) {
                QFilter cancelDateFilter = new QFilter("canceldate", ">", (Object)filtercutoffdate).or(new QFilter("canceldate", "is null", null));
                startdateFilter = startdateFilter.and(cancelDateFilter);
            }
            this.filterList.add(startdateFilter);
        }
        if (!(lookUpDetail = ((Boolean)this.paramMap.get("lookupdetail")).booleanValue())) {
            bizStatus = new ArrayList<String>();
            bizStatus.add(BizStatusEnum.REGISTERING.getValue());
            this.filterList.add(new QFilter("bizstatus", "not in", bizStatus));
        } else {
            bizStatus = new ArrayList();
            bizStatus.add(BizStatusEnum.REGISTERED.getValue());
            bizStatus.add(BizStatusEnum.CLAIMED.getValue());
            bizStatus.add(BizStatusEnum.CANCELLED.getValue());
            QFilter qFilter = new QFilter("bizstatus", "in", bizStatus);
            this.filterList.add(qFilter);
        }
    }

    public List<String> sumAmountFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("amount");
        fields.add("amount_report");
        return fields;
    }

    public String sumNameField() {
        String bizType = (String)this.paramMap.get("filter_biztype");
        if ("send".equals(bizType)) {
            return "applyorgtext";
        }
        return "beneficiarytext";
    }

    public List<String> groupFields() {
        return Arrays.stream(this.groupString.split(",")).collect(Collectors.toList());
    }

    public List<String> amountFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("amount");
        fields.add("amount_report");
        return fields;
    }

    public String customFields() {
        return "";
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        String bizType = (String)this.paramMap.get("filter_biztype");
        if ("send".equals(bizType)) {
            return Pair.of((Object)"applyorg", (Object)"applyorgtext");
        }
        return Pair.of((Object)"beneficiary", (Object)"beneficiarytext");
    }
}

