/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.form.AbstractGuaranteeContractFormPlugin;

public class GuaranteeContractRptFormPlugin
extends AbstractGuaranteeContractFormPlugin
implements HyperLinkClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_statdim": 
            case "filter_istotal": {
                this.search();
            }
        }
    }

    public void beforeQuery(ReportQueryParam param) {
        long orgId;
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject companyView = (DynamicObject)param.getFilter().getFilterItem("filter_orgview").getValue();
            orgId = Long.parseLong(TmcOrgDataHelper.getOrgRootId((Long)companyView.getLong("id")));
        } else {
            orgId = RequestContext.get().getOrgId();
        }
        param.getCustomParam().put("org", orgId);
        param.getCustomParam().put("filter_statdim", this.getModel().getValue("filter_statdim"));
        param.getCustomParam().put("filter_istotal", this.getModel().getValue("filter_istotal"));
        param.getCustomParam().put("filter_guaranteeorgid", this.getPageCache().get("filter_guaranteeorgid"));
        param.getCustomParam().put("filter_creditorid", this.getPageCache().get("filter_creditorid"));
        param.getCustomParam().put("filter_reguaid", this.getPageCache().get("filter_reguaid"));
        this.controlTableColumns();
    }

    private List<String> allDimension() {
        return Arrays.asList("guaranteeorg", "creditor", "guarantee", "currency");
    }

    private void controlTableColumns() {
        String dimension = (String)this.getModel().getValue("filter_statdim");
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        ArrayList<String> col = new ArrayList<String>(4);
        List<String> allDimensions = this.allDimension();
        String[] curDimensions = dimension.split("_");
        List ExcludeDimensions = allDimensions.stream().filter(a -> Arrays.stream(curDimensions).noneMatch(a::equals)).collect(Collectors.toList());
        for (String excludeDimension : ExcludeDimensions) {
            col.add(excludeDimension);
            if (excludeDimension.contains("text")) continue;
            col.add(excludeDimension + "text");
        }
        List columns = listTable.getColumns();
        columns.removeIf(column -> {
            if (column instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)column;
                return col.contains(reportColumn.getFieldKey());
            }
            return false;
        });
    }

    public boolean verifyQuery(ReportQueryParam param) {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_statcurrency", "filter_statdim", "filter_currencyunit"});
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String statDim;
        Map<String, Object> mapFromFilter = this.getMapFromFilter();
        switch (statDim = (String)this.getModel().getValue("filter_statdim")) {
            case "guaranteeorg": {
                this.getGuaValByGuaOrg(event, mapFromFilter, "guaranteetype", "guaranteeorg", "guaranteeorgtext");
                break;
            }
            case "creditor": {
                this.getGuaValByGuaOrg(event, mapFromFilter, "creditortype", "creditor", "creditortext");
                break;
            }
            case "guarantee": {
                this.getGuaValByGuee(event, mapFromFilter);
                break;
            }
            case "guaranteeorg_currency": {
                this.getGuaValByCurrency(event, mapFromFilter, "guaranteeorg", "guaranteeorg");
                break;
            }
            case "creditor_currency": {
                this.getGuaValByCurrency(event, mapFromFilter, "creditor", "creditor");
                break;
            }
            case "guarantee_currency": {
                this.getGuaValByCurrency(event, mapFromFilter, "guarantee", "filter_guaranteeid");
            }
        }
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("gm_guaranteecontract_dtl");
        param.setCustomParams(mapFromFilter);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private void getGuaValByCurrency(HyperLinkClickEvent event, Map<String, Object> map, String idField, String key) {
        int rowIndex = event.getRowIndex();
        IReportListModel reportModel = this.getReportModel(event);
        DynamicObject curRowData = reportModel.getRowData(rowIndex);
        long baseId = curRowData.getLong(idField);
        DynamicObject currency = curRowData.getDynamicObject("currency");
        map.put(key, Collections.singletonList(baseId));
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            map.put("filter_currency", currency.getPkValue());
        }
    }

    private void getGuaValByGuee(HyperLinkClickEvent event, Map<String, Object> map) {
        int rowIndex = event.getRowIndex();
        IReportListModel reportModel = this.getReportModel(event);
        DynamicObject curRowData = reportModel.getRowData(rowIndex);
        map.put("filter_guaranteeid", Collections.singletonList(curRowData.get("guarantee")));
    }

    private void getGuaValByGuaOrg(HyperLinkClickEvent event, Map<String, Object> map, String typeColum, String idColum, String textColum) {
        int rowIndex = event.getRowIndex();
        IReportListModel reportModel = this.getReportModel(event);
        DynamicObject curRowData = reportModel.getRowData(rowIndex);
        int rowCount = reportModel.getRowCount();
        String sumLevel = curRowData.getString("sumlevel");
        String guaOrgType = (String)curRowData.get(typeColum);
        this.removeDefaulVal(map, typeColum, idColum, textColum);
        if ("0".equals(sumLevel)) {
            Set<Long> allIds = this.getAllId(reportModel, rowIndex, rowCount, idColum, guaOrgType);
            map.put(typeColum, GuaranteeTypeEnum.ORG.getValue().equals(guaOrgType) ? GuaranteeTypeEnum.TMCORG.getValue() : guaOrgType);
            map.put(idColum, allIds);
            if (allIds.size() == 1 || GuaranteeTypeEnum.TMCBANK.getValue().equals(guaOrgType) || GuaranteeTypeEnum.TMCNOTBANK.getValue().equals(guaOrgType)) {
                map.put(textColum, curRowData.get(textColum));
            }
        } else if ("1".equals(sumLevel)) {
            map.put(typeColum, GuaranteeTypeEnum.ORG.getValue().equals(guaOrgType) ? GuaranteeTypeEnum.TMCORG.getValue() : guaOrgType);
        }
    }

    private void removeDefaulVal(Map<String, Object> map, String type, String id, String text) {
        map.remove(type);
        map.remove(id);
        map.remove(text);
    }

    private Set<Long> getAllId(IReportListModel reportModel, int rowIndex, int rowCount, String idField, String guaOrgType) {
        HashSet<Long> guaIds = new HashSet<Long>();
        DynamicObject curRowData = reportModel.getRowData(rowIndex);
        HashSet<String> parentIds = new HashSet<String>();
        parentIds.add(curRowData.getString("rowid"));
        boolean isBank = GuaranteeTypeEnum.TMCBANK.getValue().equals(guaOrgType) || GuaranteeTypeEnum.TMCNOTBANK.getValue().equals(guaOrgType);
        long dataId = curRowData.getLong(idField);
        if (!isBank && EmptyUtil.isEmpty((Long)dataId)) {
            return guaIds;
        }
        guaIds.add(dataId);
        for (int i = rowIndex + 1; i <= rowCount; ++i) {
            curRowData = reportModel.getRowData(i);
            String rowId = curRowData.getString("rowid");
            String pid = curRowData.getString("pid");
            if (!parentIds.contains(pid)) break;
            parentIds.add(rowId);
            guaIds.add(curRowData.getLong(idField));
        }
        return guaIds;
    }

    private Map<String, Object> getMapFromFilter() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        IPageCache pageCache = this.getPageCache();
        map.put("guaranteeorg", pageCache.get("filter_guaranteeorgid"));
        map.put("guaranteetype", this.getModel().getValue("filter_guaranteetype"));
        map.put("guaranteeorgtext", this.getModel().getValue("filter_guaranteeorgtext"));
        map.put("reguaid", pageCache.get("filter_reguaid"));
        map.put("reguatype", this.getModel().getValue("filter_reguatype"));
        map.put("reguatext", this.getModel().getValue("filter_reguatext"));
        map.put("creditor", pageCache.get("filter_creditorid"));
        map.put("creditortype", this.getModel().getValue("filter_creditortype"));
        map.put("creditortext", this.getModel().getValue("filter_creditortext"));
        DynamicObjectCollection guaranteeColl = (DynamicObjectCollection)this.getModel().getValue("filter_guarantee");
        Set guaranteeIds = guaranteeColl.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        map.put("filter_guaranteeid", guaranteeIds);
        map.put("filter_queryway", this.getModel().getValue("filter_queryway"));
        DynamicObjectCollection orgIds = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        map.put("filter_org", orgIds.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_currency");
        map.put("filter_currency", currency != null ? currency.getPkValue() : null);
        DynamicObject compView = (DynamicObject)this.getModel().getValue("filter_orgview");
        map.put("filter_orgview", compView != null ? compView.getPkValue() : null);
        map.put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        map.put("filter_statdim", this.getModel().getValue("filter_statdim"));
        map.put("filter_cutoffdate", this.getModel().getValue("filter_cutoffdate"));
        map.put("detail", true);
        return map;
    }

    private IReportListModel getReportModel(HyperLinkClickEvent event) {
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        return reportModel;
    }
}

