/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.constant.GmReportResConst;
import kd.tmc.gm.form.AbstractLetterOfGuaranteeFormPlugin;

public class LetterOfGuaranteeDetailFormPlugin
extends AbstractLetterOfGuaranteeFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_statdim": {
                this.search();
                break;
            }
            case "filter_biztype": {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (this.isViewQueryWay() && this.isSendBizType() ? 1 : 0) != 0, (String[])new String[]{"filter_orgview"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (this.isViewQueryWay() && !this.isSendBizType() ? 1 : 0) != 0, (String[])new String[]{"filter_beneficiary_orgv"});
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (this.isViewQueryWay() && this.isSendBizType() ? 1 : 0) != 0, (String[])new String[]{"filter_orgview"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (this.isViewQueryWay() && !this.isSendBizType() ? 1 : 0) != 0, (String[])new String[]{"filter_beneficiary_orgv"});
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.containsKey("detail")) {
            this.getModel().setValue("lookupdetail", (Object)Boolean.TRUE);
            this.setMutiBaseData(customParams, "filter_org");
            this.setMutiBaseData(customParams, "filter_beneficiary_org");
            this.setMutiBaseData(customParams, "filter_finorginfo");
            this.getModel().setValue("filter_startdate", customParams.get("filter_startdate"));
            this.getModel().setValue("startdateranges_startdate", customParams.get("startdateranges_startdate"));
            this.getModel().setValue("startdateranges_enddate", customParams.get("startdateranges_enddate"));
            this.getModel().setValue("filter_queryway", customParams.get("filter_queryway"));
            this.getModel().setValue("filter_orgview", customParams.get("filter_orgview"));
            this.getModel().setValue("filter_beneficiary_orgv", customParams.get("filter_beneficiary_orgv"));
            this.getModel().setValue("filter_biztype", customParams.get("filter_biztype"));
            this.getModel().setValue("filter_currency", customParams.get("filter_currency"));
            this.getModel().setValue("filter_cutoffdate", customParams.get("filter_cutoffdate"));
            this.getModel().setValue("filter_currencyunit", customParams.get("filter_currencyunit"));
            this.getModel().setValue("filter_statcurrency", customParams.get("filter_statcurrency"));
            this.getModel().setValue("filter_hascanceled", customParams.get("filter_hascanceled"));
            this.getModel().setValue("filter_hasclaimed", customParams.get("filter_hasclaimed"));
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            this.getView().setEnable(Boolean.FALSE, new String[]{"filter_biztype", "filter_org", "filter_beneficiary_org", "filter_currencyunit", "filter_statcurrency", "filter_statdim", "filter_currency", "filter_cutoffdate", "filter_finorginfo", "filter_hascanceled", "filter_hasclaimed", "filter_queryway", "filter_orgview", "filter_beneficiary_orgv", "filter_startdate", "startdateranges_startdate", "startdateranges_enddate"});
            rptFilter.search();
        }
    }

    private void setMutiBaseData(Map<String, Object> customParams, String name) {
        String finOrgInfo = (String)customParams.get(name);
        if (EmptyUtil.isNoEmpty((String)finOrgInfo)) {
            String[] finOrgInfoArray = finOrgInfo.split(",");
            this.getModel().setValue(name, (Object)Arrays.stream(finOrgInfoArray).map(Long::valueOf).toArray());
        }
    }

    @Override
    public void beforeQuery(ReportQueryParam param) {
        super.beforeQuery(param);
        String bizType = (String)this.getModel().getValue("filter_biztype");
        String staDim = (String)this.getModel().getValue("filter_statdim");
        String newStaDim = this.replaceStaDim(bizType, staDim);
        param.getCustomParam().put("filter_statdim", newStaDim);
        param.getCustomParam().put("lookupdetail", this.getModel().getValue("lookupdetail"));
        this.controlTableColumns(newStaDim, bizType);
    }

    private void controlTableColumns(String dimension, String bizType) {
        String[] curDimensions;
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        ArrayList<String> col = new ArrayList<String>(4);
        ArrayList reportColumns = new ArrayList(4);
        for (String curDimension : curDimensions = dimension.split("_")) {
            col.add(dimension);
            if (curDimension.contains("text")) continue;
            col.add(curDimension + "text");
        }
        boolean isSend = "send".equals(bizType);
        List<String> sendFields = Arrays.asList("applyorgtext", "textbeneficiary", "comprehfeerate", "feepaymentmethod");
        List<String> receiveFields = Arrays.asList("beneficiarytext", "appliertype", "applier");
        List columns = listTable.getColumns();
        columns.removeIf(column -> {
            if (column instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)column;
                String fieldKey = reportColumn.getFieldKey();
                boolean isDimensions = col.contains(fieldKey);
                if (isDimensions) {
                    reportColumns.add(reportColumn);
                }
                boolean notVisible = isSend && receiveFields.contains(fieldKey) || !isSend && sendFields.contains(fieldKey);
                return isDimensions || notVisible;
            }
            return false;
        });
        columns.addAll(0, reportColumns);
    }

    private String replaceStaDim(String type, String dimension) {
        if ("send".equals(type)) {
            return dimension.replace("company", "applyorg");
        }
        return dimension.replace("company", "beneficiary");
    }

    @Override
    public boolean verifyQuery(ReportQueryParam param) {
        String startDate;
        super.verifyQuery(param);
        FilterInfo filters = param.getFilter();
        boolean lookupDetail = (Boolean)this.getModel().getValue("lookupdetail");
        if (!lookupDetail && "custom".equals(startDate = (String)filters.getFilterItem("filter_startdate").getValue())) {
            Date rangeStart = (Date)filters.getFilterItem("startdateranges_startdate").getValue();
            Date rangeEnd = (Date)filters.getFilterItem("startdateranges_enddate").getValue();
            if (EmptyUtil.isEmpty((Object)rangeStart) || EmptyUtil.isEmpty((Object)rangeEnd)) {
                this.getView().showTipNotification(GmReportResConst.getGmReportResConst13());
                return false;
            }
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("billno".equals(fieldName)) {
            String bizType = (String)this.getModel().getValue("filter_biztype");
            int rowIndex = event.getRowIndex();
            ReportList reportList = (ReportList)event.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            BillShowParameter param = new BillShowParameter();
            param.setFormId("send".equals(bizType) ? "gm_letterofguarantee" : "gm_receiveletter");
            param.setPkId(rowData.get("id"));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

