/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.constant.GmReportResConst;
import org.apache.commons.lang3.StringUtils;

public class GmReportHelper
extends AbstractReportFormPlugin {
    public static final String COMMA_SEPARATOR = ",";
    public static final String UNDERLINE_SEPARATOR = "_";

    public static void dealFilter(List<QFilter> qFilters, String property, FilterItemInfo filterItemInfo) {
        if (EmptyUtil.isNoEmpty((Object)filterItemInfo.getValue())) {
            if (filterItemInfo.getValue() instanceof DynamicObjectCollection) {
                DynamicObjectCollection col = (DynamicObjectCollection)filterItemInfo.getValue();
                if (col.size() == 1) {
                    qFilters.add(new QFilter(property, "=", (Object)((DynamicObject)col.get(0)).getLong("id")));
                } else {
                    HashSet<Long> ids = new HashSet<Long>(col.size());
                    for (DynamicObject dynamicObject : col) {
                        ids.add(dynamicObject.getLong("id"));
                    }
                    qFilters.add(new QFilter(property, "in", ids));
                }
            } else if (filterItemInfo.getValue() instanceof DynamicObject) {
                qFilters.add(new QFilter(property, "=", ((DynamicObject)filterItemInfo.getValue()).getPkValue()));
            } else if (filterItemInfo.getValue() instanceof String) {
                qFilters.add(new QFilter(property, "=", filterItemInfo.getValue()));
            } else {
                qFilters.add(new QFilter(property, "=", filterItemInfo.getValue()));
            }
        }
    }

    public static QFilter getTypeFilter(String prop, Object val) {
        if (EmptyUtil.isNoEmpty((Object)val)) {
            if (GuaranteeTypeEnum.TMCORG.getValue().equals(val)) {
                return new QFilter(prop, "in", (Object)new Object[]{GuaranteeTypeEnum.ORG.getValue(), val});
            }
            return new QFilter(prop, "in", val);
        }
        return null;
    }

    public static String genRootTypeFileds(DataSet dataSet, String groupString) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        DataType[] dataTypes = dataSet.getRowMeta().getDataTypes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dataTypes.length; ++i) {
            DataType dataType = dataTypes[i];
            String fieldName = fieldNames[i];
            if (dataType instanceof LongType || dataType instanceof BigDecimalType) {
                sb.append("0 ").append(fieldName);
            } else if (dataType instanceof StringType) {
                if (groupString.contains(fieldName)) {
                    sb.append("name ").append(fieldName);
                } else {
                    sb.append("'' ").append(fieldName);
                }
            }
            if (i == dataTypes.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static String getTotalCaption(String type) {
        switch (type) {
            case "tmc_bank": {
                return GmReportResConst.getGmReportResConst18();
            }
            case "tmc_otherbank": {
                return GmReportResConst.getGmReportResConst19();
            }
            case "bos_org": {
                return GmReportResConst.getGmReportResConst21();
            }
            case "tmc_org": {
                return GmReportResConst.getGmReportResConst21();
            }
            case "bd_bizpartner": {
                return GmReportResConst.getGmReportResConst22();
            }
            case "other": {
                return GmReportResConst.getGmReportResConst23();
            }
        }
        return "";
    }

    public static String getType(String type) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"guaranteeorg")) {
            return "guaranteetype";
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"creditor")) {
            return "creditortype";
        }
        return "";
    }

    public static QFilter buildDateRangesFilter(String rangeVal, String dateField, String rangeId, Map<String, Object> paramMap) {
        Date currentDate = DateUtils.getCurrentDate();
        QFilter qFilter = null;
        if (EmptyUtil.isNoEmpty((String)rangeVal)) {
            switch (rangeVal) {
                case "thismonth": {
                    qFilter = new QFilter(dateField, ">=", (Object)DateUtils.getMinMonthDate((Date)currentDate)).and(new QFilter(dateField, "<=", (Object)DateUtils.getMaxMonthDate((Date)currentDate)));
                    break;
                }
                case "thisquarter": {
                    qFilter = new QFilter(dateField, ">=", (Object)DateUtils.getFirstSeasonDate((Date)currentDate)).and(new QFilter(dateField, "<=", (Object)DateUtils.getLastSeasonDate((Date)currentDate)));
                    break;
                }
                case "thisyear": {
                    qFilter = new QFilter(dateField, ">=", (Object)DateUtils.getFirstDayOfCurYear()).and(new QFilter(dateField, "<=", (Object)DateUtils.getLastDayOfCurYear()));
                    break;
                }
                case "nextmonth": {
                    qFilter = new QFilter(dateField, ">=", (Object)DateUtils.getFirstDateOfNextMonth((Date)currentDate)).and(new QFilter(dateField, "<=", (Object)DateUtils.getLastDateOfNextMonth((Date)currentDate)));
                    break;
                }
                case "nextweek": {
                    Date nextMonday = DateUtils.getNextWeekMonday((Date)currentDate);
                    qFilter = new QFilter(dateField, ">=", (Object)nextMonday).and(new QFilter(dateField, "<=", (Object)DateUtils.getNextDay((Date)nextMonday, (int)6)));
                    break;
                }
                case "thisweek": {
                    qFilter = new QFilter(dateField, ">=", (Object)DateUtils.getFirstDayOfWeek((Date)currentDate)).and(new QFilter(dateField, "<", (Object)DateUtils.getNextWeekMonday((Date)currentDate)));
                    break;
                }
                case "custom": {
                    Date endDate;
                    Date startDate = (Date)paramMap.get(rangeId + "_startdate");
                    if (startDate != null) {
                        qFilter = new QFilter(dateField, ">=", (Object)startDate);
                    }
                    if ((endDate = (Date)paramMap.get(rangeId + "_enddate")) == null) break;
                    QFilter filter = new QFilter(dateField, "<=", (Object)endDate);
                    qFilter = qFilter == null ? filter : qFilter.and(filter);
                    break;
                }
            }
        }
        return qFilter;
    }

    public static List<Long> getBaseIds(String idStr) {
        String[] split = idStr.split(COMMA_SEPARATOR);
        return Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
    }

    public static QFilter getDateFilter(FilterItemInfo beginDateInfo, FilterItemInfo cutOffDateInfo) {
        Date endDate;
        QFilter beginDateFilter = QFilter.isNull((String)"begindate");
        Date beginDate = (Date)beginDateInfo.getValue();
        QFilter dataFilter = null;
        if (EmptyUtil.isNoEmpty((Object)beginDate)) {
            dataFilter = new QFilter("begindate", ">=", (Object)beginDate);
        }
        if (EmptyUtil.isNoEmpty((Object)(endDate = (Date)cutOffDateInfo.getValue()))) {
            QFilter qFilter = new QFilter("begindate", "<=", (Object)endDate);
            if (dataFilter != null) {
                dataFilter.and(qFilter);
            } else {
                dataFilter = qFilter;
            }
        }
        if (dataFilter != null) {
            return beginDateFilter.or(dataFilter);
        }
        return beginDateFilter;
    }

    public static void getOrgFilter(List<Long> orgIds, List<QFilter> filterList) {
        if (EmptyUtil.isNoEmpty(orgIds)) {
            QFilter orgFilter = new QFilter("org.id", "in", orgIds);
            orgFilter.or(new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", orgIds));
            orgFilter.or(new QFilter("entry_guaranteedorg.b_guaranteedorg", "in", orgIds));
            filterList.add(orgFilter);
        } else {
            filterList.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        }
    }

    public static void getGuaranFilter(Map<String, Object> paramMap, List<QFilter> filterList) {
        String guaranteeOrgId = (String)paramMap.get("filter_guaranteeorgid");
        String reGuaranteeOrgId = (String)paramMap.get("filter_reguaid");
        String creditorId = (String)paramMap.get("filter_creditorid");
        filterList.add(GmReportHelper.getTypeFilter("entry_guaranteeorg.a_guaranteetype", paramMap.get("filter_guaranteetype")));
        if (EmptyUtil.isNoEmpty((String)guaranteeOrgId)) {
            filterList.add(new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", GmReportHelper.getBaseIds(guaranteeOrgId)));
        }
        filterList.add(GmReportHelper.getTypeFilter("entry_guaranteedorg.b_reguaranteetype", paramMap.get("filter_reguatype")));
        if (EmptyUtil.isNoEmpty((String)reGuaranteeOrgId)) {
            filterList.add(new QFilter("entry_guaranteedorg.b_guaranteedorg", "in", GmReportHelper.getBaseIds(reGuaranteeOrgId)));
        }
        if (GuaranteeTypeEnum.OTHER.getValue().equals(paramMap.get("filter_reguatype")) && EmptyUtil.isNoEmpty((Object)paramMap.get("filter_reguatext"))) {
            filterList.add(new QFilter("entry_guaranteedorg.b_guaranteedorgtext", "in", paramMap.get("filter_reguatext")));
        }
        filterList.add(GmReportHelper.getTypeFilter("creditortype", paramMap.get("filter_creditortype")));
        if (EmptyUtil.isNoEmpty((String)creditorId)) {
            filterList.add(new QFilter("creditor", "in", GmReportHelper.getBaseIds(creditorId)));
        }
        if (GuaranteeTypeEnum.OTHER.getValue().equals(paramMap.get("filter_creditortype")) && EmptyUtil.isNoEmpty((Object)paramMap.get("filter_creditortext"))) {
            filterList.add(new QFilter("creditortext", "=", paramMap.get("filter_creditortext")));
        }
    }
}

