/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.accountacceptance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BusinessTypeEnum;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class InnerAccountAcceptanceEdit
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(InnerAccountAcceptanceEdit.class);
    private static final String BAR_BACK = "bar_back";
    private static final String BAR_HANDLE = "bar_handle";
    private static final String TMC_AM_FORMPLUGIN = "tmc-ifm-formplugin";
    private static final String[] HIDE_FIELDS = new String[]{"sourcedata", "modifier", "netbank", "number", "scorg", "sourcebillid", "authquerpt", "acctstatus", "status", "modifytime", "financialchapter", "ismulcurrency", "createtime", "creator", "inneracct", "org", "bankaccountnumber", "closereason", "bitindex", "srcindex", "finorgtype"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadAcctCheckInfo();
        this.initBillBusinessFieldComboEditControl();
    }

    private void loadAcctCheckInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long sourceId = dataEntity.getLong("sourceid");
        Object businessType = dataEntity.get("businesstype");
        if (Objects.equals(businessType, BusinessTypeEnum.OPEN.getValue()) || Objects.equals(businessType, BusinessTypeEnum.CHANGE.getValue()) || sourceId == 0L) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"am_acctclosebill", (String)"accountbank");
        DynamicObject bankAcct = (DynamicObject)dynamicObject.get("accountbank");
        if (null == bankAcct) {
            return;
        }
        long bankAcctId = bankAcct.getLong("id");
        Map recBill = InnerAcctHelper.loadRelBill((String)"cas_recbill", (Object)bankAcctId);
        if (!CollectionUtils.isEmpty((Map)recBill)) {
            ((Image)this.getView().getControl("recbillimg")).setUrl("/icons/pc/state/warning34_34.png");
        }
        String loadKDZhang = ResManager.loadKDString((String)"\u5f20", (String)"InnerAccountAcceptance_0", (String)TMC_AM_FORMPLUGIN, (Object[])new Object[0]);
        ((Label)this.getControl("recbill")).setText(recBill.size() + loadKDZhang);
        Map payBill = InnerAcctHelper.loadRelBill((String)"cas_paybill", (Object)bankAcctId);
        if (!CollectionUtils.isEmpty((Map)payBill)) {
            ((Image)this.getView().getControl("paybillimg")).setUrl("/icons/pc/state/warning34_34.png");
        }
        ((Label)this.getControl("paybill")).setText(payBill.size() + loadKDZhang);
        Map agentPayBills = InnerAcctHelper.loadRelBill((String)"cas_agentpaybill", (Object)bankAcctId);
        if (!CollectionUtils.isEmpty((Map)agentPayBills)) {
            ((Image)this.getView().getControl("agentpayimg")).setUrl("/icons/pc/state/warning34_34.png");
        }
        ((Label)this.getControl("agentpaybill")).setText(agentPayBills.size() + loadKDZhang);
        DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("currency");
        StringBuilder sb = new StringBuilder();
        if (null != currencys) {
            for (int i = 0; i < currencys.size(); ++i) {
                DynamicObject currency = ((DynamicObject)currencys.get(i)).getDynamicObject("fbasedataid");
                BigDecimal balance = Constants.ZERO;
                try {
                    balance = CasBusinessHelper.getBalance((long)bankAcct.getDynamicObject("company").getLong("id"), (long)bankAcctId, (long)currency.getLong("id"));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                if (balance.compareTo(Constants.ZERO) == 0) continue;
                if (sb.length() != 0) {
                    sb.append(" | ");
                }
                sb.append(currency.getString("sign")).append(TmcBusinessBaseHelper.formatDecimal((BigDecimal)balance, (int)currency.getInt("amtprecision")));
            }
        }
        if (sb.length() != 0) {
            ((Image)this.getView().getControl("daybillimg")).setUrl("/icons/pc/state/warning34_34.png");
        } else {
            sb.append('0');
        }
        ((Label)this.getControl("casmount")).setText(sb.toString());
        boolean journalIsCheck = CasBusinessHelper.journalIsCheck((DynamicObject)bankAcct);
        if (!journalIsCheck) {
            ((Image)this.getView().getControl("unreachimg")).setUrl("/icons/pc/state/warning34_34.png");
            ((Label)this.getControl("unreachmount")).setText(ResManager.loadKDString((String)"\u6709", (String)"InnerAccountAcceptance_1", (String)TMC_AM_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            ((Label)this.getControl("unreachmount")).setText(ResManager.loadKDString((String)"\u65e0", (String)"InnerAccountAcceptance_2", (String)TMC_AM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void popBackReasonWin() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setAppId("ifm");
        parameter.setFormId("ifm_payacceptance_back");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "back_action"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.equals("back_action", actionId)) {
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            Long primaryKeyValue = (Long)this.getModel().getDataEntity().getPkValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"ifm_accountacceptancebill");
            dynamicObject.set("backreason", returnData.get("reason"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("strictvalidation", String.valueOf(true));
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"back", (String)"ifm_accountacceptancebill", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)option);
            if (result.isSuccess()) {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u5355\u6210\u529f\u3002", (String)"InnerAccountAcceptance_8", (String)TMC_AM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "unaudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "preback": {
                this.popBackReasonWin();
                break;
            }
        }
    }

    private void initBillBusinessFieldComboEditControl() {
        ComboEdit businessBillComboEdit = (ComboEdit)this.getControl("e_changefield");
        Map<String, LocaleString> fieldColumn = this.getFields();
        ArrayList<ComboItem> businessBillComboItemList = new ArrayList<ComboItem>(fieldColumn.size());
        for (Map.Entry<String, LocaleString> entry : fieldColumn.entrySet()) {
            LocaleString displayName = entry.getValue();
            String key = entry.getKey();
            ComboItem comboItem = new ComboItem();
            if ("closedate".equals(key) || "createorg".equals(key)) continue;
            if ("managecurrency".equals(key)) {
                comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d26\u6237\u7ba1\u7406\u8d39\u5e01\u79cd", (String)"InnerAccountAcceptanceEdit_0", (String)TMC_AM_FORMPLUGIN, (Object[])new Object[0])));
                comboItem.setValue(key);
            } else if ("acctmanageamt".equals(key)) {
                comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d26\u6237\u7ba1\u7406\u8d39\u91d1\u989d", (String)"InnerAccountAcceptanceEdit_1", (String)TMC_AM_FORMPLUGIN, (Object[])new Object[0])));
                comboItem.setValue(key);
            } else {
                comboItem.setCaption(displayName);
                comboItem.setValue(key);
            }
            businessBillComboItemList.add(comboItem);
        }
        businessBillComboEdit.setComboItems(businessBillComboItemList);
    }

    private Map<String, LocaleString> getFields() {
        String businessBill = "am_accountbank";
        DynamicObject showFieldDy = QueryServiceHelper.queryOne((String)"am_changeapply_config", (String)"id,billno,showfields,company", null);
        if (EmptyUtil.isNoEmpty((DynamicObject)showFieldDy)) {
            String showFieldStr = showFieldDy.getString("showfields");
            Set keySet = Arrays.stream(showFieldStr.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)businessBill, (boolean)false, (boolean)true, (String[])HIDE_FIELDS);
            return fieldColumn.entrySet().stream().filter(entry -> keySet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return new HashMap<String, LocaleString>(1);
    }
}

