/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.accountfrozen;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.helper.InnerAccountBalanceHelper;

public class InnerAccountFrozenEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ACCOUNT_FROZEN_THAW = "account_frozen_thaw";
    private static final String ACCOUNT_FROZEN_COPY = "account_frozen_copy";
    private static final String INNER_ACC_FROZEN = "inner_acc_frozen";
    private static final String INNER_ACC_THAW = "inner_acc_thaw";

    public void registerListener(EventObject e) {
        ((BasedataEdit)this.getControl("account")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("settlecenter")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        IDataModel dataModel = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object accountParam = showParameter.getCustomParam("account");
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            DynamicObject settleCenter;
            if (accountParam != null) {
                DynamicObject innerAccount = TmcDataServiceHelper.loadSingle((Object)accountParam, (String)"ifm_inneracct", (String)"finorg");
                settleCenter = innerAccount.getDynamicObject("finorg");
            } else {
                settleCenter = IfmSettleCenterHelper.getSettleFinByOrg((Long)RequestContext.get().getOrgId());
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter)) {
                dataModel.setValue("settlecenter", (Object)settleCenter);
            }
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"latestaccountblance"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"totalfrozenamount"});
        String operation = (String)showParameter.getCustomParam("operation");
        Object frozenTypeParam = showParameter.getCustomParam("frozentype");
        if (EmptyUtil.isNoEmpty((String)operation)) {
            switch (operation) {
                case "account_frozen_thaw": {
                    this.setFieldNotEnable();
                    dataModel.setValue("account", accountParam);
                    dataModel.setValue("frozentype", frozenTypeParam);
                    dataModel.setValue("frozenenddate", showParameter.getCustomParam("frozenenddate"));
                    break;
                }
                case "account_frozen_copy": {
                    dataModel.setValue("latestaccountblance", null);
                    dataModel.setValue("totalfrozenamount", null);
                    dataModel.setValue("applydate", showParameter.getCustomParam("applydate"));
                    dataModel.setValue("frozenreason", showParameter.getCustomParam("frozenreason"));
                    dataModel.setValue("account", accountParam);
                    dataModel.setValue("frozentype", frozenTypeParam);
                    dataModel.setValue("frozenenddate", showParameter.getCustomParam("frozenenddate"));
                    break;
                }
                case "inner_acc_frozen": {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"account", "settlecenter"});
                    dataModel.setValue("account", accountParam);
                    dataModel.setValue("frozentype", frozenTypeParam);
                    break;
                }
                case "inner_acc_thaw": {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"account", "settlecenter", "frozentype"});
                    dataModel.setValue("account", accountParam);
                    dataModel.setValue("frozentype", frozenTypeParam);
                    break;
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateAcctcurBalance();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.updateAcctcurBalance();
    }

    private void setFieldNotEnable() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"settlecenter", "account", "frozentype", "frozenenddate"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        DynamicObject innerAccount = (DynamicObject)this.getModel().getValue("account");
        switch (propName) {
            case "account": {
                if (!EmptyUtil.isNoEmpty((DynamicObject)innerAccount)) break;
                this.updateAcctcurBalance();
                this.checkFrozenType(innerAccount);
                this.getModel().setValue("scorg", (Object)innerAccount.getLong("org.id"));
                break;
            }
            case "settlecenter": {
                this.getModel().setValue("account", null);
                break;
            }
            case "frozentype": {
                String frozenType = (String)e.getChangeSet()[0].getNewValue();
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InnerAccountFrozenTypeEnum.isAmountType((String)frozenType), (String[])new String[]{"frozenamount"});
                break;
            }
        }
    }

    private void updateAcctcurBalance() {
        DynamicObject innerAccount = (DynamicObject)this.getModel().getValue("account");
        if (EmptyUtil.isNoEmpty((DynamicObject)innerAccount)) {
            BigDecimal latestAmount = InnerAccountBalanceHelper.getInnerAcctCurBalance((Long)innerAccount.getLong("id"), (Date)new Date());
            this.getModel().setValue("latestaccountblance", (Object)latestAmount);
            this.getModel().setValue("currency", (Object)innerAccount.getDynamicObject("currency_dflt"));
            this.setTotalFronzenAmount(innerAccount);
        }
    }

    private void setTotalFronzenAmount(DynamicObject innerAccount) {
        QFilter qFilter = new QFilter("account", "=", (Object)innerAccount.getLong("id"));
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"ifm_accountfrozen", (String)"totalfrozenamount", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)datas)) {
            this.getModel().setValue("totalfrozenamount", (Object)((DynamicObject)datas.get(0)).getBigDecimal("totalfrozenamount"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName;
        switch (propName = args.getProperty().getName()) {
            case "account": {
                this.setAccountFilter(args);
                break;
            }
            case "settlecenter": {
                this.setSettleCenterFilter(args);
                break;
            }
        }
    }

    private void setAccountFilter(BeforeF7SelectEvent args) {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"settlecenter")) {
            args.setCancel(true);
            return;
        }
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        QFilter qFilter = new QFilter("finorg", "=", (Object)settleCenter.getLong("id"));
        ((ListShowParameter)args.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setSettleCenterFilter(BeforeF7SelectEvent event) {
        Set settleCenters = SettleCenterHelper.getAuthorizedSettleCenters((String)"ifm", (String)"ifm_accountfrozen", (String)"47150e89000000ac");
        List settleCenterIdList = settleCenters.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        Map finOrgInfoMap = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("finorgtype.type", "=", (Object)"1"), new QFilter("id", "in", settleCenterIdList)});
        List centerFinOrgIds = finOrgInfoMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", centerFinOrgIds);
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void checkFrozenType(DynamicObject innerAccount) {
        if (EmptyUtil.isEmpty((DynamicObject)innerAccount)) {
            return;
        }
        boolean isFrozen = InnerAcctStatusEnum.isFrozen((String)innerAccount.getString("acctstatus"));
        if (isFrozen) {
            this.getModel().setValue("frozentype", (Object)InnerAccountFrozenTypeEnum.ACCOUNT_THAW.getValue());
        } else {
            this.getModel().setValue("frozentype", (Object)InnerAccountFrozenTypeEnum.ACCOUNT_FROZEN.getValue());
        }
        this.getView().setEnable(Boolean.valueOf(!isFrozen), new String[]{"frozentype"});
    }
}

