/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.accountfrozen;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;
import kd.tmc.ifm.enums.InnerAccountFrozenStatusEnum;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class InnerAccountFrozenList
extends AbstractTmcDataBaseList {
    private static final String OPERATION = "operation";
    private static final String ACCOUNT_FROZEN_THAW = "account_frozen_thaw";
    private static final String ACCOUNT_FROZEN_COPY = "account_frozen_copy";
    private static final String TMC_IFM_FORMPLUGIN = "tmc-ifm-formplugin";
    private static final String SETTLE_CENTER_NAME = "settlecenter.name";
    private static final String SELECT_PROPERTIES = "id,settlecenter,account,frozenstatus,frozentype,frozenenddate,applydate,frozenreason";

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "thaw": {
                this.beforeThawOp(args);
                break;
            }
            case "copy": {
                this.beforeCopyOp(args);
                break;
            }
        }
    }

    private void beforeCopyOp(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            args.setCancel(true);
            return;
        }
        BillShowParameter showPara = new BillShowParameter();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"ifm_accountfrozen", (String)SELECT_PROPERTIES);
        String frozenType = dynamicObject.getString("frozentype");
        showPara.setCustomParam("frozentype", (Object)frozenType);
        this.initInnerAccountFrozenPage(showPara, dynamicObject);
        showPara.setCustomParam("frozenreason", (Object)dynamicObject.getString("frozenreason"));
        showPara.setCustomParam(OPERATION, (Object)ACCOUNT_FROZEN_COPY);
        this.getView().showForm((FormShowParameter)showPara);
    }

    private void beforeThawOp(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            args.setCancel(true);
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"ifm_accountfrozen", (String)SELECT_PROPERTIES);
        String frozenStatus = dynamicObject.getString("frozenstatus");
        String frozenType = dynamicObject.getString("frozentype");
        BillShowParameter showPara = new BillShowParameter();
        if (!InnerAccountFrozenStatusEnum.isFrozen((String)frozenStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u51bb\u7ed3\u72b6\u6001\u4e3a\u5df2\u51bb\u7ed3\u7684\u5355\u636e\u624d\u80fd\u89e3\u51bb\u3002", (String)"InnerAccountFrozenList_1", (String)TMC_IFM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (InnerAccountFrozenTypeEnum.isAccountFrozen((String)frozenType)) {
            showPara.setCustomParam("frozentype", (Object)InnerAccountFrozenTypeEnum.ACCOUNT_THAW.getValue());
        } else if (InnerAccountFrozenTypeEnum.isAmountFrozen((String)frozenType)) {
            showPara.setCustomParam("frozentype", (Object)InnerAccountFrozenTypeEnum.AMOUNT_THAW.getValue());
        }
        showPara.setCustomParam(OPERATION, (Object)ACCOUNT_FROZEN_THAW);
        this.initInnerAccountFrozenPage(showPara, dynamicObject);
        this.getView().showForm((FormShowParameter)showPara);
    }

    private void initInnerAccountFrozenPage(BillShowParameter showPara, DynamicObject dynamicObject) {
        DynamicObject settleCenter = dynamicObject.getDynamicObject("settlecenter");
        DynamicObject account = dynamicObject.getDynamicObject("account");
        showPara.setFormId("ifm_accountfrozen");
        showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showPara.setStatus(OperationStatus.ADDNEW);
        showPara.setCustomParam("settlecenter", (Object)settleCenter.getLong("id"));
        showPara.setCustomParam("account", (Object)account.getLong("id"));
        showPara.setCustomParam("frozenenddate", (Object)dynamicObject.getDate("frozenenddate"));
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        if (SETTLE_CENTER_NAME.equals(fieldName)) {
            Set settleCenters = SettleCenterHelper.getAuthorizedSettleCenters((String)"ifm", (String)"ifm_accountfrozen", (String)"47150e89000000ac");
            List settleCenterIdList = settleCenters.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            Map finOrgInfoMap = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("finorgtype.type", "=", (Object)"1"), new QFilter("id", "in", settleCenterIdList)});
            List centerFinOrgIds = finOrgInfoMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", centerFinOrgIds);
            return Collections.singletonList(qFilter);
        }
        return super.addCustomFilterForFilterCol(fieldName);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            DynamicObject settleCenter;
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!SETTLE_CENTER_NAME.equals(fieldName) || commonFilter.getDefValue() != null || !EmptyUtil.isNoEmpty((DynamicObject)(settleCenter = IfmSettleCenterHelper.getSettleFinByOrg((Long)RequestContext.get().getOrgId())))) continue;
            commonFilter.setDefaultValue(settleCenter.getString("id"));
        }
    }
}

