/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.balance;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class AccountBalanceList
extends AbstractTmcListPlugin {
    private static final String BANKID = "bankid";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!fieldName.startsWith("company")) continue;
            commonFilter.setDefaultValue("");
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if ("company.name".equals(fieldName) || "accountbank.name".equals(fieldName)) {
            List commonFilterValue = ((FilterColumnSetFilterEvent)args).getCommonFilterValue("accountbank.bank.name");
            if (EmptyUtil.isEmpty((Collection)commonFilterValue)) {
                this.getPageCache().remove(BANKID);
            } else {
                this.getPageCache().put(BANKID, String.join((CharSequence)",", commonFilterValue.stream().map(String::valueOf).collect(Collectors.toSet())));
            }
        }
        args.getQFilters().add(this.addQfilter(fieldName));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        args.getQfilters().add(this.addQfilter(fieldName));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "transdetail": {
                IListView listview = (IListView)this.getView();
                DynamicObject accountBalance = TmcDataServiceHelper.loadSingle((Object)listview.getFocusRowPkId(), (String)"ifm_accountbalance", (String)"company,accountbank,bank,currency,bizdate");
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("ifm_transdetail");
                showParameter.setFormId("bos_list");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                Map customParams = showParameter.getCustomParams();
                DynamicObject company = accountBalance.getDynamicObject("company");
                customParams.put("company", company != null ? company.getPkValue() : null);
                DynamicObject accountBank = accountBalance.getDynamicObject("accountbank");
                customParams.put("accountbank", accountBank != null ? accountBank.getPkValue() : null);
                DynamicObject currency = accountBalance.getDynamicObject("currency");
                customParams.put("currency", currency != null ? currency.getPkValue() : null);
                DynamicObject bank = accountBalance.getDynamicObject("bank");
                customParams.put("bank", bank != null ? bank.getPkValue() : null);
                customParams.put("bizdate", accountBalance.getDate("bizdate"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    private QFilter addQfilter(String fieldName) {
        QFilter filter = null;
        if (fieldName.startsWith("accountbank.bank") && !"accountbank.bankaccountnumber".equals(fieldName)) {
            filter = this.bankFilter();
        } else if (fieldName.startsWith("company")) {
            filter = this.companyFilter();
        } else if (fieldName.startsWith("accountbank.id") || fieldName.startsWith("accountbank.name")) {
            String bankid = this.getPageCache().get(BANKID);
            filter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
            if (EmptyUtil.isNoEmpty((String)bankid)) {
                this.getPageCache().remove(BANKID);
                Set bankIds = Arrays.stream(bankid.split(",")).map(Long::parseLong).collect(Collectors.toSet());
                filter.and(new QFilter("bank", "in", bankIds));
            }
        }
        return filter;
    }

    private QFilter bankFilter() {
        Set settleCenters = SettleCenterHelper.getAuthorizedSettleCenters((String)this.getView().getFormShowParameter().getAppId(), (String)"ifm_accountbalance", (String)"47150e89000000ac");
        Set settleIds = settleCenters.parallelStream().filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        return new QFilter("id", "in", settleIds);
    }

    private QFilter companyFilter() {
        String bankid = this.getPageCache().get(BANKID);
        if (EmptyUtil.isNoEmpty((String)bankid)) {
            this.getPageCache().remove(BANKID);
            Set bankIds = Arrays.stream(bankid.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            Map innerBank = TmcDataServiceHelper.loadFromCache((String)"ifm_inneracct", (String)"company", (QFilter[])new QFilter[]{new QFilter("finorg", "in", bankIds)});
            Set companys = innerBank.values().parallelStream().map(o -> o.getDynamicObject("company").getPkValue()).collect(Collectors.toSet());
            return new QFilter("id", "in", companys);
        }
        return null;
    }
}

