/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.balance;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.biz.balance.model.IBalanceUpdatePlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.InnerAcctFrozenHelper;

public class BalanceUpdatePlugin
extends AbstractFormPlugin
implements IBalanceUpdatePlugin {
    private static final Log logger = LogFactory.getLog(BalanceUpdatePlugin.class);
    private static final String UPDATE_LSTBALANCE_SQL = "UPDATE T_Bei_BankBalance SET FLstBalance = ? WHERE FId = ?";
    private static final String UPDATE_VALIBALANCE_NEW_SQL = "UPDATE T_Bei_BankBalance SET FValiBalance = (case when FAmount-?>0 then FAmount-? else 0 end), FFreezeBalance = ? WHERE FId = ?";
    private static final String UPDATE_VALIBALANCE_SQL = "UPDATE T_Bei_BankBalance SET FValiBalance = FAmount, FFreezeBalance = 0 WHERE FId = ?";
    private static final String UPDATE_BALANCE_SQL = "UPDATE T_Bei_BankBalance SET FAmount = FLstBalance + FCreditAmount - FDebitAmount, fmodifytime=?, fenddate=? where Fid =? ";
    private static final String UPDATE_BALANCE_ENDDATE = "UPDATE T_Bei_BankBalance SET Fenddate =? where fid=?";

    public void afterUpdate(BalanceUpdateArgs args) {
        HashSet<Long> idSet = new HashSet<Long>(2);
        DataSet ds = this.queryBalanceData(args);
        while (ds.hasNext()) {
            Row row = ds.next();
            Long id = row.getLong("Fid");
            Date endDate = row.getDate("fenddate");
            DynamicObject lastBalance = this.queryLstBalance(row);
            if (lastBalance != null) {
                this.updateLstBalanceEndate(lastBalance.getLong("id"), row.getDate("fbizdate"));
                endDate = this.queryNextBalanceEndDate(row);
                this.updateLstBalance(id, lastBalance.getBigDecimal("amount"));
            } else if (EmptyUtil.isEmpty((Object)row.getDate("fenddate"))) {
                endDate = this.queryNextBalanceEndDate(row);
            }
            this.updateBalance(id, endDate);
            this.updateValidBalance(row);
            idSet.add(id);
        }
        this.sendRecalMessage(idSet);
    }

    public void afterRollback(BalanceUpdateArgs args) {
        HashSet<Long> idSet = new HashSet<Long>(2);
        DataSet ds = this.queryBalanceData(args);
        while (ds.hasNext()) {
            Row row = ds.next();
            Long id = row.getLong("Fid");
            Date endDate = row.getDate("fenddate");
            this.updateBalance(id, endDate);
            this.updateValidBalance(row);
            idSet.add(id);
        }
        this.sendRecalMessage(idSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRecalMessage(Set<Long> ids) {
        MessagePublisher pub = null;
        try {
            pub = MQFactory.get().createSimplePublisher("tmc", "tmc.innerbal_queue");
        }
        catch (KDException e) {
            logger.warn("tmc.innerbal_queue:", (Throwable)e);
            pub = MQFactory.get().createSimplePublisher("tmc", "innerbal_queue");
        }
        try {
            pub.publishInDbTranscation(DBRouteConst.TMC.getRouteKey(), ids);
        }
        finally {
            pub.close();
        }
    }

    private DataSet queryBalanceData(BalanceUpdateArgs args) {
        return args.getUpdatedBalData("Fid,FCompanyId,FAccountBankId,FCurrencyId,FBizDate,fenddate,FAmount,FLstBalance");
    }

    private DynamicObject queryLstBalance(Row row) {
        BigDecimal lstBalance = row.getBigDecimal("FLstBalance");
        if (EmptyUtil.isNoEmpty((BigDecimal)lstBalance) && EmptyUtil.isNoEmpty((Object)row.getDate("fenddate"))) {
            return null;
        }
        Long innerAcctId = row.getLong("FAccountBankId");
        Long currencyId = row.getLong("FCurrencyId");
        Date bizDate = row.getDate("FBizDate");
        QFilter filter = new QFilter("accountbank.id", "=", (Object)innerAcctId);
        filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        filter.and(new QFilter("bizdate", "<", (Object)bizDate));
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"id,amount", (QFilter[])filter.toArray(), (String)"bizdate desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)colls)) {
            return (DynamicObject)colls.get(0);
        }
        return null;
    }

    private Date queryNextBalanceEndDate(Row row) {
        Long innerAcctId = row.getLong("FAccountBankId");
        Long currencyId = row.getLong("FCurrencyId");
        Date bizDate = row.getDate("FBizDate");
        QFilter filter = new QFilter("accountbank.id", "=", (Object)innerAcctId);
        filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        filter.and(new QFilter("bizdate", ">", (Object)bizDate));
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"bizdate", (QFilter[])filter.toArray(), (String)"bizdate", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)colls)) {
            return ((DynamicObject)colls.get(0)).getDate("bizdate");
        }
        return DateUtils.stringToDate((String)"9999-12-31", (String)"yyyy-MM-dd");
    }

    private void updateLstBalance(Long id, BigDecimal lstBalance) {
        DB.update((DBRoute)DBRouteConst.TMC, (String)UPDATE_LSTBALANCE_SQL, (Object[])new Object[]{lstBalance, id});
    }

    private void updateLstBalanceEndate(Long id, Date endDate) {
        DB.update((DBRoute)DBRouteConst.TMC, (String)UPDATE_BALANCE_ENDDATE, (Object[])new Object[]{endDate, id});
    }

    private void updateBalance(Long id, Date endDate) {
        DB.update((DBRoute)DBRouteConst.TMC, (String)UPDATE_BALANCE_SQL, (Object[])new Object[]{new Date(), endDate, id});
    }

    private void updateValidBalance(Row row) {
        this.updateValidBalanceByFrozenAmount(row);
    }

    private void updateValidBalanceByFrozenAmount(Row row) {
        Long accountBankId = row.getLong("FAccountBankId");
        Long id = row.getLong("FId");
        BigDecimal frozenAmount = InnerAcctFrozenHelper.getTotalFrozenAmountByAcctBankId((Long)accountBankId, (Date)row.getDate("FBizDate"));
        if (frozenAmount.compareTo(BigDecimal.ZERO) <= 0) {
            DB.update((DBRoute)DBRouteConst.TMC, (String)UPDATE_VALIBALANCE_SQL, (Object[])new Object[]{row.getLong("Fid")});
            return;
        }
        DB.update((DBRoute)DBRouteConst.TMC, (String)UPDATE_VALIBALANCE_NEW_SQL, (Object[])new Object[]{frozenAmount, frozenAmount, frozenAmount, id});
    }
}

