/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.bankint;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.formplugin.list.preint.AbstractTmcIntBillBatchList;
import kd.tmc.fbp.formplugin.list.preint.TmcIntBillListParam;

public abstract class AbstractBankIntEList
extends AbstractTmcIntBillBatchList {
    protected TmcIntBillListParam getIntBillListParam() {
        TmcIntBillListParam param = new TmcIntBillListParam();
        param.setNavAddNewFormId(this.getNavAddNewFormId()).setTrackDownEntityName(this.getTrackDownEntityName()).setTrackUpEntityName("ifm_bankacctintobject");
        return param;
    }

    protected List<Long> getTrackUpEntityIds(DynamicObject[] batchBills) {
        ArrayList<Long> trackUpBillIds = new ArrayList<Long>(16);
        for (DynamicObject batchBill : batchBills) {
            DynamicObjectCollection entry = batchBill.getDynamicObjectCollection("entry");
            List ids = entry.stream().map(v -> v.getDynamicObject("intobject").getLong("id")).collect(Collectors.toList());
            trackUpBillIds.addAll(ids);
        }
        return trackUpBillIds;
    }

    protected List<Long> getTrackDownEntityIds(DynamicObject[] batchBills) {
        ArrayList<Long> trackDownBillIds = new ArrayList<Long>(16);
        for (DynamicObject batchBill : batchBills) {
            DynamicObjectCollection entry = batchBill.getDynamicObjectCollection("entry");
            List ids = entry.stream().map(v -> v.getLong("intbillid")).collect(Collectors.toList());
            trackDownBillIds.addAll(ids);
        }
        return trackDownBillIds;
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("biztype", "=", (Object)this.getBizType()));
    }

    protected abstract String getBizType();

    protected abstract String getTrackDownEntityName();

    protected abstract String getNavAddNewFormId();
}

